/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.shelve;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4ShelvedChangelist;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.shelve.Messages;
import com.perforce.team.ui.shelve.ShelveFileDialog;
import com.perforce.team.ui.shelve.UpdateShelveDialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.TeamException;

public class DeleteShelveFileAction
extends P4Action {
    @Override
    protected boolean isEnabledEx() throws TeamException {
        boolean enabled = false;
        IStructuredSelection fileSelection = this.getSelection();
        boolean bl = enabled = fileSelection != null && !fileSelection.isEmpty();
        if (enabled) {
            Object[] objectArray = fileSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object resource = objectArray[n2];
                if (resource instanceof IP4ShelveFile) {
                    if (((IP4ShelveFile)resource).isReadOnly()) {
                        enabled = false;
                        break;
                    }
                } else if (resource instanceof IP4File) {
                    if (((IP4File)resource).isReadOnly()) {
                        enabled = false;
                        break;
                    }
                } else {
                    enabled = false;
                    break;
                }
                ++n2;
            }
        }
        return enabled;
    }

    @Override
    protected void runAction() {
        final IStructuredSelection fileSelection = this.getSelection();
        if (fileSelection != null && !fileSelection.isEmpty()) {
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    HashMap<IP4PendingChangelist, ArrayList<IP4File>> listMappings = new HashMap<IP4PendingChangelist, ArrayList<IP4File>>();
                    Object[] objectArray = fileSelection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IP4File file;
                        IP4PendingChangelist list;
                        Object resource = objectArray[n2];
                        if (resource instanceof IP4ShelveFile) {
                            resource = ((IP4ShelveFile)resource).getFile();
                        }
                        if (resource instanceof IP4File && (list = (file = (IP4File)resource).getChangelist(true)) != null && !list.isReadOnly()) {
                            ArrayList<IP4File> listFiles = (ArrayList<IP4File>)listMappings.get(list);
                            if (listFiles == null) {
                                listFiles = new ArrayList<IP4File>();
                                listMappings.put(list, listFiles);
                            }
                            listFiles.add(file);
                        }
                        ++n2;
                    }
                    if (!listMappings.isEmpty()) {
                        for (Map.Entry entry : listMappings.entrySet()) {
                            final IP4PendingChangelist list = (IP4PendingChangelist)entry.getKey();
                            final List listFiles = (List)entry.getValue();
                            P4ShelvedChangelist shelved = new P4ShelvedChangelist(list.getConnection(), list.getChangelist(), list.isReadOnly());
                            shelved.refresh();
                            final ArrayList<IP4File> allFiles = new ArrayList<IP4File>();
                            IP4Resource[] iP4ResourceArray = shelved.members();
                            int n3 = iP4ResourceArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IP4Resource file = iP4ResourceArray[n4];
                                if (file instanceof IP4ShelveFile) {
                                    allFiles.add(((IP4ShelveFile)file).getFile());
                                }
                                ++n4;
                            }
                            PerforceUIPlugin.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ShelveFileDialog dialog = new ShelveFileDialog(P4UIUtils.getDialogShell(), list, allFiles.toArray(new IP4Resource[allFiles.size()]), listFiles.toArray(new IP4Resource[listFiles.size()]), UpdateShelveDialog.Option.DELETE);
                                    if (dialog.open() == 0) {
                                        DeleteShelveFileAction.this.shelveDelete(list, dialog.getSelectedFiles());
                                    }
                                }
                            });
                        }
                    }
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }

    private void shelveDelete(final IP4PendingChangelist pending, final IP4Resource[] files) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(DeleteShelveFileAction.this.generateTitle(Messages.DeleteShelveFileAction_DeletingShelvedFiles, files, IP4Resource.Type.REMOTE), 1);
                if (pending != null) {
                    pending.deleteShelve(files);
                    monitor.worked(1);
                }
                monitor.done();
            }

            public String getTitle() {
                return MessageFormat.format(Messages.DeleteShelveFileAction_DeletingShelvedFilesFromChangelist, pending.getId());
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }
}

