/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.project;

import com.perforce.team.core.p4java.IP4Container;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class P4DepotContainerCheckedTreeViewer
extends CheckboxTreeViewer {
    private Set<Object> childrenOnlySet = new HashSet<Object>();

    public boolean addChildOnlyNode(Object obj) {
        return this.childrenOnlySet.add(obj);
    }

    public boolean removeChildOnlyNode(Object obj) {
        return this.childrenOnlySet.remove(obj);
    }

    public String getChildOnlySet() {
        return Arrays.toString(this.childrenOnlySet.toArray());
    }

    public P4DepotContainerCheckedTreeViewer(Composite parent) {
        super(parent);
        this.initViewer();
    }

    public P4DepotContainerCheckedTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.initViewer();
    }

    public P4DepotContainerCheckedTreeViewer(Tree tree) {
        super(tree);
        this.initViewer();
    }

    private void initViewer() {
        this.setUseHashlookup(true);
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                P4DepotContainerCheckedTreeViewer.this.doCheckStateChanged(event.getElement());
            }
        });
        this.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Widget item = P4DepotContainerCheckedTreeViewer.this.findItem(event.getElement());
                if (item instanceof TreeItem) {
                    P4DepotContainerCheckedTreeViewer.this.initializeItem((TreeItem)item);
                }
            }
        });
    }

    protected void doCheckStateChanged(Object element) {
        Widget item = this.findItem(element);
        if (item instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)item;
            treeItem.setGrayed(false);
            this.updateChildrenItems(treeItem);
            this.updateParentItems(treeItem.getParentItem());
        }
    }

    protected void doGrayStateChanged(Object element) {
        Widget item = this.findItem(element);
        if (item instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)item;
            this.updateParentItems(treeItem.getParentItem());
        }
    }

    private void updateChildrenItems(TreeItem parent) {
        Item[] children = this.getChildren((Widget)parent);
        boolean state = parent.getChecked();
        int i = 0;
        while (i < children.length) {
            TreeItem curr = (TreeItem)children[i];
            if (curr.getData() != null && (curr.getChecked() != state || curr.getGrayed())) {
                if (curr.getData() instanceof IP4Container) {
                    curr.setChecked(state);
                    curr.setGrayed(false);
                    this.updateChildrenItems(curr);
                } else {
                    curr.setChecked(false);
                    curr.setGrayed(false);
                }
            }
            ++i;
        }
    }

    private void updateParentItems(TreeItem item) {
        if (item != null) {
            Item[] children = this.getChildren((Widget)item);
            boolean containsChecked = false;
            boolean containsUnchecked = false;
            boolean containsGrayChecked = false;
            boolean hasContainerChildren = false;
            int i = 0;
            while (i < children.length) {
                TreeItem curr = (TreeItem)children[i];
                if (curr.getData() instanceof IP4Container) {
                    hasContainerChildren = true;
                    containsChecked |= curr.getChecked();
                    containsUnchecked |= !curr.getChecked();
                    containsGrayChecked |= curr.getGrayed() && curr.getChecked();
                } else {
                    containsUnchecked = true;
                }
                ++i;
            }
            if (hasContainerChildren) {
                Tracing.printTrace((String)((Object)((Object)this)).getClass().getSimpleName(), (String)MessageFormat.format("updateParentItems(): chlidrenOnlySet= {0}", this.getChildOnlySet()));
                item.setChecked(containsChecked);
                if (!containsUnchecked && children.length == 1) {
                    item.setGrayed(containsChecked);
                } else {
                    item.setChecked(containsChecked);
                    item.setGrayed(containsChecked && containsUnchecked || containsGrayChecked || this.childrenOnlySet.contains(item.getData()));
                }
            }
            this.updateParentItems(item.getParentItem());
        }
    }

    private void initializeItem(TreeItem item) {
        if (item.getChecked() && !item.getGrayed()) {
            this.updateChildrenItems(item);
        }
    }

    public boolean setChecked(Object element, boolean state) {
        if (super.setChecked(element, state)) {
            this.doCheckStateChanged(element);
            return true;
        }
        return false;
    }

    public boolean setGrayed(Object element, boolean state) {
        if (super.setGrayed(element, state)) {
            this.doGrayStateChanged(element);
            return true;
        }
        return false;
    }

    public void setCheckedElements(Object[] elements) {
        super.setCheckedElements(elements);
        int i = 0;
        while (i < elements.length) {
            this.doCheckStateChanged(elements[i]);
            ++i;
        }
    }

    protected void setExpanded(Item item, boolean expand) {
        super.setExpanded(item, expand);
        if (expand && item instanceof TreeItem) {
            this.initializeItem((TreeItem)item);
        }
    }

    public Object[] getCheckedElements() {
        Object[] checked = super.getCheckedElements();
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < checked.length) {
            Item[] children;
            Object curr = checked[i];
            result.add(curr);
            Widget item = this.findItem(curr);
            if (item != null && (children = this.getChildren(item)).length == 1 && children[0].getData() == null) {
                this.collectChildren(curr, result);
            }
            ++i;
        }
        return result.toArray();
    }

    private void collectChildren(Object element, ArrayList<Object> result) {
        Object[] filteredChildren = this.getFilteredChildren(element);
        int i = 0;
        while (i < filteredChildren.length) {
            Object curr = filteredChildren[i];
            result.add(curr);
            this.collectChildren(curr, result);
            ++i;
        }
    }
}

