/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.project;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.connection.AbstractConnectionWizard;
import com.perforce.team.ui.connection.ClientWizardPage;
import com.perforce.team.ui.connection.IConnectionWizard;
import com.perforce.team.ui.connection.ServerWizardPage;
import com.perforce.team.ui.project.ConnectionSelectionPage;
import com.perforce.team.ui.project.ImportProjectsWizardPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ExistingProjectWizard
extends AbstractConnectionWizard
implements IConnectionWizard,
INewWizard,
IImportWizard {
    private ConnectionSelectionPage connectionPage;

    public void addPages() {
        this.connectionPage = new ConnectionSelectionPage("connectionPage");
        this.addPage((IWizardPage)this.connectionPage);
        this.serverPage = new ServerWizardPage("serverPage");
        this.addPage((IWizardPage)this.serverPage);
        this.clientPage = new ClientWizardPage("clientPage");
        this.addPage((IWizardPage)this.clientPage);
        this.importPage = new ImportProjectsWizardPage("importPage", false);
        this.addPage((IWizardPage)this.importPage);
    }

    @Override
    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.connectionPage.getConnectionViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ExistingProjectWizard.this.getContainer().showPage(ExistingProjectWizard.this.getNextPage((IWizardPage)ExistingProjectWizard.this.connectionPage));
            }
        });
    }

    @Override
    public boolean performFinish() {
        if (this.connectionPage.isExistingConnection()) {
            try {
                this.getContainer().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IP4Connection connection = ExistingProjectWizard.this.connectionPage.getConnection();
                        ExistingProjectWizard.this.importProjects(connection, monitor);
                    }
                });
            }
            catch (InvocationTargetException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            catch (InterruptedException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        } else {
            return super.performFinish();
        }
        return true;
    }

    @Override
    public String getClient() {
        if (this.connectionPage.isExistingConnection()) {
            return this.connectionPage.getConnection().getParameters().getClient();
        }
        return this.clientPage.getClient();
    }

    @Override
    public String getPort() {
        if (this.connectionPage.isExistingConnection()) {
            return this.connectionPage.getConnection().getParameters().getPort();
        }
        return this.serverPage.getPort();
    }

    @Override
    public String getUser() {
        if (this.connectionPage.isExistingConnection()) {
            return this.connectionPage.getConnection().getParameters().getUser();
        }
        return this.serverPage.getUser();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.connectionPage) {
            if (this.connectionPage.isExistingConnection()) {
                return this.importPage;
            }
            return this.serverPage;
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        if (this.connectionPage.isExistingConnection()) {
            return this.connectionPage.isPageComplete() && this.importPage.isPageComplete();
        }
        return this.importPage.isPageComplete() && this.clientPage.isPageComplete() && this.serverPage.isPageComplete();
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    @Override
    public String getCharset() {
        if (this.connectionPage.isExistingConnection()) {
            return this.connectionPage.getConnection().getParameters().getCharset();
        }
        return this.serverPage.getCharset();
    }

    @Override
    public String getPassword() {
        if (this.connectionPage.isExistingConnection()) {
            return this.connectionPage.getConnection().getParameters().getPassword();
        }
        return this.serverPage.getPassword();
    }

    @Override
    public boolean isIgnoreSSLValidation() {
        return this.serverPage.isIgnoreSSLValidation();
    }
}

