/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.preferences.decorators;

import com.perforce.team.ui.dialogs.PerforceDialog;
import com.perforce.team.ui.preferences.decorators.Messages;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class VariablesDialog
extends PerforceDialog {
    private String[] variables = new String[0];
    private String[] descriptions = new String[0];
    private String[] selected = new String[0];
    private Composite displayArea;
    private Label varLabel;
    private CheckboxTableViewer varTable;

    public VariablesDialog(Shell parent, String[] variables, String[] descriptions) {
        super(parent, Messages.VariablesDialog_AddVariables);
        this.setModalResizeStyle();
        if (variables != null && descriptions != null && variables.length == descriptions.length) {
            this.variables = variables;
            this.descriptions = new String[descriptions.length];
            int i = 0;
            while (i < this.variables.length) {
                this.descriptions[i] = String.valueOf(this.variables[i]) + " - " + descriptions[i];
                ++i;
            }
        }
    }

    public String[] getAvailableVariables() {
        return this.variables;
    }

    public String[] getDescriptions() {
        return this.descriptions;
    }

    public String[] getSelectedVariables() {
        return this.selected;
    }

    public CheckboxTableViewer getViewer() {
        return this.varTable;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.displayArea = new Composite(c, 0);
        this.displayArea.setLayout((Layout)new GridLayout(1, true));
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.varLabel = new Label(this.displayArea, 16384);
        this.varLabel.setText(Messages.VariablesDialog_SelectVariablesToAdd);
        this.varTable = CheckboxTableViewer.newCheckList((Composite)this.displayArea, (int)68356);
        this.varTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ArrayList<String> selected = new ArrayList<String>();
                TableItem[] tableItemArray = VariablesDialog.this.varTable.getTable().getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getChecked()) {
                        selected.add(VariablesDialog.this.variables[VariablesDialog.this.varTable.getTable().indexOf(item)]);
                    }
                    ++n2;
                }
                VariablesDialog.this.selected = selected.toArray(new String[0]);
            }
        });
        this.varTable.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.varTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.varTable.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.varTable.setInput((Object)this.descriptions);
        return c;
    }
}

