/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.pending;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.pending.Messages;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.ui.progress.UIJob;

public class PendingListener
implements IP4Listener {
    protected TreeViewer viewer;

    public PendingListener(TreeViewer viewer) {
        this.viewer = viewer;
        this.viewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                P4ConnectionManager.getManager().removeListener(PendingListener.this);
            }
        });
        P4ConnectionManager.getManager().addListener(this);
    }

    public boolean okToUse() {
        return this.viewer != null && this.viewer.getTree() != null && !this.viewer.getTree().isDisposed();
    }

    protected void addLists(IP4Resource[] resources) {
        IP4Resource[] iP4ResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4PendingChangelist && ((IP4PendingChangelist)resource).getId() > 0) {
                this.viewer.add(this.viewer.getInput(), (Object)resource);
            }
            ++n2;
        }
    }

    protected void handleUpdateEvent(Object[] elements) {
        this.viewer.update(elements, null);
    }

    protected void handleJobEvent(IP4Resource[] resources, boolean reveal, P4Event.EventType type) {
        ArrayList<IP4PendingChangelist> processed = new ArrayList<IP4PendingChangelist>();
        if (resources.length > 0) {
            IP4Resource[] iP4ResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Container parent;
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4Job && (parent = resource.getParent()) instanceof IP4PendingChangelist && !processed.contains(parent)) {
                    this.viewer.refresh((Object)parent);
                    processed.add((IP4PendingChangelist)parent);
                    if (reveal) {
                        this.viewer.reveal((Object)resource);
                    }
                }
                ++n2;
            }
        }
    }

    protected void handleRemoveEvent(Object[] elements) {
        this.viewer.remove(elements);
    }

    protected void handleSubmitChangelistEvent(IP4PendingChangelist[] lists) {
        if (lists.length > 0) {
            this.viewer.remove((Object[])lists);
            ArrayList<IP4PendingChangelist> processed = new ArrayList<IP4PendingChangelist>();
            IP4PendingChangelist[] iP4PendingChangelistArray = lists;
            int n = lists.length;
            int n2 = 0;
            while (n2 < n) {
                IP4PendingChangelist defaultChangelist;
                IP4PendingChangelist list = iP4PendingChangelistArray[n2];
                IP4Connection connection = list.getConnection();
                if (connection != null && (defaultChangelist = connection.getPendingChangelist(0)) != null && !processed.contains(defaultChangelist)) {
                    defaultChangelist.markForRefresh();
                    this.viewer.refresh((Object)defaultChangelist);
                    processed.add(defaultChangelist);
                }
                ++n2;
            }
        }
    }

    protected void handleOpened(IP4File[] files) {
        ArrayList<IP4PendingChangelist> processed = new ArrayList<IP4PendingChangelist>();
        IP4File[] iP4FileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IP4File file = iP4FileArray[n2];
            IP4PendingChangelist list = file.getChangelist();
            if (list != null && !processed.contains(list)) {
                this.viewer.refresh((Object)list);
                this.viewer.reveal((Object)file);
                processed.add(list);
            }
            ++n2;
        }
    }

    protected void handleRefresh(IP4Resource[] resources) {
        ArrayList<IP4PendingChangelist> processed = new ArrayList<IP4PendingChangelist>();
        IP4Resource[] iP4ResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4File) {
                IP4File file = (IP4File)resource;
                if (!file.isOpened()) {
                    this.viewer.remove((Object)file);
                } else {
                    IP4PendingChangelist list = file.getChangelist();
                    if (list != null && !processed.contains(list)) {
                        this.viewer.refresh((Object)list);
                        this.handleExpand((IP4Resource)list);
                        processed.add(list);
                    }
                }
            } else if (resource instanceof IP4PendingChangelist && !processed.contains(resource)) {
                this.viewer.refresh((Object)resource);
                this.handleExpand(resource);
                processed.add((IP4PendingChangelist)resource);
            }
            ++n2;
        }
    }

    protected void handleExpand(IP4Resource resource) {
        if (this.viewer.getExpandedState((Object)resource)) {
            this.viewer.expandToLevel((Object)resource, 2);
        }
    }

    public void resoureChanged(final P4Event event) {
        P4Event.EventType type = event.getType();
        if (type != P4Event.EventType.CREATE_CHANGELIST && type != P4Event.EventType.DELETE_CHANGELIST && type != P4Event.EventType.CHANGED && type != P4Event.EventType.FIXED && type != P4Event.EventType.UNFIXED && type != P4Event.EventType.REFRESHED && type != P4Event.EventType.OPENED && type != P4Event.EventType.REVERTED && type != P4Event.EventType.SUBMITTED && type != P4Event.EventType.SUBMIT_CHANGELIST && type != P4Event.EventType.DELETE_SHELVE && type != P4Event.EventType.UPDATE_SHELVE && type != P4Event.EventType.CREATE_SHELVE) {
            return;
        }
        UIJob job = new UIJob(Messages.PendingListener_UpdatingPendingChangelistView){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (PendingListener.this.okToUse() && PendingListener.this.viewer.getInput() != null) {
                    P4Event.EventType type = event.getType();
                    switch (type) {
                        case REFRESHED: 
                        case CREATE_SHELVE: 
                        case DELETE_SHELVE: 
                        case UPDATE_SHELVE: {
                            PendingListener.this.handleRefresh(event.getResources());
                            break;
                        }
                        case CHANGED: {
                            PendingListener.this.handleUpdateEvent(event.getPending());
                            break;
                        }
                        case FIXED: {
                            PendingListener.this.handleJobEvent(event.getResources(), true, type);
                            break;
                        }
                        case UNFIXED: {
                            PendingListener.this.handleJobEvent(event.getResources(), false, type);
                            break;
                        }
                        case CREATE_CHANGELIST: {
                            PendingListener.this.addLists(event.getResources());
                            break;
                        }
                        case DELETE_CHANGELIST: {
                            PendingListener.this.handleRemoveEvent(event.getPending());
                            break;
                        }
                        case SUBMIT_CHANGELIST: {
                            PendingListener.this.handleSubmitChangelistEvent(event.getPending());
                            break;
                        }
                        case SUBMITTED: {
                            PendingListener.this.handleRemoveEvent(event.getUnopenedFiles());
                            break;
                        }
                        case REVERTED: {
                            PendingListener.this.handleRemoveEvent(event.getFiles());
                            break;
                        }
                        case OPENED: {
                            PendingListener.this.handleOpened(event.getFiles());
                            break;
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }
}

