/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4merge;

import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.option.client.ResolveFilesAutoOptions;
import com.perforce.team.core.P4ClientUtil;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.p4merge.MergeRunner;
import java.util.ArrayList;

public class P4MergeResolveAction
extends P4Action {
    public MergeRunner[] runApplication() {
        ArrayList<MergeRunner> runners = new ArrayList<MergeRunner>();
        P4Collection collection = this.getResourceSelection();
        IP4Resource[] iP4ResourceArray = collection.members();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4File file;
            MergeRunner runner;
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4File && (runner = this.runApplication(file = (IP4File)resource, 0)) != null) {
                runners.add(runner);
            }
            ++n2;
        }
        return runners.toArray(new MergeRunner[0]);
    }

    public MergeRunner runApplication(IP4File file, int whichIntegSpec) {
        if (file == null) {
            return null;
        }
        this.createCollection(new IP4Resource[]{file}).resolve(new ResolveFilesAutoOptions().setShowActionsOnly(true).setShowBase(true).setResolveFileContentChanges(true));
        if (file.getIntegrationSpecs().length == 0) {
            return null;
        }
        IFileSpec integSpec = file.getIntegrationSpecs()[whichIntegSpec];
        int baseRev = P4ClientUtil.getBaseRev((IFileSpec)integSpec);
        String basePath = String.valueOf(P4ClientUtil.getBaseFile((IFileSpec)integSpec)) + "#" + baseRev;
        int startFromRev = Math.max(1, integSpec.getStartFromRev());
        int endFromRev = integSpec.getEndFromRev();
        String theirsPath = String.valueOf(integSpec.getFromFile()) + P4ClientUtil.computeTheirRev((IFileSpec)integSpec);
        String yoursPath = file.getLocalPath();
        MergeRunner runner = new MergeRunner(file.getConnection(), file, basePath, true, theirsPath, true, yoursPath, false, startFromRev, endFromRev);
        runner.setAsync(this.isAsync());
        runner.run();
        return runner;
    }

    public IP4Resource runResolve(IP4File file, int whichIntegSpec) {
        MergeRunner runner = this.runApplication(file, whichIntegSpec);
        if (runner == null) {
            return null;
        }
        return runner.getResolved();
    }

    @Override
    protected void runAction() {
    }
}

