/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.p4java.dialogs.IntegrateToStreamDialog;
import com.perforce.team.ui.p4java.dialogs.Messages;
import com.perforce.team.ui.resource.ResourceBrowserDialog;
import com.perforce.team.ui.views.SessionManager;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SourceTargetWidget
extends Composite
implements IntegrateToStreamDialog.ISourceTargetWidget<String> {
    private Combo sourceText;
    private Combo targetText;
    private String sourcePath = null;
    private String targetPath = null;
    private IP4Resource resource;

    public SourceTargetWidget(Composite parent, int style, String title, IP4Resource resource) {
        super(parent, style);
        this.resource = resource;
        this.sourcePath = this.resource.getActionPath();
        this.targetPath = this.resource.getActionPath();
        this.createControl(this, title);
        this.addListeners();
        this.updateFromModel();
    }

    protected void createControl(Composite parent, String title) {
        parent.setLayout((Layout)new FillLayout());
        Group filePathArea = new Group(parent, 0);
        filePathArea.setText(title);
        GridLayout fpaLayout = new GridLayout(3, false);
        filePathArea.setLayout((Layout)fpaLayout);
        Label sourceLabel = new Label((Composite)filePathArea, 16384);
        sourceLabel.setText(Messages.IntegrateDialog_SourceLabel);
        this.sourceText = new Combo((Composite)filePathArea, 4);
        SessionManager.loadComboHistory(this.sourceText, "com.perforce.team.ui.preferences.SOURCE_FILE_HISTORY");
        this.sourceText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createBrowseForFileButton((Composite)filePathArea, this.sourceText);
        Label targetLabel = new Label((Composite)filePathArea, 16384);
        targetLabel.setText(Messages.IntegrateDialog_TargetLabel);
        this.targetText = new Combo((Composite)filePathArea, 2052);
        SessionManager.loadComboHistory(this.targetText, "com.perforce.team.ui.preferences.TARGET_FILE_HISTORY");
        this.targetText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createBrowseForFileButton((Composite)filePathArea, this.targetText);
    }

    private void createBrowseForFileButton(Composite parent, final Object update) {
        final Button browseSource = new Button(parent, 8);
        browseSource.setText(Messages.IntegrateDialog_Browse);
        browseSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String actionPath;
                IP4Resource resource;
                ResourceBrowserDialog dialog = new ResourceBrowserDialog(browseSource.getShell(), SourceTargetWidget.this.resource.getConnection().members());
                if (dialog.open() == 0 && (resource = dialog.getSelectedResource()) != null && (actionPath = resource.getActionPath(IP4Resource.Type.REMOTE)) != null) {
                    if (update instanceof Combo) {
                        ((Combo)update).setText(actionPath);
                    } else if (update instanceof Text) {
                        ((Text)update).setText(actionPath);
                    }
                }
            }
        });
    }

    private void addListeners() {
        ModifyListener pathListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SourceTargetWidget.this.updateToModel();
            }
        };
        this.sourceText.addModifyListener(pathListener);
        this.targetText.addModifyListener(pathListener);
    }

    public void updateFromModel() {
        if (this.sourcePath != null) {
            this.sourceText.setText(this.sourcePath);
        }
        if (this.targetPath != null) {
            this.targetText.setText(this.targetPath);
        }
    }

    public void updateToModel() {
        this.sourcePath = this.sourceText.getText();
        this.targetPath = this.targetText.getText();
    }

    @Override
    public IStatus validate() {
        String source = this.sourceText.getText().trim();
        if (source.length() == 0) {
            return ValidationStatus.error((String)Messages.IntegrateDialog_MustEnterSourcePath);
        }
        String target = this.targetText.getText().trim();
        if (target.length() == 0) {
            return ValidationStatus.error((String)Messages.IntegrateDialog_MustEnterTargetPath);
        }
        this.updateToModel();
        return ValidationStatus.ok();
    }

    @Override
    public String getSourcePath() {
        return this.sourcePath;
    }

    @Override
    public String getTargetPath() {
        return this.targetPath;
    }

    @Override
    public Composite getControl() {
        return this;
    }

    @Override
    public boolean isShowAllSource() {
        return true;
    }

    public void postInit() {
    }
}

