/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.team.core.P4ClientUtil;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.p4java.dialogs.Messages;
import com.perforce.team.ui.p4java.dialogs.ResolveWizardAutoPage;
import com.perforce.team.ui.p4java.dialogs.ResolveWizardInteractivePage;
import com.perforce.team.ui.p4java.dialogs.ResolveWizardMethodPage;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;

public class ResolveWizard
extends Wizard {
    private ResolveWizardMethodPage methodPage = new ResolveWizardMethodPage("methodPage");
    private ResolveWizardAutoPage autoResolvePage = new ResolveWizardAutoPage("autoResolvePage");
    private ResolveWizardInteractivePage interactiveResolvePage = new ResolveWizardInteractivePage("interactiveResolvePage");
    private IP4Connection conn;
    IP4Resource[] unresolvedResources;
    ResolveItem[] unresolved;
    ResolveItem[] unresolvedContent;

    public ResolveWizard(IP4Resource[] unresolved) {
        this.setNeedsProgressMonitor(false);
        this.unresolvedResources = unresolved;
        this.updateUnresolvedItems();
    }

    public ResolveWizard(IP4Resource[] unresolved, int changeId, IP4Connection conn) {
        this.setNeedsProgressMonitor(false);
        this.unresolvedResources = unresolved;
        this.updateUnresolvedItems();
        this.autoResolvePage.setChangeId(changeId);
        this.autoResolvePage.setConn(conn);
    }

    public void updateUnresolvedItems() {
        ArrayList<ResolveItem> items = new ArrayList<ResolveItem>();
        ArrayList<ResolveItem> contentItems = new ArrayList<ResolveItem>();
        if (this.unresolvedResources != null) {
            IP4Resource[] iP4ResourceArray = this.unresolvedResources;
            int n = this.unresolvedResources.length;
            int n2 = 0;
            while (n2 < n) {
                IP4File file;
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4File && (file = (IP4File)resource).getIntegrationSpecs() != null) {
                    int i = 0;
                    while (i < file.getIntegrationSpecs().length) {
                        ResolveItem item = new ResolveItem();
                        item.file = file;
                        item.index = i;
                        items.add(item);
                        if (item.isContent()) {
                            contentItems.add(item);
                        }
                        ++i;
                    }
                }
                ++n2;
            }
        }
        this.unresolved = items.toArray(new ResolveItem[0]);
        this.unresolvedContent = contentItems.toArray(new ResolveItem[0]);
    }

    public void removeResolvedItem(ResolveItem item) {
        ArrayList<ResolveItem> items = new ArrayList<ResolveItem>(Arrays.asList(this.unresolved));
        items.remove(item);
        this.unresolved = items.toArray(new ResolveItem[0]);
        ArrayList<ResolveItem> contentItems = new ArrayList<ResolveItem>(Arrays.asList(this.unresolvedContent));
        contentItems.remove(item);
        this.unresolvedContent = contentItems.toArray(new ResolveItem[0]);
    }

    public boolean performFinish() {
        PerforceUIPlugin.getPlugin().getPreferenceStore().setValue("pref_resolve_migrated_to_2012.3", true);
        String mode = "prompt";
        if (this.methodPage.rememberDefaultSelected()) {
            if (this.methodPage.autoSelected()) {
                mode = "auto";
            } else if (this.methodPage.interactiveSelected()) {
                mode = "interactive";
            }
            PerforceUIPlugin.getPlugin().getPreferenceStore().setValue("pref_resolve_default_mode", mode);
        }
        return true;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.setWindowTitle(Messages.ResolveWizard_Resolve);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.methodPage);
        this.addPage((IWizardPage)this.autoResolvePage);
        this.addPage((IWizardPage)this.interactiveResolvePage);
    }

    public IWizardPage getStartingPage() {
        String mode = PerforceUIPlugin.getPlugin().getPreferenceStore().getString("pref_resolve_default_mode");
        Boolean migrated = PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_resolve_migrated_to_2012.3");
        if (!migrated.booleanValue()) {
            return this.methodPage;
        }
        if ("auto".equals(mode)) {
            return this.autoResolvePage;
        }
        if ("interactive".equals(mode)) {
            return this.interactiveResolvePage;
        }
        if ("prompt".equals(mode)) {
            return this.methodPage;
        }
        return this.methodPage;
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        if (currentPage == this.methodPage) {
            if (this.methodPage.autoSelected()) {
                return this.autoResolvePage;
            }
            return this.interactiveResolvePage;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage currentPage) {
        if (currentPage == this.methodPage) {
            return null;
        }
        return this.methodPage;
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() == this.methodPage) {
            return false;
        }
        return super.canFinish();
    }

    static class ResolveItem {
        public IP4File file;
        public int index;

        ResolveItem() {
        }

        String getResolveType() {
            return this.file.getIntegrationSpecs()[this.index].getResolveType();
        }

        String getFromFile() {
            return this.file.getIntegrationSpecs()[this.index].getFromFile();
        }

        int getStartFromRev() {
            return this.file.getIntegrationSpecs()[this.index].getStartFromRev();
        }

        int getEndFromRev() {
            return this.file.getIntegrationSpecs()[this.index].getEndFromRev();
        }

        boolean isAttributes() {
            return "attributes".equals(this.getResolveType());
        }

        boolean isBranch() {
            return "branch".equals(this.getResolveType());
        }

        boolean isContent() {
            return this.getResolveType() == null || "content".equals(this.getResolveType());
        }

        boolean isDelete() {
            return "delete".equals(this.getResolveType());
        }

        boolean isMove() {
            return "move".equals(this.getResolveType());
        }

        boolean isType() {
            return "type".equals(this.getResolveType());
        }

        boolean isResolveShelvedChange() {
            return P4ClientUtil.isResolveShelvedChange((IFileSpec)this.file.getIntegrationSpecs()[this.index]);
        }

        String computeTheirRev() {
            return P4ClientUtil.computeTheirRev((IFileSpec)this.file.getIntegrationSpecs()[this.index]);
        }
    }
}

