/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.SWTUtils;
import com.perforce.team.ui.changelists.DescriptionViewer;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import com.perforce.team.ui.p4java.dialogs.IntegrationPreviewDialog;
import com.perforce.team.ui.p4java.dialogs.Messages;
import com.perforce.team.ui.resource.ResourceBrowserDialog;
import com.perforce.team.ui.resource.VersionedResourceBrowserDialog;
import com.perforce.team.ui.swt.AbstractModelObject;
import com.perforce.team.ui.swt.PageBook;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class PopulateDialog
extends P4StatusDialog {
    private IP4Connection connection;
    private Composite displayArea;
    private ComboViewer branchCombo;
    private PageBook pageBook;
    private Button preview;
    private Label progressLabel;
    private ProgressBar progressBar;
    private PopulateModel model;
    private String basePath = "";
    private String description = Messages.PopulateDialog_Branching;
    private DescriptionViewer descriptionViewer;

    public PopulateDialog(Shell parent, IP4Connection connection, String sourcePath, String targetPath) {
        super(parent, Messages.PopulateDialog_Populate);
        this.setStatusLineAboveButtons(true);
        this.setModalResizeStyle();
        this.connection = connection;
        this.model = new PopulateModel(sourcePath, targetPath, PopulateMethod.SOURCE_TARGET);
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.preview = this.createButton(parent, 13, Messages.IntegrateDialog_Preview, false);
        this.preview.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PopulateDialog.this.runPreview();
            }
        });
        this.createButton(parent, 0, Messages.PopulateDialog_Populate, true);
        this.createButton(parent, 1, Messages.IntegrateDialog_Cancel, false);
    }

    private void startPreview() {
        this.progressBar.setEnabled(true);
        this.progressBar.setVisible(true);
        this.progressLabel.setText(Messages.PopulateDialog_GeneratingPopulatePreview);
        this.preview.setEnabled(false);
    }

    private void stopPreview() {
        this.progressBar.setEnabled(false);
        this.progressBar.setVisible(false);
        this.progressLabel.setText("");
        this.preview.setEnabled(true);
    }

    private void runPreview() {
        this.startPreview();
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return Messages.PopulateDialog_GeneratingPopulatePreview;
            }

            public void run(IProgressMonitor monitor) {
                List<String> sources = PopulateDialog.this.getSourcePaths();
                List<String> targets = PopulateDialog.this.getTargetPaths();
                ArrayList<IP4Resource> populated = new ArrayList<IP4Resource>();
                int i = 0;
                while (i < sources.size()) {
                    IP4Resource[] previewed;
                    IP4Resource[] iP4ResourceArray = previewed = PopulateDialog.this.connection.populate(sources.get(i), targets.get(i), true, PopulateDialog.this.getDescription());
                    int n = previewed.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IP4Resource r = iP4ResourceArray[n2];
                        populated.add(r);
                        ++n2;
                    }
                    ++i;
                }
                final IP4Resource[] previewed = populated.toArray(new IP4Resource[0]);
                PerforceUIPlugin.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!PopulateDialog.this.displayArea.isDisposed()) {
                            PopulateDialog.this.stopPreview();
                            IntegrationPreviewDialog dialog = new IntegrationPreviewDialog(PopulateDialog.this.getShell(), previewed, Messages.PopulateDialog_PopulatePreview);
                            dialog.open();
                        }
                    }
                });
            }
        });
    }

    public String computeBasePath() {
        String prefix = "";
        for (FileVersion v : this.model.getSourceRevisions()) {
            if (StringUtils.isEmpty((CharSequence)prefix)) {
                prefix = v.getPath();
                continue;
            }
            String p = v.getPath();
            int l = Math.min(p.length(), prefix.length());
            int index = -1;
            boolean match = true;
            int i = 0;
            while (i < l) {
                index = i;
                if (prefix.charAt(i) != p.charAt(i)) {
                    match = false;
                    break;
                }
                ++i;
            }
            if (match) {
                prefix = p.substring(0, l);
                continue;
            }
            if (index >= 0) {
                prefix = p.substring(0, index);
                continue;
            }
            prefix = "";
            break;
        }
        if (prefix.length() == 2 && prefix.equals("//")) {
            prefix = "";
        }
        this.basePath = prefix;
        return prefix;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.displayArea = new Composite(c, 0);
        GridLayout daLayout = new GridLayout(1, false);
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createBranchGroup(this.displayArea);
        this.createDetailGroup(this.displayArea);
        this.createDescription(this.displayArea);
        this.createProgressGroup(this.displayArea);
        this.addListeners();
        this.branchCombo.setSelection((ISelection)new StructuredSelection((Object)this.model.getPopulateMethod()));
        SWTUtils.addContentListener((Control)c, new Runnable(){

            @Override
            public void run() {
                PopulateDialog.this.showStatus();
            }
        });
        return c;
    }

    private void createDescription(Composite parent) {
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        SWTUtils.createLabel(parent, Messages.PopulateDialog_Description);
        this.descriptionViewer = new DescriptionViewer((IP4Resource)this.connection);
        this.descriptionViewer.createControl(parent, this.description);
        this.descriptionViewer.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                PopulateDialog.this.description = PopulateDialog.this.descriptionViewer.getDocument().get();
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        StyledText styledText = this.descriptionViewer.getViewer().getTextWidget();
        GridData commentData = (GridData)styledText.getLayoutData();
        commentData.heightHint = P4UIUtils.computePixelHeight(this.descriptionViewer.getViewer().getTextWidget().getFont(), 5);
        styledText.setLayoutData((Object)commentData);
    }

    private void createProgressGroup(Composite displayArea) {
        this.progressLabel = new Label(displayArea, 16384);
        this.progressLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.progressBar = new ProgressBar(displayArea, 65794);
        this.progressBar.setLayoutData((Object)new GridData(4, 4, true, false));
        this.progressBar.setEnabled(false);
        this.progressBar.setVisible(false);
    }

    private void addListeners() {
        this.branchCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PopulateMethod id = (PopulateMethod)((Object)SWTUtils.getSingleSelectedObject((Viewer)PopulateDialog.this.branchCombo));
                PopulateDialog.this.model.setPopulateMethod(id);
                PopulateDialog.this.pageBook.showPageById((Object)id);
                PopulateDialog.this.pageBook.setInput(PopulateDialog.this.model.getSourceRevisions());
            }
        });
        this.model.setPopulateMethod(PopulateMethod.SOURCE_TARGET);
    }

    protected void showStatus() {
        IStatus s = this.findFirstError();
        this.setMessage(s.getSeverity(), s.getMessage());
    }

    private IStatus findFirstError() {
        if (this.model.getPopulateMethod() == PopulateMethod.SOURCE_TARGET) {
            if (StringUtils.isEmpty((CharSequence)this.model.getTargetPath())) {
                return ValidationStatus.error((String)Messages.PopulateDialog_Target_cannot_empty);
            }
            if (this.model.getSourceRevisions().size() == 0) {
                return ValidationStatus.error((String)Messages.PopulateDialog_Source_cannot_empty);
            }
            String prefix = this.computeBasePath();
            if (StringUtils.isEmpty((CharSequence)prefix)) {
                return ValidationStatus.error((String)Messages.PopulateDialog_No_common_source_path);
            }
        }
        return ValidationStatus.ok();
    }

    private void createBranchGroup(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)group);
        group.setLayout((Layout)new GridLayout(2, false));
        SWTUtils.createLabel(group, Messages.PopulateDialog_Branch_method);
        this.branchCombo = SWTUtils.createEnumCombo(group, PopulateMethod.class);
        this.branchCombo.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element != PopulateMethod.BRANCH;
            }
        }});
    }

    private void createDetailGroup(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.pageBook);
        new SourceTargetPage(this.pageBook, 0, this.model);
        new BranchPage(this.pageBook, 0);
    }

    private TableViewer createSourceTable(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 68354);
        this.createColumns(parent, viewer);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        Sorter comparator = new Sorter();
        viewer.setComparator((ViewerComparator)comparator);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        return viewer;
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        String[] titles = new String[]{"", Messages.PopulateDialog_Path, Messages.PopulateDialog_Revision};
        int[] bounds = new int[]{50, 300, 100};
        TableViewerColumn col = this.createTableViewerColumn(viewer, titles[0], bounds[0], 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                FileVersion r = (FileVersion)element;
                if (r.path.endsWith("...")) {
                    return PopulateDialog.this.getSharedImage("IMG_OBJ_FOLDER");
                }
                return PopulateDialog.this.getSharedImage("IMG_OBJ_FILE");
            }

            public String getText(Object element) {
                return null;
            }
        });
        col = this.createTableViewerColumn(viewer, titles[1], bounds[1], 1);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                FileVersion r = (FileVersion)element;
                return r.path;
            }
        });
        col = this.createTableViewerColumn(viewer, titles[2], bounds[2], 2);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                FileVersion r = (FileVersion)element;
                return r.revision;
            }
        });
    }

    protected Image getSharedImage(String id) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        ISharedImages images = workbench.getSharedImages();
        return images.getImage(id);
    }

    private TableViewerColumn createTableViewerColumn(final TableViewer viewer, String title, int bound, final int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        final TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Sorter comparator = (Sorter)viewer.getComparator();
                comparator.setColumn(colNumber);
                int dir = comparator.getDirection();
                viewer.getTable().setSortDirection(dir);
                viewer.getTable().setSortColumn(column);
                viewer.refresh();
            }
        });
        return viewerColumn;
    }

    private String adjustTargetPath(String target, String source, String base) {
        String prefix;
        String suffix = source.substring(base.length());
        if (StringUtils.isEmpty((CharSequence)suffix)) {
            return target;
        }
        String string = prefix = target.endsWith("...") ? target.substring(0, target.length() - 3) : target;
        if (suffix.endsWith("/") || prefix.startsWith("/")) {
            return String.valueOf(prefix) + suffix;
        }
        return String.valueOf(prefix) + "/" + suffix;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getSourcePaths() {
        ArrayList<String> list = new ArrayList<String>();
        for (FileVersion ver : this.model.getSourceRevisions()) {
            list.add(ver.toString());
        }
        return list;
    }

    public String getTargetPath() {
        return this.model.targetPath;
    }

    public List<String> getTargetPaths() {
        List<String> sourcePaths = this.getSourcePaths();
        String targetPath = this.getTargetPath();
        String basePath = this.getBasePath();
        ArrayList<String> targetPaths = new ArrayList<String>();
        if (sourcePaths.size() == 1) {
            targetPaths.add(targetPath);
            return targetPaths;
        }
        int i = 0;
        while (i < sourcePaths.size()) {
            String sourcePath = sourcePaths.get(i);
            String newTagetPath = this.adjustTargetPath(targetPath, sourcePath, basePath);
            targetPaths.add(newTagetPath);
            ++i;
        }
        return targetPaths;
    }

    private class BranchPage
    extends PageBook.BookPage {
        public BranchPage(Composite parent, int style) {
            super(parent, style);
            this.init(null);
        }

        @Override
        public Object getId() {
            return PopulateMethod.BRANCH;
        }

        @Override
        public void createControl() {
            this.setLayout((Layout)new GridLayout(1, false));
            SWTUtils.createLabel(this, Messages.PopulateDialog_Not_implemented_yet);
        }

        @Override
        public void addListeners() {
        }
    }

    public static class FileVersion
    extends AbstractModelObject {
        String path;
        String revision;

        public FileVersion(String path, String revision) {
            this.path = path;
            this.revision = revision;
        }

        public FileVersion(String pathAndRevision) {
            int index = this.findRevisionIndex(pathAndRevision);
            if (index > 0) {
                this.path = pathAndRevision.substring(0, index);
                this.revision = pathAndRevision.substring(index);
            } else {
                this.path = pathAndRevision;
            }
        }

        private int findRevisionIndex(String pathAndRevision) {
            int index = pathAndRevision.indexOf("@");
            if (index > 0) {
                return index;
            }
            index = pathAndRevision.indexOf("#");
            if (index > 0) {
                return index;
            }
            return index;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            String oldValue = this.path;
            this.path = path;
            this.firePropertyChange("path", oldValue, path);
        }

        public String getRevision() {
            return this.revision;
        }

        public void setRevision(String revision) {
            String oldValue = this.revision;
            this.revision = revision;
            this.firePropertyChange("revision", oldValue, revision);
        }

        public String toString() {
            return this.revision == null ? this.path : String.valueOf(this.path) + this.revision;
        }
    }

    static enum PopulateMethod {
        SOURCE_TARGET(Messages.PopulateDialog_Specify_source_and_target),
        BRANCH(Messages.PopulateDialog_Specify_branch);

        private String desc;

        private PopulateMethod(String desc) {
            this.desc = desc;
        }

        public String toString() {
            return this.desc;
        }
    }

    public static class PopulateModel {
        private List<FileVersion> sourceRevisions = new ArrayList<FileVersion>();
        private String targetPath;
        private PopulateMethod populateMethod;

        public PopulateModel(String sourcePath, String targetPath, PopulateMethod populateMethod) {
            if (!StringUtils.isEmpty((CharSequence)sourcePath)) {
                this.sourceRevisions.add(new FileVersion(sourcePath));
            }
            this.targetPath = targetPath;
            this.populateMethod = populateMethod;
        }

        public List<FileVersion> getSourceRevisions() {
            return this.sourceRevisions;
        }

        public String getTargetPath() {
            return this.targetPath;
        }

        public void setTargetPath(String targetPath) {
            this.targetPath = targetPath;
        }

        public PopulateMethod getPopulateMethod() {
            return this.populateMethod;
        }

        public void setPopulateMethod(PopulateMethod populateMethod) {
            this.populateMethod = populateMethod;
        }
    }

    private static class Sorter
    extends ViewerComparator {
        private int column = 0;
        private static final int DESCENDING = 1;
        private int direction = 1;

        public int getDirection() {
            return this.direction == 1 ? 1024 : 128;
        }

        public void setColumn(int column) {
            if (column == this.column) {
                this.direction = 1 - this.direction;
            } else {
                this.column = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            FileVersion p1 = (FileVersion)e1;
            FileVersion p2 = (FileVersion)e2;
            int rc = 0;
            switch (this.column) {
                case 0: {
                    break;
                }
                case 1: {
                    rc = p1.getPath().compareTo(p2.getPath());
                    break;
                }
                case 2: {
                    if (p1.getRevision() == null || p2.getRevision() == null) break;
                    rc = p1.getRevision().compareTo(p2.getRevision());
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            if (this.direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }

    private class SourceTargetPage
    extends PageBook.BookPage {
        private TableViewer sourceTable;
        private Button addBtn;
        private Button editBtn;
        private Button removeBtn;
        private Text targetText;
        private Button browseBtn;
        PopulateModel model;

        public SourceTargetPage(Composite parent, int style, PopulateModel model) {
            super(parent, style);
            this.model = model;
            this.init(model);
        }

        @Override
        public void createControl() {
            this.setLayout((Layout)new GridLayout(1, false));
            this.createTableGroup(this);
            this.createTargetGroup(this);
            this.enableButtons();
        }

        private void createTargetGroup(Composite parent) {
            Composite group = new Composite(parent, 0);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
            group.setLayout((Layout)new GridLayout(2, false));
            SWTUtils.createLabel(group, Messages.PopulateDialog_Choose_target_file_folders, 2);
            this.targetText = SWTUtils.createText(group, 1, 0);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.targetText);
            this.browseBtn = SWTUtils.createButton(group, Messages.PopulateDialog_Browse, 8, 1);
            this.browseBtn.setEnabled(false);
        }

        private void createTableGroup(Composite parent) {
            Composite group = new Composite(parent, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)group);
            group.setLayout((Layout)new GridLayout(2, false));
            SWTUtils.createLabel(group, Messages.PopulateDialog_Source_files_folders, 2);
            this.sourceTable = PopulateDialog.this.createSourceTable(group);
            GridDataFactory.fillDefaults().grab(true, true).span(1, 3).hint(400, 200).applyTo(this.sourceTable.getControl());
            this.addBtn = SWTUtils.createButton(group, Messages.PopulateDialog_Add, 8, 1);
            this.editBtn = SWTUtils.createButton(group, Messages.PopulateDialog_Edit, 8, 1);
            this.removeBtn = SWTUtils.createButton(group, Messages.PopulateDialog_Remove, 8, 1);
        }

        @Override
        public Object getId() {
            return PopulateMethod.SOURCE_TARGET;
        }

        @Override
        public void setInput(Object input) {
            if (input instanceof PopulateModel) {
                PopulateModel m = (PopulateModel)input;
                this.sourceTable.setInput(m.getSourceRevisions());
                this.targetText.setText(m.getTargetPath());
            }
        }

        @Override
        public void addListeners() {
            this.targetText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SourceTargetPage.this.model.setTargetPath(SourceTargetPage.this.targetText.getText());
                }
            });
            this.sourceTable.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SourceTargetPage.this.enableButtons();
                }
            });
            this.addBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    VersionedResourceBrowserDialog dlg = new VersionedResourceBrowserDialog(SourceTargetPage.this.getShell(), new IP4Resource[]{PopulateDialog.this.connection}, "");
                    if (dlg.open() == 0) {
                        IP4Resource resource = dlg.getSelectedResource();
                        FileVersion v = new FileVersion(resource.getActionPath(), dlg.getVersion());
                        SourceTargetPage.this.model.getSourceRevisions().add(v);
                        SourceTargetPage.this.updateBasePath();
                        SourceTargetPage.this.refreshAndResizeTable();
                        SWTUtils.select((StructuredViewer)SourceTargetPage.this.sourceTable, v);
                    }
                }
            });
            this.removeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection sel = (IStructuredSelection)SourceTargetPage.this.sourceTable.getSelection();
                    Iterator it = sel.iterator();
                    while (it.hasNext()) {
                        SourceTargetPage.this.model.getSourceRevisions().remove(it.next());
                    }
                    SourceTargetPage.this.updateBasePath();
                    SourceTargetPage.this.refreshAndResizeTable();
                }
            });
            this.editBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileVersion version = (FileVersion)SWTUtils.getSingleSelectedObject((Viewer)SourceTargetPage.this.sourceTable);
                    VersionedResourceBrowserDialog dlg = new VersionedResourceBrowserDialog(SourceTargetPage.this.getShell(), new IP4Resource[]{PopulateDialog.this.connection}, version.toString());
                    if (dlg.open() == 0) {
                        IP4Resource resource = dlg.getSelectedResource();
                        SourceTargetPage.this.model.getSourceRevisions().remove(version);
                        FileVersion v = new FileVersion(resource.getActionPath(), dlg.getVersion());
                        SourceTargetPage.this.model.getSourceRevisions().add(v);
                        SourceTargetPage.this.updateBasePath();
                        SourceTargetPage.this.refreshAndResizeTable();
                        SWTUtils.select((StructuredViewer)SourceTargetPage.this.sourceTable, v);
                    }
                }
            });
            this.sourceTable.setInput(this.model.getSourceRevisions());
            this.browseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResourceBrowserDialog dlg = new ResourceBrowserDialog(SourceTargetPage.this.getShell(), new IP4Resource[]{PopulateDialog.this.connection}){

                        @Override
                        protected void okPressed() {
                            IP4Resource sel = this.widget.getSelectedResource();
                            if (sel == null || StringUtils.isEmpty((CharSequence)sel.getActionPath())) {
                                this.setErrorMessage(Messages.PopulateDialog_Must_select_file_or_folder);
                                return;
                            }
                            super.okPressed();
                        }
                    };
                    if (dlg.open() == 0) {
                        String path = dlg.getSelectedResource().getActionPath();
                        SourceTargetPage.this.model.setTargetPath(path);
                        SourceTargetPage.this.targetText.setText(path);
                    }
                }
            });
        }

        protected void refreshAndResizeTable() {
            this.sourceTable.refresh();
            TableColumn[] tableColumnArray = this.sourceTable.getTable().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn c = tableColumnArray[n2];
                c.pack();
                ++n2;
            }
        }

        protected void updateBasePath() {
            if (this.model.sourceRevisions.size() > 1) {
                String prefix = PopulateDialog.this.computeBasePath();
                if (StringUtils.isEmpty((CharSequence)prefix)) {
                    this.sourceTable.getTable().getColumn(1).setText(Messages.PopulateDialog_Base_path_unavailable);
                } else {
                    this.sourceTable.getTable().getColumn(1).setText(String.valueOf(Messages.PopulateDialog_Base_path) + prefix);
                }
            } else {
                this.sourceTable.getTable().getColumn(1).setText(Messages.PopulateDialog_Path);
            }
        }

        protected void enableButtons() {
            boolean enable = !this.sourceTable.getSelection().isEmpty();
            this.editBtn.setEnabled(enable);
            this.removeBtn.setEnabled(enable);
        }
    }
}

