/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.team.core.P4LogUtils;
import com.perforce.team.ui.dialogs.PerforceDialog;
import com.perforce.team.ui.p4java.dialogs.Messages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PerforceErrorDialog
extends PerforceDialog {
    private Composite displayArea;
    private Label errorsIcon;
    private Label errorsLabel;
    private Text detailsText;
    private IFileSpec[] specs;

    public static PerforceErrorDialog showErrors(Shell parent, IFileSpec[] specs, boolean block) {
        PerforceErrorDialog dialog = null;
        if (specs != null && specs.length > 0) {
            dialog = new PerforceErrorDialog(parent, specs);
            dialog.setBlockOnOpen(block);
            dialog.open();
        }
        return dialog;
    }

    public static void showErrors(Shell parent, IFileSpec[] specs) {
        PerforceErrorDialog.showErrors(parent, specs, true);
    }

    public PerforceErrorDialog(Shell parent, IFileSpec[] specs) {
        super(parent, Messages.PerforceErrorDialog_PerforceError);
        this.specs = specs;
        this.setModalResizeStyle();
    }

    public String getDetailsText() {
        return this.detailsText.getText();
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.displayArea = new Composite(c, 0);
        this.displayArea.setLayout((Layout)new GridLayout(2, false));
        GridData daData = new GridData(4, 4, true, true);
        daData.heightHint = 200;
        this.displayArea.setLayoutData((Object)daData);
        this.errorsIcon = new Label(this.displayArea, 16384);
        this.errorsIcon.setImage(this.displayArea.getShell().getDisplay().getSystemImage(1));
        this.errorsLabel = new Label(this.displayArea, 16384);
        this.errorsLabel.setText(Messages.PerforceErrorDialog_ErrorsLabel);
        this.detailsText = new Text(this.displayArea, 2826);
        GridData dtData = new GridData(4, 4, true, true);
        dtData.horizontalSpan = 2;
        this.detailsText.setLayoutData((Object)dtData);
        this.detailsText.setText(P4LogUtils.getError((IFileSpec[])this.specs));
        return c;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

