/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceLabelProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.changelists.DescriptionViewer;
import com.perforce.team.ui.changelists.Messages;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class MoveChangeDialog
extends P4StatusDialog {
    public static final String MOVE_DEFAULT_DESCRIPTION = Messages.MoveChangeDialog_MoveDefaultDescription;
    private IP4PendingChangelist[] changes;
    private TableViewer changelistViewer;
    private DescriptionViewer viewer;
    private int selectedChange;
    private String description = MOVE_DEFAULT_DESCRIPTION;
    private Object newChangelist = new Object();

    public MoveChangeDialog(Shell parent, IP4PendingChangelist[] changes) {
        super(parent, Messages.MoveChangeDialog_MoveFileToChangelist);
        this.changes = changes;
        this.setModalResizeStyle();
    }

    protected Control createDialogArea(Composite parent) {
        final Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite displayArea = new Composite(dialogArea, 0);
        GridLayout daLayout = new GridLayout(2, false);
        displayArea.setLayout((Layout)daLayout);
        GridData daData = new GridData(4, 4, true, true);
        displayArea.setLayoutData((Object)daData);
        Label headerLabel = new Label(displayArea, 0);
        headerLabel.setText(Messages.MoveChangeDialog_MoveToPendingChangelist);
        GridData hlData = new GridData(4, 4, true, false);
        hlData.horizontalSpan = 2;
        headerLabel.setLayoutData((Object)hlData);
        this.changelistViewer = new TableViewer(displayArea, 2820);
        final Image newImage = PerforceUIPlugin.getDescriptor("normal/new_changelist.png").createImage();
        P4UIUtils.registerDisposal((Widget)this.changelistViewer.getTable(), (Resource)newImage);
        GridData cvData = new GridData(4, 4, true, true);
        cvData.horizontalSpan = 2;
        cvData.widthHint = 400;
        cvData.heightHint = P4UIUtils.computePixelHeight(this.changelistViewer.getTable().getFont(), 10);
        this.changelistViewer.getTable().setLayoutData((Object)cvData);
        this.changelistViewer.setLabelProvider((IBaseLabelProvider)new PerforceLabelProvider(false){

            @Override
            public Image getColumnImage(Object element, int columnIndex) {
                if (element == MoveChangeDialog.this.newChangelist) {
                    return newImage;
                }
                return super.getColumnImage(element, columnIndex);
            }

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (element == MoveChangeDialog.this.newChangelist) {
                    return Messages.MoveChangeDialog_NewPendingChangelist;
                }
                return super.getColumnText(element, columnIndex);
            }
        });
        this.changelistViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        P4CoreUtils.sort((IP4Changelist[])this.changes);
        Object[] changesWithNew = new Object[this.changes.length + 1];
        changesWithNew[0] = this.newChangelist;
        System.arraycopy(this.changes, 0, changesWithNew, 1, this.changes.length);
        this.changelistViewer.setInput((Object)changesWithNew);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.changelistViewer.getTable(), "com.perforce.team.ui.move_change_changelists");
        this.changelistViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MoveChangeDialog.this.okPressed();
            }
        });
        this.changelistViewer.getTable().select(1);
        this.changelistViewer.getTable().setFocus();
        IP4Connection connection = null;
        if (this.changes.length > 0) {
            connection = this.changes[0].getConnection();
        }
        final Label descriptionLabel = new Label(displayArea, 0);
        final GridData descriptionData = new GridData(4, 0x1000000, false, false);
        descriptionData.exclude = true;
        descriptionLabel.setText(Messages.MoveChangeDialog_Description);
        descriptionLabel.setLayoutData((Object)descriptionData);
        descriptionLabel.setVisible(false);
        this.viewer = new DescriptionViewer((IP4Resource)connection);
        this.viewer.createControl(displayArea, this.description);
        this.viewer.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                MoveChangeDialog.this.description = MoveChangeDialog.this.viewer.getDocument().get();
                MoveChangeDialog.this.validate();
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        final StyledText styledText = this.viewer.getViewer().getTextWidget();
        final GridData commentData = (GridData)styledText.getLayoutData();
        commentData.heightHint = P4UIUtils.computePixelHeight(styledText.getFont(), 5);
        commentData.exclude = true;
        styledText.setLayoutData((Object)commentData);
        styledText.setVisible(false);
        this.changelistViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int index = MoveChangeDialog.this.changelistViewer.getTable().getSelectionIndex();
                if (index > 0) {
                    commentData.exclude = true;
                    descriptionData.exclude = true;
                    styledText.setVisible(false);
                    descriptionLabel.setVisible(false);
                } else if (index == 0) {
                    commentData.exclude = false;
                    descriptionData.exclude = false;
                    styledText.setVisible(true);
                    descriptionLabel.setVisible(true);
                }
                dialogArea.layout(true, true);
                if (styledText.isVisible()) {
                    styledText.setFocus();
                }
                MoveChangeDialog.this.validate();
            }
        });
        daData.heightHint = cvData.heightHint + commentData.heightHint;
        return dialogArea;
    }

    public Table getChangesList() {
        return this.changelistViewer != null ? this.changelistViewer.getTable() : null;
    }

    public int getSelectedChange() {
        return this.selectedChange;
    }

    public String getDescription() {
        return this.description;
    }

    protected void okPressed() {
        int index = this.changelistViewer.getTable().getSelectionIndex();
        this.selectedChange = index == 0 ? -2 : this.changes[index - 1].getId();
        super.okPressed();
    }

    public void validate() {
        String errorMessage = null;
        if (this.changelistViewer.getTable().getSelectionIndex() == 0 && this.description.length() == 0) {
            errorMessage = Messages.PendingCombo_EnterChangelistDescription;
        }
        this.setErrorMessage(errorMessage);
    }
}

