/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.option.Options;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4FileIntegration;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.IErrorProvider;
import com.perforce.team.ui.Messages;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.SWTUtils;
import com.perforce.team.ui.changelists.PendingCombo;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import com.perforce.team.ui.p4java.dialogs.IntegrationPreviewDialog;
import com.perforce.team.ui.p4java.dialogs.SourceTargetStreamWidget;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public abstract class IntegrateToStreamDialog
extends P4StatusDialog {
    public static final String TRY_AUTO_RESOLVE = "com.perforce.team.ui.preferences.TRY_AUTO_RESOLVE";
    private Composite displayArea;
    private PendingCombo changelistCombo;
    private Label progressLabel;
    private ProgressBar progressBar;
    private Button preview;
    private Button integrate;
    private IP4Resource resource = null;
    protected SourceTargetStreamWidget pathWidget;
    protected IRevisionRangeWidget rangeWidget;
    protected IDepotFileChooser folderWidget;
    private String changeListDescription;
    private Options options;
    private P4FileIntegration fileIntegration;

    protected abstract IRevisionRangeWidget createRevisionRangeWidget(Composite var1);

    protected abstract List<IStreamSummary> getPreferredStreams(IP4Resource var1);

    protected abstract SourceTargetStreamWidget createSourceTargetWidget(Composite var1, IP4Resource var2);

    protected abstract IP4Resource[] doIntegrate(IP4Connection var1, P4FileIntegration var2, String var3, Options var4);

    protected abstract Options updatePreviewOptions();

    protected abstract Options updateNonPreviewOptions();

    protected abstract String getOkButtonText();

    protected Point getPreferredSize() {
        return new Point(700, 400);
    }

    protected IDepotFileChooser createFolderWidget(Composite parent, IP4Resource resource) {
        return null;
    }

    public void create() {
        super.create();
        this.getShell().setSize(this.getPreferredSize());
        this.validate();
        this.postInit();
    }

    private void postInit() {
        this.startProgress(com.perforce.team.ui.p4java.dialogs.Messages.IntegrateToStreamDialog_InitializeDialog);
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return com.perforce.team.ui.p4java.dialogs.Messages.IntegrateToStreamDialog_InitializeDialog;
            }

            public void run(IProgressMonitor monitor) {
                IntegrateToStreamDialog.this.pathWidget.getNonUIJob().run();
                PerforceUIPlugin.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!IntegrateToStreamDialog.this.displayArea.isDisposed()) {
                            (this).IntegrateToStreamDialog.this.pathWidget.getUIJob().run();
                            IntegrateToStreamDialog.this.stopProgress();
                        }
                    }
                });
            }
        });
    }

    public String getChangeListDescription() {
        return this.changeListDescription;
    }

    public Options getOptions() {
        return this.options;
    }

    public P4FileIntegration getFileIntegration() {
        return this.fileIntegration;
    }

    public IntegrateToStreamDialog(Shell parent, IP4Resource resource, String title) {
        super(parent, title);
        this.setStatusLineAboveButtons(true);
        this.setModalResizeStyle();
        this.resource = resource;
    }

    @Override
    protected void updateButtonsEnableState(IStatus status) {
        if (this.integrate != null && !this.integrate.isDisposed()) {
            this.integrate.setEnabled(!status.matches(4));
            this.preview.setEnabled(!status.matches(4));
        }
    }

    private void validate() {
        if (this.changelistCombo.getErrorMessage() != null) {
            return;
        }
        IStatus status = this.pathWidget.validate();
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            return;
        }
        if (this.folderWidget != null && !(status = this.folderWidget.validate()).isOK()) {
            this.setErrorMessage(status.getMessage());
            return;
        }
        status = this.rangeWidget.validate();
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            return;
        }
        this.setErrorMessage(null);
    }

    @Override
    public void setErrorMessage(String message, IErrorProvider provider) {
        if (provider == this.changelistCombo && message == null) {
            this.validate();
            return;
        }
        super.setErrorMessage(message, provider);
    }

    private void createChangelistArea(Composite parent) {
        this.changelistCombo = new PendingCombo(this.resource);
        this.changelistCombo.createControl(parent, IP4Connection.INTEGRATE_DEFAULT_DESCRIPTION);
        this.changelistCombo.setErrorDisplay(this);
        this.progressLabel = new Label(this.displayArea, 16384);
        this.progressLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.progressBar = new ProgressBar(this.displayArea, 65794);
        this.progressBar.setLayoutData((Object)new GridData(4, 4, true, false));
        this.progressBar.setEnabled(false);
        this.progressBar.setVisible(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.displayArea = new Composite(c, 0);
        GridLayout daLayout = new GridLayout(1, true);
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.pathWidget = this.createSourceTargetWidget(this.displayArea, this.resource);
        GridDataFactory.swtDefaults().align(4, 0x1000000).applyTo((Control)this.pathWidget.getControl());
        this.folderWidget = this.createFolderWidget(this.displayArea, this.resource);
        if (this.folderWidget != null) {
            GridDataFactory.swtDefaults().align(4, 0x1000000).applyTo(this.folderWidget.getControl());
        }
        this.rangeWidget = this.createRevisionRangeWidget(this.displayArea);
        GridDataFactory.swtDefaults().align(4, 0x1000000).applyTo((Control)this.rangeWidget.getControl());
        this.createChangelistArea(this.displayArea);
        this.addListeners();
        return c;
    }

    private void addListeners() {
        SWTUtils.addContentListener(new Control[]{this.pathWidget.getControl(), this.rangeWidget.getControl()}, new Runnable(){

            @Override
            public void run() {
                IntegrateToStreamDialog.this.validate();
            }
        });
        if (this.folderWidget != null) {
            SWTUtils.addContentListener(new Control[]{this.folderWidget.getControl()}, new Runnable(){

                @Override
                public void run() {
                    IntegrateToStreamDialog.this.validate();
                }
            });
        }
    }

    private void updateHistory() {
    }

    protected void okPressed() {
        this.updateModel();
        super.okPressed();
    }

    private void updateModel() {
        this.changeListDescription = this.updateChangeListDescription();
        this.options = this.updateNonPreviewOptions();
        this.fileIntegration = this.updateIntegration();
    }

    public void startProgress(String title) {
        this.progressBar.setEnabled(true);
        this.progressBar.setVisible(true);
        this.progressLabel.setText(title);
        this.pathWidget.setEnabled(false);
    }

    public void stopProgress() {
        this.progressBar.setEnabled(false);
        this.progressBar.setVisible(false);
        this.progressLabel.setText("");
        this.pathWidget.setEnabled(true);
        this.validate();
    }

    private void runPreview() {
        final IP4Connection connection = this.resource.getConnection();
        IStatus status = this.validateTaskStreamOp();
        if (!status.isOK()) {
            MessageDialog.openError(null, (String)Messages.P4TeamUtils_Error, (String)status.getMessage());
            return;
        }
        this.startProgress(com.perforce.team.ui.p4java.dialogs.Messages.IntegrateDialog_GeneratingIntegPreview);
        this.preview.setEnabled(false);
        this.integrate.setEnabled(false);
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return com.perforce.team.ui.p4java.dialogs.Messages.IntegrateDialog_GeneratingIntegPreview;
            }

            public void run(IProgressMonitor monitor) {
                IntegrateToStreamDialog.this.updatePreviewModel();
                final IP4Resource[] previewed = IntegrateToStreamDialog.this.doIntegrate(connection, IntegrateToStreamDialog.this.fileIntegration, IntegrateToStreamDialog.this.changeListDescription, IntegrateToStreamDialog.this.options);
                PerforceUIPlugin.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!IntegrateToStreamDialog.this.displayArea.isDisposed()) {
                            IntegrateToStreamDialog.this.stopProgress();
                            IntegrateToStreamDialog.this.preview.setEnabled(true);
                            IntegrateToStreamDialog.this.integrate.setEnabled(true);
                            if (previewed != null && previewed.length > 0) {
                                new IntegrationPreviewDialog(IntegrateToStreamDialog.this.getShell(), previewed).open();
                            }
                        }
                    }
                });
            }
        });
    }

    protected IStatus validateTaskStreamOp() {
        return ValidationStatus.ok();
    }

    private void updatePreviewModel() {
        this.changeListDescription = this.updateChangeListDescription();
        this.options = this.updatePreviewOptions();
        this.fileIntegration = this.updateIntegration();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.preview = this.createButton(parent, 13, com.perforce.team.ui.p4java.dialogs.Messages.IntegrateDialog_Preview, false);
        this.preview.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IntegrateToStreamDialog.this.updateHistory();
                IntegrateToStreamDialog.this.runPreview();
            }
        });
        this.integrate = this.createButton(parent, 0, this.getOkButtonText(), true);
        this.createButton(parent, 1, com.perforce.team.ui.p4java.dialogs.Messages.IntegrateDialog_Cancel, false);
    }

    public P4FileIntegration updateIntegration() {
        String path;
        P4FileIntegration integration = new P4FileIntegration();
        integration.setStart(this.rangeWidget.getStart());
        integration.setEnd(this.rangeWidget.getEnd());
        if (this.folderWidget != null && !StringUtils.isEmpty((CharSequence)(path = this.folderWidget.getDepotPath().trim()))) {
            integration.setTarget(path);
        }
        return integration;
    }

    protected int getChangelist() {
        return this.changelistCombo.getSelected();
    }

    private String updateChangeListDescription() {
        return this.changelistCombo.getDescription();
    }

    protected IP4Connection getConnection() {
        return this.resource.getConnection();
    }

    public static interface IDepotFileChooser {
        public String getDepotPath();

        public Control getControl();

        public IStatus validate();
    }

    public static interface ILongtimeTask {
        public Runnable getNonUIJob();

        public Runnable getUIJob();
    }

    public static interface IProgressProvider {
        public void startProgress(String var1);

        public void stopProgress();
    }

    public static interface IRevisionRangeWidget {
        public String getStart();

        public String getEnd();

        public IStatus validate();

        public Composite getControl();
    }

    public static interface ISourceTargetWidget<T> {
        public T getSourcePath();

        public T getTargetPath();

        public IStatus validate();

        public Composite getControl();

        public boolean isShowAllSource();

        public void setEnabled(boolean var1);
    }
}

