/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.p4api.PerforceConstants;
import com.perforce.p4java.core.IJobSpec;
import com.perforce.team.core.Policy;
import com.perforce.team.core.Tracing;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceContentProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.changelists.DescriptionTemplate;
import com.perforce.team.ui.changelists.DescriptionViewer;
import com.perforce.team.ui.dialogs.JobFixDialog;
import com.perforce.team.ui.dialogs.JobListViewer;
import com.perforce.team.ui.dialogs.PerforceDialog;
import com.perforce.team.ui.p4java.dialogs.Messages;
import com.perforce.team.ui.pending.PendingChangelistFileWidget;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ChangeSpecDialog
extends PerforceDialog {
    public static final String DIALOG_SECTION = "CHANGE_SPEC_DIALOG";
    public static final String PENDING_CONTEXT = "pending.edit";
    private Set<IP4Job> changeJobs = new HashSet<IP4Job>();
    private Set<IP4Job> removedJobs = new HashSet<IP4Job>();
    private IP4File[] startingCheckedFiles = null;
    private IP4File[] selected = null;
    private IP4File[] unselected = null;
    private int id;
    private IP4PendingChangelist changelist;
    private IP4Connection connection = null;
    private String initialDescription = null;
    private IP4File[] changeFiles = null;
    private List<DescriptionTemplate> descriptions = null;
    private DescriptionViewer descEditor;
    private Combo templateCombo;
    private String description;
    private boolean submit;
    private IP4File[] checkedFiles;
    private Button okButton;
    private PendingChangelistFileWidget filesViewer;
    private Button reopenCheck;
    private JobListViewer jobsViewer;
    private Button addJobsButton;
    private Button removeJobsButton;
    private Label jobStatusLabel;
    private Combo jobStatusCombo;
    private boolean reopenFiles;
    private String status;

    public ChangeSpecDialog(IP4PendingChangelist changelist, IP4Resource[] checked, Shell parent, boolean submit, String description) {
        super(parent, Messages.ChangeSpecDialog_PerforceChangeSpecification);
        this.submit = submit;
        this.changelist = changelist;
        this.connection = changelist.getConnection();
        if (description == null) {
            description = this.changelist.getDescription();
        }
        this.initialDescription = description;
        this.id = changelist.getId();
        this.changeFiles = changelist.getPendingFiles();
        if (checked == null) {
            checked = changelist.members();
        }
        this.setupChecked(checked, changelist.getJobs());
        this.setModalResizeStyle();
    }

    public ChangeSpecDialog(IP4PendingChangelist changelist, IP4Resource[] checked, Shell parent, boolean submit) {
        this(changelist, checked, parent, submit, null);
    }

    public ChangeSpecDialog(IP4Connection connection, IP4File[] files, IP4Job[] jobs, Shell parent, String description) {
        super(parent, Messages.ChangeSpecDialog_PerforceChangeSpecification);
        this.connection = connection;
        this.id = -2;
        this.initialDescription = description;
        this.submit = false;
        this.changeFiles = files;
        this.setupChecked((IP4Resource[])files, jobs);
        this.setModalResizeStyle();
    }

    @Override
    protected String getSectionName() {
        return DIALOG_SECTION;
    }

    private void setupChecked(IP4Resource[] checked, IP4Job[] jobs) {
        int n;
        int n2;
        IP4Resource[] iP4ResourceArray;
        ArrayList<IP4File> checkedFiles = new ArrayList<IP4File>();
        if (checked != null) {
            iP4ResourceArray = checked;
            n2 = checked.length;
            n = 0;
            while (n < n2) {
                IP4Resource resource = iP4ResourceArray[n];
                if (resource instanceof IP4File) {
                    checkedFiles.add((IP4File)resource);
                }
                ++n;
            }
        }
        if (jobs != null) {
            iP4ResourceArray = jobs;
            n2 = jobs.length;
            n = 0;
            while (n < n2) {
                IP4Resource job = iP4ResourceArray[n];
                this.changeJobs.add((IP4Job)job);
                ++n;
            }
        }
        this.startingCheckedFiles = checkedFiles.toArray(new IP4File[checkedFiles.size()]);
        this.selected = this.startingCheckedFiles;
        if (this.changeFiles == null) {
            this.changeFiles = new IP4File[0];
        }
    }

    public String getDescription() {
        int idx;
        StringBuilder buff = new StringBuilder(this.description);
        int count = 0;
        int start = 0;
        while ((idx = this.description.indexOf(13, start)) != -1) {
            buff.deleteCharAt(idx - count);
            ++count;
            start = idx + 1;
        }
        return buff.toString();
    }

    public void setDescription(String description) {
        if (this.descEditor != null) {
            this.descEditor.setText(description);
        }
    }

    public IP4File[] getCheckedFiles() {
        return this.selected;
    }

    public IP4File[] getUncheckedFiles() {
        return this.unselected;
    }

    public IP4Job[] getCheckedJobs() {
        return this.changeJobs.toArray(new IP4Job[0]);
    }

    public IP4Job[] getUncheckedJobs() {
        return this.removedJobs.toArray(new IP4Job[0]);
    }

    public boolean reopenFiles() {
        return this.reopenFiles;
    }

    private void refreshFilesViewer() {
        this.updateCheckState();
    }

    private boolean useSameStatus() {
        return PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("com.perforce.team.ui.preferences.SAME_JOB_STATUS");
    }

    private void fillStatusCombo(Combo combo) {
        IJobSpec spec = this.connection.getJobSpec();
        if (spec != null) {
            for (IJobSpec.IJobSpecField field : spec.getFields()) {
                if (102 != field.getCode()) continue;
                List statuses = spec.getFieldValues(field.getName());
                if (statuses != null) {
                    for (String status : statuses) {
                        combo.add(status);
                    }
                }
                combo.add("same");
                String defaultStatus = "closed";
                if (!this.useSameStatus()) {
                    String statusPreset = spec.getFieldPreset(field.getName());
                    if (statusPreset != null) {
                        int fixArea = statusPreset.indexOf("fix/");
                        int presetStart = fixArea + "fix/".length();
                        if (fixArea != -1 && presetStart < statusPreset.length()) {
                            defaultStatus = statusPreset.substring(presetStart);
                        }
                    }
                } else {
                    defaultStatus = "same";
                }
                if (combo.indexOf(defaultStatus) == -1) break;
                this.status = defaultStatus;
                combo.setText(defaultStatus);
                break;
            }
        }
    }

    private void createDescriptionArea(Composite parent, IP4File[] files, Collection<IP4Job> jobs) {
        Composite descGroup = this.createTitledArea(parent, 768);
        GridData dgData = new GridData(4, 4, true, false);
        descGroup.setLayoutData((Object)dgData);
        Composite titleArea = new Composite(descGroup, 0);
        GridLayout tiLayout = new GridLayout(2, false);
        tiLayout.marginHeight = 0;
        tiLayout.marginWidth = 0;
        titleArea.setLayout((Layout)tiLayout);
        titleArea.setLayoutData((Object)new GridData(4, 4, true, false));
        Label descriptionLabel = new Label(titleArea, 16384);
        descriptionLabel.setText(Messages.ChangeSpecDialog_Description);
        ToolBar titleBar = new ToolBar(titleArea, 0x800000);
        titleBar.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
        ToolItem prefItem = new ToolItem(titleBar, 8);
        Image prefImage = PerforceUIPlugin.getPlugin().getImageDescriptor("views/preferences.png").createImage();
        P4UIUtils.registerDisposal((Widget)prefItem, (Resource)prefImage);
        prefItem.setImage(prefImage);
        prefItem.setToolTipText(Messages.ChangeSpecDialog_OpenEditorPrefs);
        prefItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                P4UIUtils.openPreferencePage("com.perforce.team.ui.dialogs.ChangelistEditorPreferencePage");
            }
        });
        String changeDesc = this.initialDescription;
        if (changeDesc == null) {
            changeDesc = PerforceConstants.DEFAULT_DESCRIPTION;
        }
        if (changeDesc.length() > 0 && changeDesc.charAt(changeDesc.length() - 1) == '\n') {
            changeDesc = changeDesc.substring(0, changeDesc.length() - 1);
        }
        this.description = changeDesc;
        this.descEditor = new DescriptionViewer(PENDING_CONTEXT, (IP4Resource)this.changelist, files, jobs.toArray(new IP4Job[jobs.size()]));
        this.descEditor.createControl(descGroup, changeDesc);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.descEditor.getControl(), "com.perforce.team.ui.change_spec_description");
        this.descEditor.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                ChangeSpecDialog.this.description = ChangeSpecDialog.this.descEditor.getDocument().get();
                ChangeSpecDialog.this.enableOk();
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        Composite templateArea = new Composite(descGroup, 0);
        GridLayout taLayout = new GridLayout(2, false);
        taLayout.marginWidth = 0;
        taLayout.marginHeight = 0;
        templateArea.setLayout((Layout)taLayout);
        templateArea.setLayoutData((Object)new GridData(4, 4, true, false));
        this.templateCombo = new Combo(templateArea, 12);
        this.templateCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.templateCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selected = ChangeSpecDialog.this.templateCombo.getSelectionIndex();
                if (selected > 0) {
                    ChangeSpecDialog.this.descEditor.setText(((DescriptionTemplate)ChangeSpecDialog.this.descriptions.get(--selected)).getContent());
                    ChangeSpecDialog.this.enableOk();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Link configureTemplates = new Link(templateArea, 0);
        configureTemplates.setText(Messages.ChangeSpecDialog_Configure);
        configureTemplates.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                P4UIUtils.openPreferencePage("com.perforce.team.ui.dialogs.DescriptionTemplatesPreferencePage");
                ChangeSpecDialog.this.loadTemplates();
            }
        });
        this.loadTemplates();
    }

    private void loadTemplates() {
        this.templateCombo.removeAll();
        String previous = this.templateCombo.getText();
        this.templateCombo.add(Messages.ChangeSpecDialog_ChooseATemplate);
        this.templateCombo.select(0);
        this.descriptions = DescriptionTemplate.getHistory();
        for (DescriptionTemplate tpl : this.descriptions) {
            this.templateCombo.add(tpl.getLabel(null));
        }
        for (DescriptionTemplate tpl : DescriptionTemplate.getTemplates()) {
            this.descriptions.add(tpl);
            this.templateCombo.add(MessageFormat.format(Messages.ChangeSpecDialog_Template, tpl.getLabel(null)));
        }
        this.templateCombo.setText(previous);
        this.descEditor.updateTemplates(this.descriptions);
    }

    private void createFilesArea(Composite parent, final IP4File[] files) {
        Composite filesGroup = this.createTitledArea(parent, 1808);
        this.filesViewer = new PendingChangelistFileWidget(false, true, true);
        this.filesViewer.createControl(filesGroup);
        this.filesViewer.getViewer().setInput((Object)new Object[]{new PerforceContentProvider.Loading()});
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Tracing.printExecTime((boolean)Policy.DEBUG, (String)"SUBMIT", (String)(String.valueOf(this.getClass().getSimpleName()) + ":" + ChangeSpecDialog.this.filesViewer.getClass().getSimpleName() + ".setInput"), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!ChangeSpecDialog.this.filesViewer.getControl().isDisposed()) {
                            ChangeSpecDialog.this.filesViewer.setInput((IP4Resource[])files, (IP4Resource[])ChangeSpecDialog.this.startingCheckedFiles);
                            ChangeSpecDialog.this.updateCheckState();
                        }
                    }
                });
            }
        });
        this.checkedFiles = this.filesViewer.getCheckedFiles();
        this.filesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ChangeSpecDialog.this.refreshFilesViewer();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.filesViewer.getControl(), "com.perforce.team.ui.change_spec_files");
        Composite fileButtons = this.createComposite(parent, 3, 0);
        GridData data = (GridData)fileButtons.getLayoutData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        if (this.submit) {
            this.reopenCheck = new Button(fileButtons, 32);
            data = new GridData(4, 4, true, false);
            this.reopenCheck.setLayoutData((Object)data);
            this.reopenCheck.setText(Messages.ChangeSpecDialog_ReopenFiles);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.reopenCheck, "com.perforce.team.ui.change_spec_reopen");
        } else {
            data = (GridData)this.createLabel(fileButtons, "").getLayoutData();
            data.grabExcessHorizontalSpace = true;
        }
        Button selectAll = this.createButton(fileButtons, Messages.ChangeSpecDialog_SelectAll, 0);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ChangeSpecDialog.this.filesViewer.selectAll();
                ChangeSpecDialog.this.refreshFilesViewer();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)selectAll, "com.perforce.team.ui.change_spec_select_all");
        Button deselectAll = this.createButton(fileButtons, Messages.ChangeSpecDialog_DeselectAll, 0);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ChangeSpecDialog.this.filesViewer.setAllChecked(false);
                ChangeSpecDialog.this.refreshFilesViewer();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)deselectAll, "com.perforce.team.ui.change_spec_deselect_all");
    }

    private void createJobsArea(Composite parent, Collection<IP4Job> jobs) {
        Composite jobsGroup = this.createTitledArea(parent, 768);
        this.createLabel(jobsGroup, Messages.ChangeSpecDialog_Jobs);
        this.jobsViewer = new JobListViewer(jobsGroup, this, this.changeJobs);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.jobsViewer.getControl(), "com.perforce.team.ui.change_spec_jobs");
        Composite jobButtons = new Composite(jobsGroup, 0);
        GridLayout jbLayout = new GridLayout(4, false);
        jobButtons.setLayout((Layout)jbLayout);
        jobButtons.setLayoutData((Object)new GridData(4, 4, true, false));
        this.addJobsButton = new Button(jobButtons, 0);
        this.addJobsButton.setText(Messages.ChangeSpecDialog_AddJobs);
        this.addJobsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobFixDialog dlg = new JobFixDialog(ChangeSpecDialog.this.getShell(), ChangeSpecDialog.this.connection);
                if (dlg.open() == 0) {
                    ChangeSpecDialog.this.addJobs(dlg.getSelectedJobs());
                }
            }
        });
        this.addJobsButton.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
        this.removeJobsButton = new Button(jobButtons, 0);
        this.removeJobsButton.setText(Messages.ChangeSpecDialog_RemoveJobs);
        this.removeJobsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IP4Job[] jobs = ChangeSpecDialog.this.jobsViewer.getSelectedJobs();
                if (jobs != null && jobs.length > 0) {
                    ChangeSpecDialog.this.removeJobs(jobs);
                }
            }
        });
        this.jobStatusLabel = new Label(jobButtons, 16384);
        this.jobStatusLabel.setText(Messages.ChangeSpecDialog_JobStatus);
        this.jobStatusCombo = new Combo(jobButtons, 12);
        this.fillStatusCombo(this.jobStatusCombo);
        this.jobStatusCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangeSpecDialog.this.status = ChangeSpecDialog.this.jobStatusCombo.getText();
            }
        });
        if (!this.submit) {
            this.jobStatusLabel.setVisible(false);
            this.jobStatusCombo.setVisible(false);
            GridData excludeData = new GridData();
            excludeData.exclude = true;
            this.jobStatusLabel.setLayoutData((Object)excludeData);
            this.jobStatusCombo.setLayoutData((Object)excludeData);
        }
        this.updateJobEnablement();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = this.createComposite(dialogArea, 1, 1808);
        String idText = Messages.ChangeSpecDialog_Changelist;
        idText = this.id == 0 ? (this.submit ? String.valueOf(idText) + Messages.ChangeSpecDialog_Default : String.valueOf(idText) + Messages.ChangeSpecDialog_New) : (this.id == -2 ? String.valueOf(idText) + Messages.ChangeSpecDialog_New : String.valueOf(idText) + this.id);
        Label idLabel = this.createLabel(composite, idText);
        idLabel.setLayoutData((Object)new GridData(0x1000000, 1, true, false));
        Tracing.printTrace((boolean)Policy.DEBUG, (String)"SUBMIT", (String)(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ":createDescriptionArea"));
        this.createDescriptionArea(composite, this.changeFiles, this.changeJobs);
        Tracing.printTrace((boolean)Policy.DEBUG, (String)"SUBMIT", (String)(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ":createFileArea"));
        this.createFilesArea(composite, this.changeFiles);
        Tracing.printTrace((boolean)Policy.DEBUG, (String)"SUBMIT", (String)(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ":createJobArea"));
        this.createJobsArea(composite, this.changeJobs);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.addJobsButton, "com.perforce.team.ui.change_spec_add_jobs");
        this.descEditor.setFocus();
        return composite;
    }

    private void updateJobEnablement() {
        this.removeJobsButton.setEnabled(!this.changeJobs.isEmpty());
        this.jobStatusCombo.setEnabled(!this.changeJobs.isEmpty());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.submit ? this.createButton(parent, 0, Messages.ChangeSpecDialog_Submit, true) : this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.enableOk();
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void enableOk() {
        if (this.okButton != null) {
            if (this.description.trim().equals("") || this.description.trim().equals(PerforceConstants.DEFAULT_DESCRIPTION) || this.submit && this.checkedFiles.length == 0) {
                this.okButton.setEnabled(false);
            } else {
                this.okButton.setEnabled(true);
            }
        }
    }

    protected void updateCheckState() {
        if (this.okButton != null) {
            this.checkedFiles = this.filesViewer.getCheckedFiles();
            this.enableOk();
        }
    }

    public void addJobs(IP4Job[] jobs) {
        if (jobs != null && jobs.length > 0) {
            IP4Job[] iP4JobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Job job = iP4JobArray[n2];
                this.changeJobs.add(job);
                ++n2;
            }
            this.jobsViewer.refresh();
            this.updateJobEnablement();
            this.descEditor.updateJobs(this.changeJobs);
        }
    }

    public void removeJobs(IP4Job[] jobs) {
        if (jobs != null && jobs.length > 0) {
            IP4Job[] iP4JobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Job job = iP4JobArray[n2];
                this.removedJobs.add(job);
                this.changeJobs.remove(job);
                ++n2;
            }
            this.jobsViewer.refresh();
            this.updateJobEnablement();
            this.descEditor.updateJobs(this.changeJobs);
        }
    }

    public String getStatus() {
        return this.status;
    }

    protected void okPressed() {
        this.description = this.descEditor.getDescription();
        this.selected = this.checkedFiles;
        this.unselected = this.filesViewer.getUncheckedFiles();
        if (this.submit) {
            this.reopenFiles = this.reopenCheck.getSelection();
        }
        if (this.jobStatusCombo.getSelectionIndex() >= 0) {
            this.status = this.jobStatusCombo.getText();
        }
        DescriptionTemplate.saveHistory(this.description);
        super.okPressed();
    }
}

