/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Label;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import com.perforce.team.ui.labels.LabelsViewControl;
import com.perforce.team.ui.p4java.dialogs.Messages;
import com.perforce.team.ui.views.IPerforceView;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;

public class BrowseLabelDialog
extends P4StatusDialog {
    private LabelsViewControl control;
    private IP4Connection connection;
    private IP4Label label;

    public BrowseLabelDialog(Shell parent, IP4Connection connection) {
        super(parent, Messages.BrowseLabelDialog_Title);
        this.connection = connection;
        this.setShellStyle(16);
    }

    public IP4Label getSelectedLabel() {
        return this.label;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        IPerforceView view = new IPerforceView(){

            @Override
            public IWorkbenchPartSite getSite() {
                return null;
            }

            @Override
            public Shell getShell() {
                return BrowseLabelDialog.this.getShell();
            }

            @Override
            public IP4Connection getConnection() {
                return BrowseLabelDialog.this.connection;
            }
        };
        this.control = new LabelsViewControl(view){

            @Override
            protected void setViewerInput(IP4Connection con) {
                super.setViewerInput(con);
                this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        BrowseLabelDialog.this.validate();
                    }
                });
                BrowseLabelDialog.this.control.showDetails(true);
            }
        };
        this.control.createViewControl(dialogArea);
        return dialogArea;
    }

    private void validate() {
        String errorMessage = null;
        this.label = this.control.getLabelSelection();
        if (this.label == null) {
            errorMessage = Messages.BrowseLabelDialog_SelectLabelErrorPrompt;
        }
        if (errorMessage != null) {
            this.setErrorMessage(errorMessage);
        } else {
            this.setInfoMessage(Messages.BrowseLabelDialog_InformationText);
        }
    }

    public void create() {
        super.create();
        this.getShell().setSize(1000, 800);
        this.validate();
    }

    protected void okPressed() {
        this.label = this.control.getLabelSelection();
        super.okPressed();
    }
}

