/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.decorator.PerforceDecorator;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class WorkOnlineAction
extends P4Action {
    @Override
    protected void runAction() {
        P4Collection collection = this.getConnectionSelection();
        if (!collection.isEmpty()) {
            this.updateConnections(collection.members());
        }
    }

    private void updateConnections(final IP4Resource[] resources) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                IP4Resource[] iP4ResourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Resource resource = iP4ResourceArray[n2];
                    if (resource instanceof IP4Connection && ((IP4Connection)resource).isOffline()) {
                        IP4Connection connection = (IP4Connection)resource;
                        connection.setOffline(false);
                        connection.connect();
                        if (connection.isConnected()) {
                            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.AVAILABLE, (IP4Resource)connection));
                            PerforceDecorator decorator = PerforceDecorator.getActivePerforceDecorator();
                            if (decorator != null) {
                                IWorkspaceRoot root = PerforceProviderPlugin.getWorkspaceRoot();
                                decorator.resourceStateChanged((IResource[])root.getProjects());
                            }
                        } else {
                            connection.setOffline(true);
                        }
                        P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.CHANGED, (IP4Resource)connection));
                    }
                    ++n2;
                }
                WorkOnlineAction.this.updateActionState();
            }
        };
        Job job = new Job(Messages.WorkonlineAction_WorkOnline, (IP4Runnable)runnable){
            private final /* synthetic */ IP4Runnable val$runnable;
            {
                this.val$runnable = iP4Runnable;
                super($anonymous0);
            }

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.WorkonlineAction_WorkOnline, 100);
                monitor.worked(50);
                this.val$runnable.run(monitor);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    @Override
    public boolean isEnabledEx() {
        IP4Resource[] resources;
        boolean enabled = false;
        P4Collection collection = this.getConnectionSelection();
        IP4Resource[] iP4ResourceArray = resources = collection.members();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            IP4Connection connection = resource.getConnection();
            if (connection != null && connection.isOffline()) {
                enabled = true;
                break;
            }
            ++n2;
        }
        return enabled;
    }
}

