/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.team.core.p4java.IP4ProgressListener;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.P4UIProgressListener;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.views.ConsoleView;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class SyncPreviewAction
extends P4Action {
    @Override
    public boolean isEnabledEx() {
        return this.containsOnlineConnection();
    }

    public void runAction(final P4Collection collection, final boolean force, final String revision) {
        if (collection.isEmpty()) {
            return;
        }
        final ConsoleView view = ConsoleView.openInActivePerspective();
        P4Runnable runnable = new P4Runnable(){

            public String getTitle() {
                return Messages.SyncPreviewAction_PreviewingSync;
            }

            public void run(IProgressMonitor monitor) {
                P4UIProgressListener callback = new P4UIProgressListener(CmdSpec.SYNC, collection.getConnection(), monitor);
                List previews = collection.sync(force, true, revision, monitor, (IP4ProgressListener)callback);
                if (view != null) {
                    for (IFileSpec spec : previews) {
                        String local;
                        if (spec.getOpStatus() != FileSpecOpStatus.VALID) continue;
                        StringBuffer buffer = new StringBuffer();
                        if (spec.getDepotPath() != null) {
                            buffer.append(spec.getDepotPath());
                            if (spec.getEndRevision() > 0) {
                                buffer.append("#");
                                buffer.append(spec.getEndRevision());
                            }
                            buffer.append(" ");
                        }
                        if (spec.getAction() != null) {
                            buffer.append(spec.getAction().toString().toLowerCase());
                            buffer.append(" ");
                        }
                        if ((local = spec.getClientPathString()) == null) {
                            local = spec.getLocalPathString();
                        }
                        if (local != null) {
                            buffer.append(local);
                        }
                        if (buffer.length() <= 0) continue;
                        view.appendLine(1, buffer.toString());
                    }
                }
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    @Override
    protected void runAction() {
        this.runAction(this.getResourceSelection(), false, null);
    }
}

