/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.impl.generic.core.file.FilePath;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.team.core.p4java.IP4ProgressListener;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.P4UIProgressListener;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class SyncAction
extends P4Action {
    boolean force = false;

    @Override
    public boolean isEnabledEx() {
        return this.containsOnlineConnection();
    }

    @Override
    public void runAction() {
        P4Collection collection = this.getResourceSelection();
        if (!collection.isEmpty()) {
            this.sync(collection);
        }
    }

    private void sync(final P4Collection collection) {
        P4Runnable runnable = new P4Runnable(){

            public String getTitle() {
                return Messages.SyncAction_Syncing;
            }

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(this.getTitle(), 300);
                monitor.subTask(SyncAction.this.generateTitle(null, collection));
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 100);
                P4UIProgressListener callback = new P4UIProgressListener(CmdSpec.SYNC, null, (IProgressMonitor)subMonitor);
                List specs = collection.sync(SyncAction.this.force, false, null, (IProgressMonitor)subMonitor, (IP4ProgressListener)callback);
                monitor.worked(100);
                monitor.setTaskName("Refresh local resources...");
                SyncAction.this.postSync(collection, specs);
                monitor.setTaskName("Update action state...");
                monitor.worked(100);
                SyncAction.this.updateActionState();
                monitor.worked(100);
                monitor.done();
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    protected void postSync(P4Collection collection, List<IFileSpec> specs) {
        if (specs == null) {
            return;
        }
        P4Collection newList = new P4Collection();
        IP4Resource[] iP4ResourceArray = collection.members();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource r = iP4ResourceArray[n2];
            String p = r.getActionPath();
            if (p.endsWith("/...")) {
                p = p.substring(0, p.length() - 4);
            }
            for (IFileSpec s : specs) {
                FilePath cp = s.getClientPath();
                if (cp != null) {
                    String cpp = cp.getPathString();
                    if (cpp == null || !cpp.startsWith(p)) continue;
                    newList.add(r);
                    continue;
                }
                if (s.getStatusMessage() == null || !s.getStatusMessage().startsWith(p)) continue;
                newList.add(r);
            }
            ++n2;
        }
        newList.refresh();
        newList.refreshLocalResources(2);
    }

    public void setForce(boolean forceSync) {
        this.force = forceSync;
    }
}

