/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.p4java.dialogs.ChangeSpecDialog;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;

public class EditChangelistAction
extends P4Action {
    @Override
    protected void runAction() {
        P4Collection collection = this.getResourceSelection();
        IP4Resource[] members = collection.members();
        if (members.length == 1 && members[0] instanceof IP4PendingChangelist) {
            final IP4PendingChangelist list = (IP4PendingChangelist)members[0];
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    list.refresh();
                    PerforceUIPlugin.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ChangeSpecDialog dialog = new ChangeSpecDialog(list, null, EditChangelistAction.this.getShell(), false);
                            if (dialog.open() == 0) {
                                IP4PendingChangelist defaultChangelist = list.getConnection().getPendingChangelist(0);
                                String description = dialog.getDescription();
                                IP4File[] uncheckedFiles = dialog.getUncheckedFiles();
                                IP4Job[] checkedJobs = dialog.getCheckedJobs();
                                IP4Job[] uncheckedJobs = dialog.getUncheckedJobs();
                                EditChangelistAction.this.edit(uncheckedFiles, uncheckedJobs, checkedJobs, description, list, defaultChangelist);
                            }
                        }
                    });
                }

                public String getTitle() {
                    int id = list.getId();
                    if (id != 0) {
                        return MessageFormat.format(Messages.EditChangelistAction_NumberedTitle, id);
                    }
                    return Messages.EditChangelistAction_DefaultTitle;
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }

    public void edit(final IP4File[] uncheckedFiles, final IP4Job[] uncheckedJobs, final IP4Job[] checkedJobs, final String description, final IP4PendingChangelist list, final IP4PendingChangelist defaultChangelist) {
        if (list == null) {
            return;
        }
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                if (description != null) {
                    list.updateServerDescription(description);
                }
                if (uncheckedFiles != null && uncheckedFiles.length > 0) {
                    EditChangelistAction.this.createCollection((IP4Resource[])uncheckedFiles).reopen(defaultChangelist);
                }
                if (uncheckedJobs != null && uncheckedJobs.length > 0) {
                    EditChangelistAction.this.createCollection((IP4Resource[])uncheckedJobs).unfix((IP4Changelist)list);
                }
                if (checkedJobs != null && checkedJobs.length > 0) {
                    EditChangelistAction.this.createCollection((IP4Resource[])checkedJobs).fix((IP4Changelist)list);
                }
            }

            public String getTitle() {
                int id = list.getId();
                if (id != 0) {
                    return MessageFormat.format(Messages.EditChangelistAction_NumberedTitle, id);
                }
                return Messages.EditChangelistAction_DefaultTitle;
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    @Override
    public boolean isEnabledEx() {
        boolean enabled = false;
        P4Collection collection = this.getResourceSelection();
        IP4Resource[] members = collection.members();
        if (members.length == 1 && members[0] instanceof IP4PendingChangelist) {
            IP4PendingChangelist list = (IP4PendingChangelist)members[0];
            enabled = !list.isDefault() && !list.isReadOnly() && list.isOnClient();
        }
        return enabled;
    }
}

