/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;

public class DeleteChangelistAction
extends P4Action {
    @Override
    protected void runAction() {
        P4Collection collection = this.getResourceSelection();
        if (!collection.isEmpty()) {
            final IP4Resource[] resources = collection.members();
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    ArrayList<IP4PendingChangelist> pendings = new ArrayList<IP4PendingChangelist>();
                    IP4Resource[] iP4ResourceArray = resources;
                    int n = resources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IP4Resource resource = iP4ResourceArray[n2];
                        if (resource instanceof IP4PendingChangelist) {
                            pendings.add((IP4PendingChangelist)resource);
                        }
                        ++n2;
                    }
                    monitor.beginTask(Messages.DeleteChangelistAction_DeletingChangelistTask, pendings.size());
                    ArrayList<IP4PendingChangelist> deleted = new ArrayList<IP4PendingChangelist>();
                    for (final IP4PendingChangelist list : pendings) {
                        monitor.subTask(Integer.toString(list.getId()));
                        if (list.needsRefresh()) {
                            list.refresh();
                        }
                        final boolean[] delete = new boolean[]{true};
                        if (list.isShelved()) {
                            PerforceUIPlugin.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    delete[0] = P4ConnectionManager.getManager().openQuestion(P4UIUtils.getDialogShell(), Messages.DeleteChangelistAction_ChangeContainsShelvedFilesTitle, MessageFormat.format(Messages.DeleteChangelistAction_ChangeContainsShelvedFilesMessage, list.getId()));
                                }
                            });
                            if (delete[0]) {
                                list.deleteShelved();
                            }
                        }
                        if (delete[0]) {
                            list.delete();
                        }
                        monitor.worked(1);
                        if (list.getStatus() != null || list.getChangelist() != null) continue;
                        deleted.add(list);
                    }
                    monitor.done();
                    if (deleted.size() > 0) {
                        P4ConnectionManager.getManager().notifyListeners(new P4Event(P4Event.EventType.DELETE_CHANGELIST, (IP4Resource[])deleted.toArray(new IP4PendingChangelist[0])));
                    }
                }

                public String getTitle() {
                    return MessageFormat.format(Messages.DeleteChangelistAction_DeletingChangelists, resources.length);
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }

    @Override
    protected boolean isEnabledEx() throws TeamException {
        P4Collection collection = this.getResourceSelection();
        IP4Resource[] resources = collection.members();
        boolean enabled = false;
        IP4Resource[] iP4ResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4PendingChangelist) {
                IP4PendingChangelist list = (IP4PendingChangelist)resource;
                list.needsRefresh();
                enabled = list.isDeleteable();
            } else {
                enabled = false;
            }
            if (!enabled) break;
            ++n2;
        }
        return enabled;
    }
}

