/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.operations;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.team.core.p4java.IP4ClientOperation;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.P4ClientOperation;
import com.perforce.team.ui.P4ConnectionManager;
import java.util.ArrayList;
import java.util.List;

public class RetryableOperation {
    private static void runOperation(IP4Connection connection, IP4ClientOperation operation) {
        if (connection != null && operation != null) {
            boolean retry = true;
            IClient client = connection.getClient();
            while (retry && client != null) {
                retry = false;
                try {
                    operation.run(client);
                }
                catch (P4JavaException e) {
                    if (!(e instanceof AccessException)) continue;
                    retry = P4ConnectionManager.retryAfterLogin(connection, (AccessException)e);
                }
            }
        }
    }

    public static List<IFileSpec> whereWithRetry(IP4Connection connection, final List<IFileSpec> specList) throws Throwable {
        final ArrayList<IFileSpec> specs = new ArrayList<IFileSpec>();
        P4ClientOperation operation = new P4ClientOperation(){

            public void run(IClient client) throws P4JavaException, P4JavaError {
                specs.addAll(client.where(specList));
            }
        };
        RetryableOperation.runOperation(connection, (IP4ClientOperation)operation);
        return specs;
    }

    public static List<IFileSpec> haveWithRetry(IP4Connection connection, final List<IFileSpec> specList) throws Throwable {
        final ArrayList<IFileSpec> specs = new ArrayList<IFileSpec>();
        P4ClientOperation operation = new P4ClientOperation(){

            public void run(IClient client) throws P4JavaException, P4JavaError {
                specs.addAll(client.haveList(specList));
            }
        };
        RetryableOperation.runOperation(connection, (IP4ClientOperation)operation);
        return specs;
    }

    public static List<IFileSpec> fstatWithRetry(IP4Connection connection, final List<IFileSpec> specList) {
        final ArrayList<IFileSpec> specs = new ArrayList<IFileSpec>();
        P4ClientOperation operation = new P4ClientOperation(){

            public void run(IClient client) throws P4JavaException, P4JavaError {
                specs.addAll(client.getServer().getExtendedFiles(specList, 0, -1, -1, null, null));
            }
        };
        RetryableOperation.runOperation(connection, (IP4ClientOperation)operation);
        return specs;
    }
}

