/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.labels;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Label;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.labels.LabelWidget;
import com.perforce.team.ui.labels.LabelsViewer;
import com.perforce.team.ui.labels.Messages;
import com.perforce.team.ui.p4java.actions.SyncRevisionAction;
import com.perforce.team.ui.views.IPerforceView;
import com.perforce.team.ui.views.PerforceFilterViewControl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IActionBars;

public class LabelsViewControl
extends PerforceFilterViewControl {
    public static final String DISPLAY_DETAILS = "com.perforce.team.ui.labels.display_details";
    public static final String HIDE_FILTERS = "com.perforce.team.ui.labels.HIDE_FILTERS";
    private Action refreshAction;
    private Action showDetailsAction;
    private Action openPrefs;
    private Action syncLabelAction;
    private boolean displayDetails;
    private LabelsViewer labelsViewer = new LabelsViewer();

    public LabelsViewControl(IPerforceView view) {
        super(view);
        this.setFilterViewer(this.labelsViewer);
    }

    public Table getTableControl() {
        return this.labelsViewer.getTableControl();
    }

    public TableViewer getTableViewer() {
        return this.labelsViewer.getViewer();
    }

    @Override
    public void setFocus() {
        Table control = this.labelsViewer.getTableControl();
        if (control != null && !control.isDisposed()) {
            control.setFocus();
        }
    }

    @Override
    public void dispose() {
        this.removeProjectListeners();
    }

    @Override
    public void refresh() {
        this.labelsViewer.refresh();
    }

    @Override
    protected String getFilterPreference() {
        return HIDE_FILTERS;
    }

    @Override
    protected String getSelectedName() {
        return Messages.LabelsView_Labels;
    }

    @Override
    protected void createControl(Composite parent) {
        this.createMenus();
        this.showNoConnection();
        this.addProjectListeners();
    }

    public void setPath(String path) {
        this.labelsViewer.setPath(path);
    }

    private void hookContextMenu() {
        MenuManager manager = new MenuManager();
        Menu menu = manager.createContextMenu((Control)this.labelsViewer.getTableControl());
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)LabelsViewControl.this.syncLabelAction);
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        manager.setRemoveAllWhenShown(true);
        if (this.labelsViewer.getTableControl() != null) {
            this.labelsViewer.getTableControl().setMenu(menu);
        }
        this.registerContextMenu(manager, (ISelectionProvider)this.labelsViewer.getViewer());
    }

    @Override
    protected void setViewerInput(IP4Connection con) {
        if (this.connectionOK(con)) {
            this.refreshAction.setEnabled(true);
            this.labelsViewer.createControl(this.displayArea, con, false, this.displayDetails);
            this.showDisplayArea();
            this.hookContextMenu();
            this.labelsViewer.getViewer().addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (event.getSelection() instanceof IStructuredSelection) {
                        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                        boolean cfr_ignored_0 = selection.getFirstElement() instanceof IP4Label;
                    }
                }
            });
        } else {
            this.showNoConnection();
        }
    }

    @Override
    protected void showNoConnection() {
        super.showNoConnection();
        this.refreshAction.setEnabled(false);
    }

    private void createMenus() {
        PerforceUIPlugin plugin = PerforceUIPlugin.getPlugin();
        this.refreshAction = new Action(Messages.LabelsView_Refresh, plugin.getImageDescriptor("enabled/refresh.png")){

            public void run() {
                LabelsViewControl.this.labelsViewer.refresh();
            }
        };
        this.refreshAction.setToolTipText(Messages.LabelsView_RefreshLabels);
        this.refreshAction.setDisabledImageDescriptor(plugin.getImageDescriptor("disabled/refresh.png"));
        this.refreshAction.setHoverImageDescriptor(plugin.getImageDescriptor("normal/refresh.png"));
        this.openPrefs = new Action(Messages.LabelsView_OpenLabelPrefs, plugin.getImageDescriptor("views/preferences.png")){

            public void run() {
                P4UIUtils.openPreferencePage("com.perforce.team.ui.labels.LabelsPreferencePage");
            }
        };
        this.showDetailsAction = new Action(Messages.LabelsView_ShowLabelDetails){

            public int getStyle() {
                return 2;
            }
        };
        this.displayDetails = plugin.getPreferenceStore().getBoolean(DISPLAY_DETAILS);
        this.showDetailsAction.setChecked(this.displayDetails);
        this.showDetailsAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LabelsViewControl.this.displayDetails = LabelsViewControl.this.showDetailsAction.isChecked();
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(LabelsViewControl.DISPLAY_DETAILS, LabelsViewControl.this.displayDetails);
                if (LabelsViewControl.this.showingConnection()) {
                    LabelsViewControl.this.showDetails(LabelsViewControl.this.displayDetails);
                }
            }
        });
        IActionBars bars = this.getActionBars();
        if (bars != null) {
            IToolBarManager tbm = bars.getToolBarManager();
            tbm.add((IAction)this.refreshAction);
            tbm.add((IAction)this.openPrefs);
            tbm.update(false);
            this.syncLabelAction = new Action(Messages.LabelsView_GetRevision, 1){

                public void run() {
                    SyncRevisionAction sync = new SyncRevisionAction();
                    sync.selectionChanged(null, (ISelection)new StructuredSelection((Object)LabelsViewControl.this.p4Connection));
                    IP4Label label = LabelsViewControl.this.getLabelSelection();
                    if (label != null) {
                        sync.runWithDialog(label.getName(), true);
                    }
                }
            };
            IMenuManager pulldown = bars.getMenuManager();
            pulldown.add((IAction)this.showDetailsAction);
            this.createFilterAction((IContributionManager)pulldown);
            pulldown.update(false);
        }
    }

    public IP4Label getLabelSelection() {
        IStructuredSelection selection;
        IP4Label selected = null;
        if (this.getTableViewer() != null && (selection = (IStructuredSelection)this.getTableViewer().getSelection()).size() == 1 && selection.getFirstElement() instanceof IP4Label) {
            selected = (IP4Label)selection.getFirstElement();
        }
        return selected;
    }

    public boolean isLoading() {
        return this.labelsViewer != null && this.labelsViewer.isLoading();
    }

    @Override
    public void refreshRetrieveCount() {
        if (this.labelsViewer != null) {
            this.labelsViewer.refreshRetrieveCount();
        }
    }

    @Override
    public void showMore() {
        if (this.labelsViewer != null) {
            this.labelsViewer.showMore();
        }
    }

    public void showDetails(boolean show) {
        if (this.labelsViewer != null && this.showingConnection()) {
            this.labelsViewer.updateSash(show);
        }
    }

    public void showDisplayDetails(boolean show) {
        if (this.labelsViewer != null) {
            this.labelsViewer.updateSash(show);
        }
    }

    public LabelWidget getLabelDetails() {
        if (this.labelsViewer != null) {
            return this.labelsViewer.getDetails();
        }
        return null;
    }
}

