/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.jobs;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceContentProvider;
import com.perforce.team.ui.PerforceLabelProvider;
import com.perforce.team.ui.p4java.actions.EditJobAction;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;

public class JobsWidget {
    private Composite displayArea;
    private TreeViewer viewer;
    private boolean enableEdit;

    public JobsWidget(boolean enableEdit) {
        this.enableEdit = enableEdit;
    }

    public int getJobCount() {
        return this.viewer.getTree().getItemCount();
    }

    public void setInput(IP4Resource[] jobs) {
        if (jobs != null) {
            this.viewer.setInput((Object)jobs);
        } else {
            this.viewer.setInput((Object)PerforceContentProvider.EMPTY);
        }
    }

    public void createControl(Composite parent) {
        this.createControl(parent, null);
    }

    protected ITreeContentProvider createContentProvider(TreeViewer viewer) {
        return new PerforceContentProvider((StructuredViewer)viewer, true);
    }

    public void createControl(Composite parent, ViewerFilter filter) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createToolbar(this.displayArea);
        this.viewer = new TreeViewer(this.displayArea, 2818);
        if (filter != null) {
            this.viewer.addFilter(filter);
        }
        GridData vData = new GridData(4, 4, true, true);
        vData.heightHint = 80;
        this.viewer.getTree().setLayoutData((Object)vData);
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IP4Job && e2 instanceof IP4Job) {
                    String id1 = ((IP4Job)e1).getId();
                    String id2 = ((IP4Job)e2).getId();
                    if (id1 != null) {
                        return id1.compareTo(id2);
                    }
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.viewer.setContentProvider((IContentProvider)this.createContentProvider(this.viewer));
        this.viewer.setLabelProvider((IBaseLabelProvider)new PerforceLabelProvider(false){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                IP4Job job;
                String desc;
                if (element instanceof IP4Job && (desc = (job = (IP4Job)element).getShortDescription()) != null && desc.length() > 0) {
                    return String.valueOf(job.getId()) + " : " + P4CoreUtils.removeWhitespace((String)desc);
                }
                return super.getColumnText(element, columnIndex);
            }
        });
        if (this.enableEdit) {
            this.viewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    IStructuredSelection select = (IStructuredSelection)JobsWidget.this.viewer.getSelection();
                    if (select.size() == 1) {
                        JobsWidget.this.handleDoubleClick(select.getFirstElement());
                    }
                }
            });
        }
    }

    protected void handleDoubleClick(Object selected) {
        if (selected instanceof IP4Job) {
            EditJobAction edit = new EditJobAction();
            edit.selectionChanged(null, (ISelection)new StructuredSelection(selected));
            edit.doubleClick(null);
        }
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public Composite getControl() {
        return this.displayArea;
    }

    public void showLoading() {
        IContentProvider provider = this.viewer.getContentProvider();
        if (provider instanceof PerforceContentProvider) {
            this.viewer.setInput((Object)new PerforceContentProvider.Loading());
        }
    }

    protected void createToolbar(Composite parent) {
        ToolBar toolbar = new ToolBar(parent, 0x800040);
        this.fillToolbar(toolbar);
    }

    protected void fillToolbar(ToolBar toolbar) {
    }

    public boolean okToUse() {
        return P4UIUtils.okToUse((Viewer)this.viewer);
    }
}

