/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.history;

import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.IRevisionIntegrationData;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.ILocalRevision;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Revision;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.editor.CompareUtils;
import com.perforce.team.ui.editor.RevisionEditorInput;
import com.perforce.team.ui.history.HistoryDragAdapter;
import com.perforce.team.ui.history.HistorySorter;
import com.perforce.team.ui.history.Messages;
import com.perforce.team.ui.history.P4HistoryPageSource;
import com.perforce.team.ui.p4java.actions.SyncRevisionAction;
import com.perforce.team.ui.views.HistoryDropAdapter;
import com.perforce.team.ui.views.SessionManager;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.progress.UIJob;

public class P4HistoryPage
extends HistoryPage {
    public static final String COLUMN_SIZES = "com.perforce.team.ui.historycolumns";
    public static final String DISPLAY_BRANCHING_HISTORY = "com.perforce.team.ui.history.display_branching_history";
    public static final String GROUP_REVISIONS = "com.perforce.team.ui.history.GROUP_REVISIONS";
    public static final String COMPARE_MODE = "com.perforce.team.ui.history.COMPARE_MODE";
    public static final String SHOW_SEARCH = "com.perforce.team.ui.history.SHOW_SEARCH";
    public static final String WRAP_TEXT = "com.perforce.team.ui.history.WRAP_TEXT";
    public static final String SHOW_COMMENTS = "com.perforce.team.ui.history.SHOW_COMMENTS";
    public static final String LOCAL_MODE = "LOCAL_MODE";
    public static final String REMOTE_MODE = "REMOTE_MODE";
    public static final String ALL_MODE = "ALL_MODE";
    public static final String REVISION_COLUMN = Messages.P4HistoryPage_Revision;
    public static final String FILENAME_COLUMN = Messages.P4HistoryPage_FileName;
    public static final String CHANGELIST_COLUMN = Messages.P4HistoryPage_Changelist;
    public static final String DATE_COLUMN = Messages.P4HistoryPage_Date;
    public static final String USER_COLUMN = Messages.P4HistoryPage_User;
    public static final String ACTION_COLUMN = Messages.P4HistoryPage_Action;
    public static final String DESCRIPTION_COLUMN = Messages.P4HistoryPage_Description;
    private IP4File file = null;
    private SashForm sash;
    private Composite composite;
    private Composite searchArea;
    private Text searchText;
    private String searchString = null;
    private TreeViewer treeViewer;
    private HistorySorter sorter;
    private SourceViewer textViewer;
    private IP4File currentFile;
    private IP4Revision latestRev;
    private IP4Listener p4Listener = new IP4Listener(){

        public void resoureChanged(P4Event event) {
            if (P4Event.EventType.REFRESHED == event.getType() && event.contains((IP4Resource)P4HistoryPage.this.currentFile)) {
                UIJob refreshJob = new UIJob(Messages.P4HistoryPage_RefreshingRevisionHistory){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (P4HistoryPage.this.okToUse()) {
                            P4HistoryPage.this.treeViewer.refresh();
                        }
                        return Status.OK_STATUS;
                    }
                };
                refreshJob.schedule();
            }
        }

        public String getName() {
            return ((Object)((Object)P4HistoryPage.this)).getClass().getSimpleName();
        }
    };
    private Action branchAction;
    private Action compareAction;
    private Action groupAction;
    private Action modeAction;
    private Action toggleSearchAction;
    private Action wrapTextAction;
    private Action showLocalAction;
    private Action showRemoteAction;
    private Action showAllAction;
    private Action showComments;
    private Action openRevisionAction;
    private Action syncRevisionAction;
    private final Object loading = new Object();
    private boolean isLoading = false;

    private static String getActionText(IP4Revision data) {
        IRevisionIntegrationData[] integActions;
        StringBuilder actionText = new StringBuilder();
        FileAction fileAction = data.getAction();
        if (fileAction != null) {
            actionText.append(fileAction.toString().toLowerCase());
        }
        if ((integActions = data.getIntegrationData()) != null) {
            IRevisionIntegrationData[] iRevisionIntegrationDataArray = integActions;
            int n = integActions.length;
            int n2 = 0;
            while (n2 < n) {
                IRevisionIntegrationData integData = iRevisionIntegrationDataArray[n2];
                if (integData != null) {
                    if (actionText.length() > 0) {
                        actionText.append(";");
                    }
                    actionText.append(" " + integData.getHowFrom() + " " + integData.getFromFile());
                    int end = integData.getEndFromRev();
                    if (end > -1) {
                        actionText.append("#" + end);
                    }
                }
                ++n2;
            }
        }
        return P4HistoryPage.convert(actionText.toString());
    }

    private static String convert(String unconverted) {
        return P4CoreUtils.removeWhitespace((String)unconverted);
    }

    private static String getDateText(long timestamp) {
        return DateFormat.getDateTimeInstance().format(new Date(timestamp));
    }

    private static String getIntText(int integer) {
        return Integer.toString(integer);
    }

    public P4HistoryPage(Object input) {
        this.setInput(input);
    }

    private boolean isHaveRevision(IP4Revision data) {
        return data.getRevision() == this.file.getHaveRevision() && data.getRemotePath().equals(this.file.getRemotePath());
    }

    private Map<String, Integer> loadColumnSizes() {
        return SessionManager.loadColumnSizes(COLUMN_SIZES);
    }

    private void saveColumnSizes() {
        SessionManager.saveColumnPreferences(this.treeViewer.getTree(), COLUMN_SIZES);
    }

    public Viewer getViewer() {
        return this.treeViewer;
    }

    public boolean isBranchingDisplayed() {
        return PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean(DISPLAY_BRANCHING_HISTORY);
    }

    private void openEditor(IP4Revision data) {
        RevisionEditorInput input = new RevisionEditorInput(data);
        P4UIUtils.openEditor(input);
    }

    private void showHistory(final IP4File file) {
        if (!this.okToUse()) {
            return;
        }
        this.isLoading = true;
        this.currentFile = file;
        String name = file.getName();
        final String loading = NLS.bind((String)Messages.P4HistoryPage_LoadingHistoryFor, (Object)name);
        this.compareAction.setEnabled(false);
        this.treeViewer.setInput(this.loading);
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return loading;
            }

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(this.getTitle(), 2);
                final IFileRevision[] history = file.getCompleteHistory(P4HistoryPage.this.isBranchingDisplayed(), monitor);
                final IP4Revision[] latestRevision = new IP4Revision[1];
                IFileRevision[] iFileRevisionArray = history;
                int n = history.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileRevision rev = iFileRevisionArray[n2];
                    if (rev instanceof IP4Revision) {
                        if (latestRevision[0] != null) {
                            IP4Revision p4Rev = (IP4Revision)rev;
                            if (p4Rev.getChangelist() > latestRevision[0].getChangelist()) {
                                latestRevision[0] = (IP4Revision)rev;
                            }
                        } else {
                            latestRevision[0] = (IP4Revision)rev;
                        }
                    }
                    ++n2;
                }
                monitor.done();
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (P4HistoryPage.this.currentFile == file && P4UIUtils.okToUse((Viewer)P4HistoryPage.this.treeViewer)) {
                            P4HistoryPage.this.treeViewer.setInput((Object)history);
                            P4HistoryPage.this.latestRev = latestRevision[0];
                            P4HistoryPage.this.isLoading = false;
                        }
                    }
                });
            }
        });
    }

    private Tree createTable(Composite parent) {
        Tree table = new Tree(parent, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        this.treeViewer = new TreeViewer(table);
        this.treeViewer.setAutoExpandLevel(-1);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    P4HistoryPage.this.compareAction.setEnabled(((IStructuredSelection)event.getSelection()).size() == 2);
                }
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                block4: {
                    IStructuredSelection selection;
                    block2: {
                        IFileRevision data;
                        block5: {
                            Object element;
                            block3: {
                                selection = (IStructuredSelection)P4HistoryPage.this.treeViewer.getSelection();
                                if (!P4HistoryPage.this.modeAction.isChecked()) break block2;
                                if (selection.size() != 2) break block3;
                                P4HistoryPage.this.compareSelection(true);
                                break block4;
                            }
                            if (selection.size() != 1 || !((element = selection.getFirstElement()) instanceof IFileRevision)) break block4;
                            data = (IFileRevision)element;
                            if (P4HistoryPage.this.file.getHaveRevision() <= 0) break block5;
                            CompareUtils.openLocalCompare(P4HistoryPage.this.file, data);
                            break block4;
                        }
                        if (P4HistoryPage.this.latestRev == null) break block4;
                        CompareUtils.openCompare((IFileRevision)P4HistoryPage.this.latestRev, data);
                        break block4;
                    }
                    Object[] objectArray = selection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element instanceof IP4Revision) {
                            P4HistoryPage.this.openEditor((IP4Revision)element);
                        }
                        ++n2;
                    }
                }
            }
        });
        this.treeViewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                P4HistoryPage.this.saveColumnSizes();
            }
        });
        this.treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof RevisionGroup) {
                    return true;
                }
                if (element instanceof IFileRevision) {
                    if (!P4HistoryPage.this.filterByMode((IFileRevision)element)) {
                        return false;
                    }
                    if (P4HistoryPage.this.searchString != null && element instanceof IP4Revision) {
                        IP4Revision data = (IP4Revision)element;
                        if (P4HistoryPage.getIntText(data.getRevision()).indexOf(P4HistoryPage.this.searchString) != -1) {
                            return true;
                        }
                        if (data.getRemotePath().indexOf(P4HistoryPage.this.searchString) != -1) {
                            return true;
                        }
                        if (P4HistoryPage.getIntText(data.getChangelist()).indexOf(P4HistoryPage.this.searchString) != -1) {
                            return true;
                        }
                        if (P4HistoryPage.getDateText(data.getTimestamp()).indexOf(P4HistoryPage.this.searchString) != -1) {
                            return true;
                        }
                        if (data.getAuthor().indexOf(P4HistoryPage.this.searchString) != -1) {
                            return true;
                        }
                        if (P4HistoryPage.getActionText(data).indexOf(P4HistoryPage.this.searchString) != -1) {
                            return true;
                        }
                        return P4HistoryPage.convert(data.getComment()).indexOf(P4HistoryPage.this.searchString) != -1;
                    }
                }
                return true;
            }
        });
        SelectionAdapter headerListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeColumn column = (TreeColumn)e.widget;
                P4HistoryPage.this.sorter.setSortColumn(column.getText());
                P4HistoryPage.this.treeViewer.refresh();
            }
        };
        this.addColumn(this.treeViewer, REVISION_COLUMN);
        this.addColumn(this.treeViewer, FILENAME_COLUMN);
        this.addColumn(this.treeViewer, CHANGELIST_COLUMN);
        TreeColumn dateColumn = this.addColumn(this.treeViewer, DATE_COLUMN);
        this.addColumn(this.treeViewer, USER_COLUMN);
        this.addColumn(this.treeViewer, ACTION_COLUMN);
        this.addColumn(this.treeViewer, DESCRIPTION_COLUMN);
        TreeColumn[] treeColumnArray = this.treeViewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.addSelectionListener((SelectionListener)headerListener);
            ++n2;
        }
        table.setSortColumn(dateColumn);
        table.setSortDirection(1024);
        Map<String, Integer> columnSizes = this.loadColumnSizes();
        TreeColumn[] treeColumnArray2 = this.treeViewer.getTree().getColumns();
        int n3 = treeColumnArray2.length;
        n = 0;
        while (n < n3) {
            int size;
            TreeColumn column = treeColumnArray2[n];
            int width = 100;
            if (columnSizes.containsKey(column.getText()) && (size = columnSizes.get(column.getText()).intValue()) > 0) {
                width = size;
            }
            layout.addColumnData((ColumnLayoutData)new ColumnPixelData(width, true));
            ++n;
        }
        this.treeViewer.setContentProvider((IContentProvider)new HistoryContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new HistoryLabelProvider());
        this.treeViewer.addDragSupport(23, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new HistoryDragAdapter((ISelectionProvider)this.treeViewer));
        this.treeViewer.addDropSupport(23, new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance(), LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new HistoryDropAdapter(this));
        this.sorter = new HistorySorter(this.treeViewer.getTree(), DATE_COLUMN){

            @Override
            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof RevisionGroup && e2 instanceof RevisionGroup) {
                    return ((RevisionGroup)e1).date.compareTo(((RevisionGroup)e2).date) * -1;
                }
                return super.compare(viewer, e1, e2);
            }
        };
        this.treeViewer.setSorter((ViewerSorter)this.sorter);
        return table;
    }

    private TreeColumn addColumn(TreeViewer viewer, String title) {
        TreeColumn col = new TreeColumn(viewer.getTree(), 0);
        col.setResizable(true);
        col.setText(title);
        return col;
    }

    public boolean okToUse() {
        return this.treeViewer != null && this.treeViewer.getTree() != null && !this.treeViewer.getTree().isDisposed();
    }

    public void compare(IFileRevision revision1, IFileRevision revision2) {
        if (revision1 == null || revision2 == null) {
            return;
        }
        boolean swap = false;
        if (revision2 instanceof ILocalRevision && ((ILocalRevision)revision2).isCurrent()) {
            swap = true;
        }
        if (revision1 instanceof IP4Revision && revision2 instanceof ILocalRevision) {
            swap = true;
        } else if (revision1 instanceof IP4Revision && revision2 instanceof IP4Revision || revision1 instanceof ILocalRevision && revision2 instanceof ILocalRevision) {
            boolean bl = swap = revision2.getTimestamp() > revision1.getTimestamp();
        }
        if (swap) {
            CompareUtils.openCompare(revision2, revision1);
        } else {
            CompareUtils.openCompare(revision1, revision2);
        }
    }

    private void createModeActions(IToolBarManager toolbar) {
        PerforceUIPlugin plugin = PerforceUIPlugin.getPlugin();
        String mode = plugin.getPreferenceStore().getString("com.perforce.team.ui.preferences.HISTORY_SHOW_MODE");
        this.showAllAction = new Action("", 8){

            public void run() {
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue("com.perforce.team.ui.preferences.HISTORY_SHOW_MODE", P4HistoryPage.ALL_MODE);
                P4HistoryPage.this.treeViewer.refresh();
            }
        };
        this.showAllAction.setImageDescriptor(plugin.getImageDescriptor("normal/all_history.png"));
        this.showLocalAction = new Action("", 8){

            public void run() {
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue("com.perforce.team.ui.preferences.HISTORY_SHOW_MODE", P4HistoryPage.LOCAL_MODE);
                P4HistoryPage.this.treeViewer.refresh();
            }
        };
        this.showLocalAction.setImageDescriptor(plugin.getImageDescriptor("normal/local_history.png"));
        this.showRemoteAction = new Action("", 8){

            public void run() {
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue("com.perforce.team.ui.preferences.HISTORY_SHOW_MODE", P4HistoryPage.REMOTE_MODE);
                P4HistoryPage.this.treeViewer.refresh();
            }
        };
        this.showRemoteAction.setImageDescriptor(plugin.getImageDescriptor("normal/remote_history.png"));
        if (mode.equals(LOCAL_MODE)) {
            this.showLocalAction.setChecked(true);
        } else if (mode.equals(ALL_MODE)) {
            this.showAllAction.setChecked(true);
        } else {
            this.showRemoteAction.setChecked(true);
        }
        toolbar.add((IAction)this.showAllAction);
        toolbar.add((IAction)this.showLocalAction);
        toolbar.add((IAction)this.showRemoteAction);
    }

    private void createPulldownActions(IMenuManager pulldown) {
        PerforceUIPlugin plugin = PerforceUIPlugin.getPlugin();
        this.branchAction = new Action(Messages.P4HistoryPage_DisplayBranchingHistory){

            public int getStyle() {
                return 2;
            }
        };
        this.branchAction.setChecked(this.isBranchingDisplayed());
        this.branchAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(P4HistoryPage.DISPLAY_BRANCHING_HISTORY, P4HistoryPage.this.branchAction.isChecked());
                if (P4HistoryPage.this.currentFile != null) {
                    P4HistoryPage.this.showHistory(P4HistoryPage.this.currentFile);
                } else {
                    P4HistoryPage.this.treeViewer.refresh();
                }
            }
        });
        this.toggleSearchAction = new Action(Messages.P4HistoryPage_ShowSearchField, 2){

            public void run() {
                boolean checked = this.isChecked();
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(P4HistoryPage.SHOW_SEARCH, checked);
                P4HistoryPage.this.searchArea.setVisible(checked);
                ((GridData)((P4HistoryPage)P4HistoryPage.this).searchArea.getLayoutData()).exclude = !checked;
                P4HistoryPage.this.searchArea.getParent().layout(true, true);
                if (!checked) {
                    P4HistoryPage.this.searchString = null;
                    P4HistoryPage.this.treeViewer.refresh();
                }
            }
        };
        this.toggleSearchAction.setToolTipText(Messages.P4HistoryPage_ShowSearchFieldTooltip);
        this.toggleSearchAction.setChecked(plugin.getPreferenceStore().getBoolean(SHOW_SEARCH));
        this.wrapTextAction = new Action(Messages.P4HistoryPage_WrapDescriptionViewer, 2){

            public void run() {
                boolean checked = this.isChecked();
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(P4HistoryPage.WRAP_TEXT, checked);
                P4HistoryPage.this.textViewer.getTextWidget().setWordWrap(checked);
            }
        };
        this.wrapTextAction.setChecked(plugin.getPreferenceStore().getBoolean(WRAP_TEXT));
        this.showComments = new Action(Messages.P4HistoryPage_ShowDescriptionViewer, 2){

            public void run() {
                boolean checked = this.isChecked();
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(P4HistoryPage.SHOW_COMMENTS, checked);
                if (checked) {
                    P4HistoryPage.this.sash.setMaximizedControl(null);
                } else {
                    P4HistoryPage.this.sash.setMaximizedControl((Control)P4HistoryPage.this.composite);
                }
            }
        };
        this.showComments.setChecked(plugin.getPreferenceStore().getBoolean(SHOW_COMMENTS));
        pulldown.add((IAction)this.branchAction);
        pulldown.add((IAction)this.toggleSearchAction);
        pulldown.add((IAction)this.showComments);
        pulldown.add((IAction)this.wrapTextAction);
        pulldown.update(false);
    }

    private boolean filterByMode(IFileRevision revision) {
        if (this.showAllAction.isChecked()) {
            return true;
        }
        if (this.showLocalAction.isChecked()) {
            return revision instanceof ILocalRevision;
        }
        if (this.showRemoteAction.isChecked()) {
            return revision instanceof P4Revision;
        }
        return true;
    }

    private void createActions() {
        PerforceUIPlugin plugin = PerforceUIPlugin.getPlugin();
        this.groupAction = new Action("", 2){

            public void run() {
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(P4HistoryPage.GROUP_REVISIONS, this.isChecked());
                P4HistoryPage.this.treeViewer.refresh();
                P4HistoryPage.this.treeViewer.expandAll();
            }
        };
        this.groupAction.setToolTipText(Messages.P4HistoryPage_GroupRevisionsByDate);
        this.groupAction.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("normal/dates.png"));
        this.groupAction.setChecked(plugin.getPreferenceStore().getBoolean(GROUP_REVISIONS));
        this.compareAction = new Action(Messages.P4HistoryPage_DiffTwoRevisions, plugin.getImageDescriptor("normal/diff.png")){

            public void run() {
                P4HistoryPage.this.compareSelection(true);
            }
        };
        this.compareAction.setEnabled(false);
        this.modeAction = new Action(Messages.P4HistoryPage_CompareMode, 2){

            public void run() {
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(P4HistoryPage.COMPARE_MODE, this.isChecked());
            }
        };
        this.modeAction.setToolTipText(Messages.P4HistoryPage_CompareModeTooltip);
        this.modeAction.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("normal/compare.png"));
        this.modeAction.setChecked(plugin.getPreferenceStore().getBoolean(COMPARE_MODE));
        this.openRevisionAction = new Action(Messages.P4HistoryPage_OpenInEditor){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)P4HistoryPage.this.treeViewer.getSelection();
                if (selection.getFirstElement() instanceof IP4Revision) {
                    IP4Revision revision = (IP4Revision)selection.getFirstElement();
                    P4HistoryPage.this.openEditor(revision);
                }
            }
        };
        this.syncRevisionAction = new Action(Messages.P4HistoryPage_GetRevision, plugin.getImageDescriptor("normal/sync.png")){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)P4HistoryPage.this.treeViewer.getSelection();
                if (selection.size() == 1 && selection.getFirstElement() instanceof IP4Revision) {
                    IP4Revision revision = (IP4Revision)selection.getFirstElement();
                    IP4File file = P4HistoryPage.this.getFileInput();
                    if (!P4HistoryPage.this.isBranchRevision(revision)) {
                        SyncRevisionAction action = new SyncRevisionAction();
                        action.selectionChanged(null, (ISelection)new StructuredSelection((Object)file));
                        action.runAction(revision.getRevision());
                    }
                }
            }
        };
        MenuManager manager = new MenuManager();
        Menu menu = manager.createContextMenu(this.treeViewer.getControl());
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)P4HistoryPage.this.treeViewer.getSelection();
                if (!selection.isEmpty()) {
                    if (selection.size() == 2) {
                        manager.add((IAction)P4HistoryPage.this.compareAction);
                    } else if (selection.size() == 1 && selection.getFirstElement() instanceof IP4Revision) {
                        manager.add((IAction)P4HistoryPage.this.openRevisionAction);
                        if (!P4HistoryPage.this.isBranchRevision((IP4Revision)selection.getFirstElement())) {
                            manager.add((IAction)P4HistoryPage.this.syncRevisionAction);
                        }
                    }
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        manager.setRemoveAllWhenShown(true);
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu("additions", manager, (ISelectionProvider)this.treeViewer);
        IActionBars bars = this.getSite().getActionBars();
        IToolBarManager tbm = bars.getToolBarManager();
        tbm.add((IAction)this.groupAction);
        tbm.add((IContributionItem)new Separator());
        this.createModeActions(tbm);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.modeAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.compareAction);
        tbm.update(false);
        this.createPulldownActions(bars.getMenuManager());
    }

    private boolean isBranchRevision(IP4Revision revision) {
        return !this.getFileInput().getRemotePath().equals(revision.getRemotePath());
    }

    public void compareSelection(boolean async) {
        Object[] revisions;
        IStructuredSelection selection;
        if (!this.okToUse()) {
            return;
        }
        ISelection sel = this.treeViewer.getSelection();
        if (sel instanceof IStructuredSelection && (selection = (IStructuredSelection)sel).size() == 2 && (revisions = selection.toArray())[0] instanceof IFileRevision && revisions[1] instanceof IFileRevision) {
            IFileRevision data1 = (IFileRevision)revisions[0];
            IFileRevision data2 = (IFileRevision)revisions[1];
            this.compare(data1, data2);
        }
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public boolean inputSet() {
        this.file = null;
        this.showHistory(this.getFileInput());
        return true;
    }

    public IP4File getFileInput() {
        if (this.file == null) {
            Object pageSource;
            Object input = this.getInput();
            IResource resource = P4CoreUtils.getResource((Object)this.getInput());
            if (resource instanceof IFile) {
                IP4Resource p4File = P4ConnectionManager.getManager().getResource((IResource)((IFile)resource));
                if (p4File instanceof IP4File && p4File.getConnection() != null && !p4File.getConnection().isOffline()) {
                    this.file = (IP4File)p4File;
                }
            } else if (input instanceof IP4File) {
                this.file = (IP4File)input;
            } else if (input instanceof P4HistoryPageSource) {
                this.file = ((P4HistoryPageSource)((Object)input)).getFile();
            } else if (input instanceof IAdaptable && (pageSource = Platform.getAdapterManager().getAdapter(input, IHistoryPageSource.class)) instanceof P4HistoryPageSource) {
                this.file = ((P4HistoryPageSource)((Object)pageSource)).getFile();
            }
        }
        return this.file;
    }

    public void dispose() {
        P4ConnectionManager.getManager().removeListener(this.p4Listener);
        super.dispose();
    }

    private void createSearch(Composite parent) {
        this.searchArea = new Composite(parent, 0);
        GridLayout saLayout = new GridLayout(2, false);
        saLayout.marginHeight = 0;
        saLayout.marginWidth = 0;
        this.searchArea.setLayout((Layout)saLayout);
        GridData saData = new GridData(4, 4, true, false);
        saData.exclude = !PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean(SHOW_SEARCH);
        this.searchArea.setLayoutData((Object)saData);
        Label searchLabel = new Label(this.searchArea, 16384);
        searchLabel.setText(Messages.P4HistoryPage_Search);
        this.searchText = new Text(this.searchArea, 2052);
        this.searchText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                P4HistoryPage.this.searchString = P4HistoryPage.this.searchText.getText().trim();
                if (P4HistoryPage.this.searchString.length() == 0) {
                    P4HistoryPage.this.searchString = null;
                }
                P4HistoryPage.this.treeViewer.refresh();
            }
        });
    }

    public void createControl(Composite parent) {
        boolean showViewer;
        P4ConnectionManager.getManager().addListener(this.p4Listener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.perforce.team.ui.history_view");
        this.sash = new SashForm(parent, 512);
        this.composite = new Composite((Composite)this.sash, 0);
        GridLayout gl = new GridLayout(1, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        this.composite.setLayout((Layout)gl);
        this.createSearch(this.composite);
        Tree table = this.createTable(this.composite);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        table.setLayoutData((Object)gd);
        this.textViewer = new SourceViewer((Composite)this.sash, null, 2826);
        this.textViewer.configure((SourceViewerConfiguration)new TextSourceViewerConfiguration(EditorsUI.getPreferenceStore()){

            protected Map getHyperlinkDetectorTargets(ISourceViewer targetViewer) {
                Map targets = super.getHyperlinkDetectorTargets((ISourceViewer)P4HistoryPage.this.textViewer);
                if (targets != null) {
                    targets.put("org.eclipse.ui.DefaultTextEditor", P4HistoryPage.this);
                }
                return targets;
            }

            public int getHyperlinkStateMask(ISourceViewer viewer) {
                return 0;
            }
        });
        boolean wrap = PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean(WRAP_TEXT);
        if (wrap) {
            this.textViewer.getTextWidget().setWordWrap(wrap);
        }
        if (!(showViewer = PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean(SHOW_COMMENTS))) {
            this.sash.setMaximizedControl((Control)this.composite);
        }
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)new TableSelectionChangedListener());
        this.createActions();
    }

    public String getDescription() {
        return this.getFileInput().getRemotePath();
    }

    public String getName() {
        return this.getFileInput().getName();
    }

    public boolean isValidInput(Object object) {
        return object instanceof IP4File;
    }

    public void refresh() {
        this.showHistory(this.getFileInput());
    }

    public Object getAdapter(Class adapter) {
        IP4File adapted = null;
        IP4File currentFile = this.file;
        if (currentFile != null) {
            if (IP4Resource.class == adapter || IP4File.class == adapter) {
                adapted = currentFile;
            } else if (IP4Connection.class == adapter) {
                adapted = currentFile.getConnection();
            } else if (IResource.class == adapter) {
                adapted = currentFile.getLocalFileForLocation();
            }
        }
        if (adapted == null) {
            return Platform.getAdapterManager().getAdapter((Object)this, adapter);
        }
        return adapted;
    }

    public Control getControl() {
        return this.sash;
    }

    public void setFocus() {
        this.sash.setFocus();
    }

    private class HistoryContentProvider
    implements ITreeContentProvider {
        private IFileRevision[] history = null;
        private RevisionGroup thisMonth = null;
        private RevisionGroup beforeThisMonth = null;

        HistoryContentProvider() {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            this.thisMonth = new RevisionGroup();
            this.thisMonth.date = calendar.getTime();
            this.thisMonth.label = Messages.P4HistoryPage_ThisMonth;
            this.beforeThisMonth = new RevisionGroup();
            this.beforeThisMonth.date = new Date(this.thisMonth.date.getTime() - 1000L);
            this.beforeThisMonth.label = Messages.P4HistoryPage_OlderThanThisMonth;
        }

        public Object[] getChildren(Object parentElement) {
            if (this.thisMonth == parentElement) {
                ArrayList<IFileRevision> thisMonths = new ArrayList<IFileRevision>();
                IFileRevision[] iFileRevisionArray = this.history;
                int n = this.history.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileRevision data = iFileRevisionArray[n2];
                    if (this.beforeThisMonth.date.before(new Date(data.getTimestamp()))) {
                        thisMonths.add(data);
                    }
                    ++n2;
                }
                return thisMonths.toArray(new IFileRevision[thisMonths.size()]);
            }
            if (this.beforeThisMonth == parentElement) {
                ArrayList<IFileRevision> thisMonths = new ArrayList<IFileRevision>();
                IFileRevision[] iFileRevisionArray = this.history;
                int n = this.history.length;
                int n3 = 0;
                while (n3 < n) {
                    IFileRevision data = iFileRevisionArray[n3];
                    if (!this.beforeThisMonth.date.before(new Date(data.getTimestamp()))) {
                        thisMonths.add(data);
                    }
                    ++n3;
                }
                return thisMonths.toArray(new IFileRevision[thisMonths.size()]);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IFileRevision) {
                IFileRevision data = (IFileRevision)element;
                if (this.beforeThisMonth.date.before(new Date(data.getTimestamp()))) {
                    return this.thisMonth;
                }
                return this.beforeThisMonth;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element == this.thisMonth || element == this.beforeThisMonth;
        }

        public Object[] getElements(Object inputElement) {
            if (P4HistoryPage.this.groupAction.isChecked()) {
                return new Object[]{this.thisMonth, this.beforeThisMonth};
            }
            return this.history;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.history = newInput instanceof IFileRevision[] ? (IFileRevision[])newInput : new IFileRevision[0];
        }
    }

    private class HistoryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        private Image groupImage = null;

        private HistoryLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof RevisionGroup && columnIndex == 0) {
                if (this.groupImage == null) {
                    this.groupImage = PerforceUIPlugin.getPlugin().getImageDescriptor("normal/dates.png").createImage();
                }
                return this.groupImage;
            }
            return null;
        }

        public void dispose() {
            super.dispose();
            if (this.groupImage != null) {
                this.groupImage.dispose();
            }
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IP4Revision) {
                IP4Revision revision = (IP4Revision)element;
                switch (columnIndex) {
                    case 0: {
                        StringBuilder builder = new StringBuilder();
                        if (P4HistoryPage.this.isHaveRevision(revision)) {
                            builder.append('*');
                        }
                        builder.append(revision.getRevision());
                        return builder.toString();
                    }
                    case 1: {
                        return revision.getRemotePath();
                    }
                    case 2: {
                        return P4HistoryPage.getIntText(revision.getChangelist());
                    }
                    case 3: {
                        return P4HistoryPage.getDateText(revision.getTimestamp());
                    }
                    case 4: {
                        return revision.getAuthor();
                    }
                    case 5: {
                        return P4HistoryPage.getActionText(revision);
                    }
                    case 6: {
                        return P4HistoryPage.convert(revision.getComment());
                    }
                }
                return "";
            }
            if (element instanceof IFileRevision) {
                IFileRevision revision = (IFileRevision)element;
                switch (columnIndex) {
                    case 1: {
                        return revision.getURI().getPath();
                    }
                    case 3: {
                        return P4HistoryPage.getDateText(revision.getTimestamp());
                    }
                    case 6: {
                        if (!(revision instanceof ILocalRevision) || !((ILocalRevision)revision).isCurrent()) break;
                        return Messages.P4HistoryPage_LatestWorkspaceRevision;
                    }
                }
                return "";
            }
            if (element instanceof RevisionGroup && columnIndex == 0) {
                return ((RevisionGroup)element).label;
            }
            return "";
        }

        public Font getFont(Object element) {
            IP4Revision data;
            if (element instanceof RevisionGroup) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
            }
            if (element instanceof IP4Revision ? P4HistoryPage.this.isHaveRevision(data = (IP4Revision)element) : element instanceof ILocalRevision && ((ILocalRevision)element).isCurrent()) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
            }
            return null;
        }
    }

    private static class RevisionGroup {
        Date date;
        String label;

        private RevisionGroup() {
        }
    }

    private class TableSelectionChangedListener
    implements ISelectionChangedListener {
        private TableSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IFileRevision entry;
            String desc;
            IStructuredSelection selection = (IStructuredSelection)P4HistoryPage.this.treeViewer.getSelection();
            if (selection.getFirstElement() instanceof IFileRevision && (desc = (entry = (IFileRevision)selection.getFirstElement()).getComment()) != null) {
                P4HistoryPage.this.textViewer.setDocument((IDocument)new Document(desc));
                return;
            }
            P4HistoryPage.this.textViewer.setDocument((IDocument)new Document(""));
        }
    }
}

