/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.editor;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.server.PerforceCharsets;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.editor.Messages;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.quickdiff.IQuickDiffReferenceProvider;

public abstract class P4QuickDiffProvider
implements IQuickDiffReferenceProvider {
    private IP4File file = null;
    private IFile localFile = null;
    protected IDocument document = null;
    protected String id = null;
    private IP4Listener listener = new IP4Listener(){

        public void resoureChanged(P4Event event) {
            if (P4QuickDiffProvider.this.file != null && P4Event.EventType.REFRESHED == event.getType()) {
                IP4File[] iP4FileArray = event.getFiles();
                int n = iP4FileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4File eventFile = iP4FileArray[n2];
                    if (P4QuickDiffProvider.this.file.equals(eventFile) && P4QuickDiffProvider.this.shouldRefresh(P4QuickDiffProvider.this.file)) {
                        P4QuickDiffProvider.this.runPrintJob();
                    }
                    ++n2;
                }
            }
        }

        public String getName() {
            return P4QuickDiffProvider.this.getClass().getSimpleName();
        }
    };
    private Job printJob = null;

    private void runPrintJob() {
        if (this.printJob == null) {
            this.printJob = new Job(Messages.P4QuickDiffProvider_RefreshingDocument){

                protected IStatus run(IProgressMonitor monitor) {
                    if (P4QuickDiffProvider.this.file != null) {
                        String path = P4QuickDiffProvider.this.file.getLocalPath();
                        if (path != null) {
                            monitor.setTaskName(NLS.bind((String)Messages.P4QuickDiffProvider_RefreshingDocumentFor, (Object)path));
                        }
                        P4QuickDiffProvider.this.refreshDocument(monitor);
                    }
                    return Status.OK_STATUS;
                }
            };
            this.printJob.setRule(new ISchedulingRule(){

                public boolean isConflicting(ISchedulingRule rule) {
                    return rule == this;
                }

                public boolean contains(ISchedulingRule rule) {
                    return rule == this;
                }
            });
        }
        if (this.printJob.getState() != 0) {
            this.printJob.cancel();
        }
        this.printJob.schedule();
    }

    public void dispose() {
        P4ConnectionManager.getManager().removeListener(this.listener);
        if (this.printJob != null) {
            this.printJob.cancel();
        }
    }

    public String getId() {
        return this.id;
    }

    protected abstract boolean shouldRefresh(IP4File var1);

    protected abstract InputStream getInputStream(IP4File var1, IProgressMonitor var2);

    private IDocument loadStream(IDocument loadedDoc, InputStream stream, IProgressMonitor monitor) {
        String charset;
        ByteArrayOutputStream byteStream;
        block19: {
            byteStream = new ByteArrayOutputStream();
            try {
                try {
                    byte[] buffer = new byte[1024];
                    int read = stream.read(buffer);
                    while (read > 0) {
                        byteStream.write(buffer, 0, read);
                        read = stream.read(buffer);
                    }
                }
                catch (IOException e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if ((charset = this.file.getConnection().getParameters().getCharsetNoNone()) != null) {
            charset = PerforceCharsets.getJavaCharsetName((String)charset);
        }
        if (charset == null) {
            charset = CharsetDefs.DEFAULT_NAME;
        }
        try {
            loadedDoc.set(byteStream.toString(charset));
        }
        catch (UnsupportedEncodingException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
        return loadedDoc;
    }

    protected void refreshDocument(IProgressMonitor monitor) {
        IP4File p4File;
        IP4Resource resource;
        if (this.document == null) {
            this.document = new Document();
        }
        if ((resource = P4ConnectionManager.getManager().getResource((IResource)this.localFile)) instanceof IP4File && (p4File = (IP4File)resource) != null) {
            this.file = p4File;
            InputStream stream = this.getInputStream(p4File, monitor);
            if (stream != null) {
                this.loadStream(this.document, stream, monitor);
            }
        }
    }

    public IDocument getReference(IProgressMonitor monitor) throws CoreException {
        if (this.document == null) {
            this.refreshDocument(monitor);
        }
        return this.document;
    }

    public boolean isEnabled() {
        return this.localFile != null;
    }

    public void setActiveEditor(ITextEditor editor) {
        P4ConnectionManager.getManager().addListener(this.listener);
        IEditorInput input = editor.getEditorInput();
        if (input != null) {
            IFile localFile = null;
            Object resource = input.getAdapter(IResource.class);
            if (resource instanceof IFile) {
                localFile = (IFile)resource;
            }
            if (localFile == null) {
                IPath path;
                if (input instanceof IFileEditorInput) {
                    localFile = ((IFileEditorInput)input).getFile();
                } else if (input instanceof IPathEditorInput && (path = ((IPathEditorInput)input).getPath()) != null) {
                    localFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                }
            }
            this.localFile = localFile;
        }
    }

    public void setId(String id) {
        this.id = id;
    }
}

