/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.editor;

import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.editor.IP4CompareNode;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;

public abstract class P4CompareNode
implements IP4CompareNode {
    protected String label;
    protected String type;
    protected boolean editable = false;

    public P4CompareNode(String label, String type, boolean editable) {
        this.label = label;
        this.type = type != null ? type : "???";
        this.editable = editable;
    }

    public P4CompareNode(String label, String type) {
        this(label, type, false);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public Object[] getChildren() {
        return new Object[0];
    }

    public Image getImage() {
        return P4UIUtils.getImageDescriptor(this.type).createImage();
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ITypedElement) {
            String otherName = ((ITypedElement)other).getName();
            return this.getName().equals(otherName);
        }
        return false;
    }

    public int hashCode() {
        String name = this.getName();
        if (name != null) {
            return name.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void commit(IProgressMonitor monitor) throws CoreException {
    }
}

