/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.editor;

import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.editor.IP4CompareNode;
import com.perforce.team.ui.editor.P4ResourceNode;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;

public class P4CompareEditorInput
extends CompareEditorInput {
    private IP4CompareNode left;
    private IP4CompareNode right;

    public P4CompareEditorInput(String title, IP4CompareNode left, IP4CompareNode right) {
        super((CompareConfiguration)new P4CompareConfiguration(left, right, left.getType()));
        this.left = left;
        this.right = right;
        this.setTitle(title);
    }

    public IP4CompareNode getLeft() {
        return this.left;
    }

    public IP4CompareNode getRight() {
        return this.right;
    }

    public void saveChanges(IProgressMonitor pm) throws CoreException {
        super.saveChanges(pm);
        if (this.left.isEditable() && this.left instanceof P4ResourceNode) {
            try {
                ((P4ResourceNode)this.left).commit(pm);
            }
            finally {
                this.setDirty(false);
            }
        }
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        return new Differencer().findDifferences(false, monitor, null, null, (Object)this.left, (Object)this.right);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof P4CompareEditorInput && this.left != null && this.right != null) {
            P4CompareEditorInput other = (P4CompareEditorInput)((Object)obj);
            return this.left.equals(other.left) && this.right.equals(other.right);
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        if (this.left != null) {
            hash += this.left.hashCode();
        }
        if (this.right != null) {
            hash += this.right.hashCode() * 31;
        }
        if (hash > 0) {
            return hash;
        }
        return super.hashCode();
    }

    private static class P4CompareConfiguration
    extends CompareConfiguration {
        public P4CompareConfiguration(IP4CompareNode leftNode, IP4CompareNode rightNode, String type) {
            this.setLeftLabel(leftNode.getLabel());
            this.setRightLabel(rightNode.getLabel());
            ImageDescriptor desc = P4UIUtils.getImageDescriptor(type);
            this.setRightImage(desc.createImage());
            this.setLeftImage(desc.createImage());
            this.setLeftEditable(leftNode.isEditable());
            this.setRightEditable(rightNode.isEditable());
        }

        public String getAncestorLabel(Object element) {
            return super.getAncestorLabel(element);
        }
    }
}

