/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.editor;

import com.perforce.team.core.p4java.P4Storage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;

public class ClientFileEditorInput
extends PlatformObject
implements IStorageEditorInput,
IPathEditorInput {
    private File clientFile;
    private IStorage storage;

    public ClientFileEditorInput(File clientFile) {
        this.clientFile = clientFile;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClientFileEditorInput) {
            return this.clientFile.equals(((ClientFileEditorInput)((Object)obj)).clientFile);
        }
        return false;
    }

    public int hashCode() {
        if (this.clientFile != null) {
            return this.clientFile.hashCode();
        }
        return super.hashCode();
    }

    public IStorage getStorage() throws CoreException {
        if (this.storage == null) {
            final IPath fullPath = this.getPath();
            this.storage = new P4Storage(){

                public IPath getFullPath() {
                    return fullPath;
                }

                public String getName() {
                    return ClientFileEditorInput.this.clientFile.getName();
                }

                public InputStream getContents() throws CoreException {
                    FileInputStream stream = null;
                    try {
                        stream = new FileInputStream(ClientFileEditorInput.this.clientFile);
                    }
                    catch (FileNotFoundException e) {
                        throw new CoreException((IStatus)new Status(4, "com.perforce.team.ui", 0, "Error creating file input stream", (Throwable)e));
                    }
                    return stream;
                }
            };
        }
        return this.storage;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.clientFile.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.clientFile.getAbsolutePath();
    }

    public IPath getPath() {
        return Path.fromOSString((String)this.clientFile.getAbsolutePath());
    }
}

