/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import com.perforce.p4java.server.PerforceCharsets;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.connection.BasicConnectionWidget;
import com.perforce.team.ui.dialogs.Messages;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SetConnectionDialog
extends P4StatusDialog {
    private BasicConnectionWidget connectionControl;
    private ConnectionParameters params = null;

    public SetConnectionDialog(Shell parent) {
        super(parent);
        this.setTitle(Messages.SetConnectionDialog_ServerConnection);
        this.setModalResizeStyle();
        this.setStatusLineAboveButtons(true);
        this.connectionControl = this.createWidget();
        this.connectionControl.setErrorDisplay(this);
    }

    protected BasicConnectionWidget createWidget() {
        return new BasicConnectionWidget(false);
    }

    protected BasicConnectionWidget getWidget() {
        return this.connectionControl;
    }

    public IDialogSettings getDialogSettings() {
        return PerforceUIPlugin.getPlugin().getDialogSettings();
    }

    public ConnectionParameters getConnectionParams() {
        return this.params;
    }

    public void setConnectionParams(ConnectionParameters params) {
        this.params = params;
    }

    protected void okPressed() {
        this.params = this.connectionControl.getConnectionParameters();
        if (this.params != null) {
            if (this.params.getCharsetNoNull().equals("") || PerforceCharsets.isSupported((String)this.params.getCharsetNoNull())) {
                super.okPressed();
            } else {
                MessageDialog.openWarning((Shell)this.getParentShell(), (String)Messages.SetConnectionDialog_InvalidCharsetTitle, (String)Messages.SetConnectionDialog_InvalidCharsetMessage);
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = this.connectionControl.createControl(dialogArea, true);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.params == null) {
            this.getButton(0).setEnabled(false);
        } else {
            this.connectionControl.setConnectionParameters(this.params);
        }
    }
}

