/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.PerforceTeamProvider;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.connection.BasicConnectionWidget;
import com.perforce.team.ui.dialogs.Messages;
import com.perforce.team.ui.views.DepotView;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class ProjectPropertiesDialog
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Composite displayArea;
    private BasicConnectionWidget connectionControl = new BasicConnectionWidget(true);
    private Link editConnectionNote;

    public ProjectPropertiesDialog() {
        this.noDefaultAndApplyButton();
    }

    public IDialogSettings getDialogSettings() {
        return PerforceUIPlugin.getPlugin().getDialogSettings();
    }

    protected Control createContents(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, false);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = this.connectionControl.createControl(this.displayArea, true);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        try {
            PerforceTeamProvider provider = this.getProvider();
            if (provider != null) {
                final ConnectionParameters parameters = provider.getProjectProperties(true);
                this.connectionControl.setConnectionParameters(parameters);
                this.editConnectionNote = new Link(this.displayArea, 64);
                this.editConnectionNote.setLayoutData((Object)new GridData(4, 4, true, false));
                this.editConnectionNote.setText(Messages.ProjectPropertiesDialog_EditConnectionNote);
                this.editConnectionNote.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        DepotView view = DepotView.showView();
                        if (view != null) {
                            IP4Connection connection = P4Workspace.getWorkspace().getConnection(parameters);
                            view.getViewer().setSelection((ISelection)new StructuredSelection((Object)connection));
                        }
                    }
                });
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return this.displayArea;
    }

    private PerforceTeamProvider getProvider() {
        IProject project = (IProject)this.getElement();
        return PerforceTeamProvider.getPerforceProvider((IResource)project);
    }
}

