/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.ui.dialogs.BufferedResourceNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class PerforceEditorInput
extends CompareEditorInput {
    private String leftFile;
    private String rightFile;
    private String ancestorFile;
    private String type;
    private boolean merge;
    private Object leftNode;

    public PerforceEditorInput(String title, boolean merge, String fileType, String leftFile, String leftLabel, String rightFile, String rightLabel, String ancestorFile, String ancestorLabel) {
        super((CompareConfiguration)new PerforceCompareConfiguration(merge, leftFile, leftLabel, rightLabel, ancestorLabel));
        this.leftFile = leftFile;
        this.rightFile = rightFile;
        this.ancestorFile = ancestorFile;
        this.type = fileType;
        this.merge = merge;
        this.setTitle(title);
    }

    public boolean allowMerge() {
        return this.merge;
    }

    public void saveChanges(IProgressMonitor pm) throws CoreException {
        super.saveChanges(pm);
        if (this.leftNode instanceof BufferedResourceNode) {
            ((BufferedResourceNode)((Object)this.leftNode)).commit(pm);
        }
    }

    protected Object prepareInput(IProgressMonitor monitor) {
        IFile leftResource = PerforceProviderPlugin.getWorkspaceFile((String)this.leftFile);
        IFile rightResource = PerforceProviderPlugin.getWorkspaceFile((String)this.rightFile);
        this.leftNode = leftResource == null ? new DiffFile(new File(this.leftFile), this.type) : new BufferedResourceNode((IResource)leftResource);
        Object rightNode = rightResource == null ? new DiffFile(new File(this.rightFile), this.type) : new BufferedResourceNode((IResource)rightResource);
        DiffFile ancestorNode = null;
        boolean threeway = false;
        if (this.ancestorFile != null) {
            ancestorNode = new DiffFile(new File(this.ancestorFile), this.type);
            threeway = true;
        }
        return new Differencer().findDifferences(threeway, monitor, null, (Object)ancestorNode, this.leftNode, rightNode);
    }

    public String getLeftFile() {
        return this.leftFile;
    }

    public String getRightFile() {
        return this.rightFile;
    }

    public static class DiffFile
    implements IStructureComparator,
    IStreamContentAccessor,
    ITypedElement {
        File depot;
        String type;

        public DiffFile(File depot, String type) {
            this.depot = depot;
            this.type = type;
        }

        public Object[] getChildren() {
            return new Object[0];
        }

        public String getName() {
            return this.depot.getName();
        }

        public Image getImage() {
            return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor("xxx." + this.type).createImage();
        }

        public String getType() {
            return this.type;
        }

        public InputStream getContents() {
            try {
                return new FileInputStream(this.depot);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }

        public boolean equals(Object other) {
            if (other instanceof ITypedElement) {
                String otherName = ((ITypedElement)other).getName();
                return this.getName().equals(otherName);
            }
            return false;
        }

        public int hashCode() {
            int hash = 0;
            if (this.depot != null) {
                hash += this.depot.hashCode();
            }
            if (this.type != null) {
                hash += this.type.hashCode();
            }
            if (hash > 0) {
                return hash;
            }
            return super.hashCode();
        }
    }

    private static class PerforceCompareConfiguration
    extends CompareConfiguration {
        public PerforceCompareConfiguration(boolean merge, String path, String leftLabel, String rightLabel, String ancestorLabel) {
            this.setLeftLabel(leftLabel);
            this.setRightLabel(rightLabel);
            this.setAncestorLabel(ancestorLabel);
            ImageDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(path);
            this.setRightImage(desc.createImage());
            this.setLeftImage(desc.createImage());
            this.setAncestorImage(desc.createImage());
            if (merge) {
                this.setLeftEditable(true);
                this.setRightEditable(false);
                this.setProperty("org.eclipse.compare.AncestorVisible", true);
                this.setProperty("org.eclipse.compare.InitiallyShowAncestorPane", true);
            } else {
                this.setLeftEditable(false);
                this.setRightEditable(false);
            }
        }

        public String getAncestorLabel(Object element) {
            return super.getAncestorLabel(element);
        }
    }
}

