/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import com.perforce.p4java.core.IJobSpec;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.dialogs.DialogUtils;
import com.perforce.team.ui.dialogs.FixedWidthScrolledComposite;
import com.perforce.team.ui.dialogs.IJobDoubleClickListener;
import com.perforce.team.ui.dialogs.Messages;
import com.perforce.team.ui.viewer.FilterViewer;
import com.perforce.team.ui.views.JobSorter;
import com.perforce.team.ui.views.PerforceProjectView;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class JobsDialog
extends FilterViewer
implements ISelectionChangedListener,
IPropertyChangeListener {
    public static final String FILE_FOLDER_HISTORY = "com.perforce.team.ui.jobs.FILE_FOLDER_HISTORY";
    public static final String KEYWORD_HISTORY = "com.perforce.team.ui.jobs.KEYWORD_HISTORY";
    private JobSorter sorter;
    private TableViewer jobsList;
    private IP4Connection connection;
    private String[] displayColumns;
    private Composite viewComposite;
    private Link showMore;
    private Label folderFileLabel;
    private Combo folderFileCombo;
    private ToolBar folderFileBar;
    private ToolItem folderFileClearItem;
    private Label keywordLabel;
    private Combo keywordCombo;
    private ToolBar keywordBar;
    private ToolItem keywordClearItem;
    private IJobDoubleClickListener doubleListener = null;
    private boolean forceKeywordFocus = false;
    private SashForm sash;
    private Label longestLabel;
    private Text[] detailFields;
    private ScrolledComposite detailPanel;
    private int retrieveCount = 0;
    private boolean isLoading = false;
    private boolean autoSelectFirstEntry = false;
    private IP4Job selectedJob = null;
    private IP4Job[] jobs = null;
    private Object loading = new Object();
    private Image loadingImage;
    private Image clearImage;
    public static final String COLUMNS_PREFIX = "P4ECLIPSE-Columns-";
    public static final String COLUMN_SIZES = "com.perforce.team.ui.jobcolumns";

    public void addJob(IP4Job job) {
        if (job != null) {
            if (this.jobs != null) {
                IP4Job[] newJobs = new IP4Job[this.jobs.length + 1];
                newJobs[0] = job;
                System.arraycopy(this.jobs, 0, newJobs, 1, this.jobs.length);
                this.jobs = newJobs;
            } else {
                this.jobs = new IP4Job[]{job};
            }
            this.jobsList.insert((Object)job, 0);
            this.jobsList.setSelection((ISelection)new StructuredSelection((Object)job), true);
        }
    }

    public void showMore() {
        if (this.retrieveCount != -1) {
            this.retrieveCount += this.getMaxJobs();
        }
        this.loadJobs();
    }

    private void createMoreLink(Composite parent) {
        this.showMore = new Link(parent, 8);
        this.showMore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobsDialog.this.showMore();
            }
        });
        this.showMore.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
        this.refreshRetrieveCount();
        this.updateMoreButton(false);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("pref_retrieve_num_jobs".equals(property)) {
            this.retrieveCount = this.getMaxJobs();
            this.updateMoreButton();
            this.loadJobs();
        }
    }

    public void createJobTable(IP4Connection connection) {
        this.connection = connection;
        Table table = this.jobsList.getTable();
        this.saveColumnSizes();
        table.setRedraw(false);
        try {
            TableColumn[] tableColumnArray = table.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                column.dispose();
                ++n2;
            }
            TableLayout layout = new TableLayout();
            table.setLayout((Layout)layout);
            this.initDisplayColumns();
            Map<String, Integer> columnSizes = this.loadColumnSizes();
            String[] columns = this.displayColumns;
            SelectionAdapter headerListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableColumn column = (TableColumn)e.widget;
                    JobsDialog.this.sorter.setSortColumn(column.getText());
                    JobsDialog.this.jobsList.refresh();
                }
            };
            int i = 0;
            while (i < columns.length) {
                int size;
                TableColumn col = new TableColumn(table, 0);
                col.setResizable(true);
                col.setText(columns[i]);
                int width = 100;
                if (columnSizes.containsKey(columns[i]) && (size = columnSizes.get(columns[i]).intValue()) > 0) {
                    width = size;
                }
                layout.addColumnData((ColumnLayoutData)new ColumnPixelData(width, true));
                col.addSelectionListener((SelectionListener)headerListener);
                ++i;
            }
            if (table.getColumnCount() > 0) {
                TableColumn first = table.getColumn(0);
                table.setSortColumn(first);
                table.setSortDirection(1024);
            }
            this.sorter = new JobSorter(this.jobsList.getTable(), columns.length > 0 ? columns[0] : "");
            this.jobsList.setSorter((ViewerSorter)this.sorter);
            if (this.detailPanel != null && this.detailPanel.getContent() != null) {
                this.detailPanel.getContent().dispose();
                this.createDetails(this.detailPanel, table.getBackground());
            }
        }
        finally {
            table.setRedraw(true);
        }
        this.loadJobs();
    }

    public Composite createControl(Composite parent, IP4Connection connection, boolean multiSelect, boolean displayDetails) {
        Composite composite = this.createControl(parent, multiSelect, displayDetails);
        this.createJobTable(connection);
        return composite;
    }

    public Composite createControl(Composite parent, boolean multiSelect, boolean displayDetails) {
        PerforceUIPlugin.getPlugin().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.sash = DialogUtils.createSash(parent);
        this.viewComposite = new Composite((Composite)this.sash, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        this.viewComposite.setLayout((Layout)gl);
        this.createFilterArea(this.viewComposite);
        this.createMoreLink(this.viewComposite);
        Table table = this.createTable(this.viewComposite, multiSelect);
        this.detailPanel = this.createDetailPanel((Composite)this.sash, table.getBackground());
        this.updateSash(displayDetails);
        return this.sash;
    }

    public void setPath(String folderFilePath) {
        if (this.okToUse()) {
            if (folderFilePath == null) {
                folderFilePath = "";
            }
            this.folderFileCombo.setText(folderFilePath);
            this.loadJobs();
        }
    }

    private void updateMoreButton(boolean layout) {
        if (this.showMore != null && !this.showMore.isDisposed()) {
            int max = this.getMaxJobs();
            if (max == -1) {
                this.showMore.setText(Messages.JobsDialog_ShowMore);
                this.showMore.setEnabled(false);
            } else {
                this.showMore.setText(MessageFormat.format(Messages.JobsDialog_ShowNumMore, max));
                this.showMore.setEnabled(true);
            }
            if (layout) {
                this.showMore.getParent().layout(new Control[]{this.showMore});
            }
        }
    }

    private void updateMoreButton() {
        this.updateMoreButton(true);
    }

    private void createFilterArea(Composite parent) {
        String[] folders;
        String[] keywords;
        this.filterComposite = new Composite(parent, 0);
        GridLayout fcLayout = new GridLayout(3, false);
        this.filterComposite.setLayout((Layout)fcLayout);
        this.filterComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        final SelectionListener comboAdapter = P4UIUtils.createComboSelectionListener(new Runnable(){

            @Override
            public void run() {
                JobsDialog.this.loadJobs();
            }
        });
        this.keywordLabel = new Label(this.filterComposite, 16384);
        this.keywordLabel.setText(Messages.JobsDialog_Keywords);
        this.keywordLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.keywordCombo = new Combo(this.filterComposite, 4);
        String[] stringArray = keywords = PerforceProjectView.getItems(KEYWORD_HISTORY);
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            this.keywordCombo.add(keyword);
            ++n2;
        }
        this.keywordCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.keywordCombo.addSelectionListener(comboAdapter);
        this.clearImage = PerforceUIPlugin.getPlugin().getImageDescriptor("normal/clear.png").createImage();
        this.keywordBar = new ToolBar(this.filterComposite, 0x800000);
        this.keywordClearItem = new ToolItem(this.keywordBar, 8);
        this.keywordClearItem.setToolTipText(Messages.JobsDialog_ClearKeywordFilter);
        this.keywordClearItem.setImage(this.clearImage);
        this.keywordClearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobsDialog.this.keywordCombo.setText("");
                comboAdapter.widgetSelected(e);
            }
        });
        this.folderFileLabel = new Label(this.filterComposite, 16384);
        this.folderFileLabel.setText(Messages.JobsDialog_FolderFile);
        this.folderFileCombo = new Combo(this.filterComposite, 4);
        String[] stringArray2 = folders = PerforceProjectView.getItems(FILE_FOLDER_HISTORY);
        int n3 = folders.length;
        n = 0;
        while (n < n3) {
            String folder = stringArray2[n];
            this.folderFileCombo.add(folder);
            ++n;
        }
        this.folderFileCombo.addSelectionListener(comboAdapter);
        this.folderFileCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.folderFileBar = new ToolBar(this.filterComposite, 0x800000);
        this.folderFileClearItem = new ToolItem(this.folderFileBar, 8);
        this.folderFileClearItem.setToolTipText(Messages.JobsDialog_ClearFolderFile);
        this.folderFileClearItem.setImage(this.clearImage);
        this.folderFileClearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobsDialog.this.folderFileCombo.setText("");
                comboAdapter.widgetSelected(e);
            }
        });
    }

    public void setKeywordFocus() {
        this.forceKeywordFocus = true;
    }

    private IP4Job getSelectedJob(ISelection selection) {
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        if (ss.size() != 1) {
            return null;
        }
        if (ss.getFirstElement() instanceof IP4Job) {
            return (IP4Job)ss.getFirstElement();
        }
        return null;
    }

    public String[] getDisplayColumns() {
        return this.displayColumns;
    }

    public String[] getFieldNames() {
        String[] fields = new String[]{};
        if (this.connection != null) {
            fields = this.connection.getJobFields();
        }
        return fields;
    }

    public IP4Job[] getSelectedJobs() {
        ISelection selected = this.jobsList.getSelection();
        ArrayList<IP4Job> selectedJobs = new ArrayList<IP4Job>();
        if (selected instanceof IStructuredSelection) {
            Object[] selectedItem = ((IStructuredSelection)selected).toArray();
            int i = 0;
            while (i < selectedItem.length) {
                if (selectedItem[i] instanceof IP4Job) {
                    selectedJobs.add((IP4Job)selectedItem[i]);
                }
                ++i;
            }
        }
        return selectedJobs.toArray(new IP4Job[selectedJobs.size()]);
    }

    public Table getTableControl() {
        if (this.jobsList != null) {
            return this.jobsList.getTable();
        }
        return null;
    }

    public TableViewer getViewer() {
        return this.jobsList;
    }

    private void initDisplayColumns() {
        String port = this.connection.getParameters().getPortNoNull();
        String columnsLine = this.getPreferenceStore().getString(COLUMNS_PREFIX + port);
        if (columnsLine == null || columnsLine.length() == 0) {
            ArrayList<String> defaultCols = new ArrayList<String>();
            String[] fields = this.connection.getJobFields();
            int i = 0;
            while (i < fields.length) {
                defaultCols.add(fields[i]);
                if (i == 4) break;
                ++i;
            }
            this.displayColumns = defaultCols.toArray(new String[defaultCols.size()]);
        } else {
            this.displayColumns = this.decodeLines(columnsLine);
        }
    }

    private Map<String, Integer> loadColumnSizes() {
        HashMap<String, Integer> columnSizes = new HashMap<String, Integer>();
        String columns = PerforceUIPlugin.getPlugin().getPreferenceStore().getString(COLUMN_SIZES);
        if (columns.length() > 0) {
            String[] pairs;
            String[] stringArray = pairs = columns.split("###");
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                String pair = stringArray[n2];
                String[] nameValue = pair.split("=");
                if (nameValue.length == 2) {
                    try {
                        Integer value = Integer.parseInt(nameValue[1]);
                        columnSizes.put(nameValue[0], value);
                    }
                    catch (NumberFormatException nfe) {
                        PerforceProviderPlugin.logError((Throwable)nfe);
                    }
                }
                ++n2;
            }
        }
        return columnSizes;
    }

    public void saveColumnSizes() {
        TableColumn[] columns = this.jobsList.getTable().getColumns();
        if (columns.length > 0) {
            StringBuilder buffer = new StringBuilder();
            TableColumn[] tableColumnArray = columns;
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                buffer.append(String.valueOf(column.getText()) + "=" + column.getWidth() + "###");
                ++n2;
            }
            PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(COLUMN_SIZES, buffer.toString());
        }
    }

    private Table createTable(Composite parent, boolean multiSelect) {
        int flags = 68352;
        if (multiSelect) {
            flags |= 2;
        }
        Table table = new Table(parent, flags);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                JobsDialog.this.saveColumnSizes();
                PerforceUIPlugin.getPlugin().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)JobsDialog.this);
            }
        });
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        table.setLayoutData((Object)gd);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        this.jobsList = new TableViewer(table);
        this.jobsList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement == JobsDialog.this.loading) {
                    return new Object[]{JobsDialog.this.loading};
                }
                if (JobsDialog.this.jobs != null) {
                    return JobsDialog.this.jobs;
                }
                return new Object[0];
            }
        });
        this.jobsList.setLabelProvider((IBaseLabelProvider)new JobLabelProvider());
        this.jobsList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (JobsDialog.this.doubleListener != null) {
                    JobsDialog.this.doubleListener.doubleClick();
                }
            }
        });
        this.jobsList.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TableItem item = JobsDialog.this.jobsList.getTable().getItem(new Point(e.x, e.y));
                if (item != null) {
                    IP4Job job = (IP4Job)item.getData();
                    JobsDialog.this.updateDetailsPanel(job);
                }
            }
        });
        this.jobsList.addSelectionChangedListener((ISelectionChangedListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)table, "com.perforce.team.ui.job_view_job_list");
        return table;
    }

    public void refresh() {
        if (this.connection != null) {
            this.refreshRetrieveCount();
            this.loadJobs();
        }
    }

    private IPreferenceStore getPreferenceStore() {
        return PerforceUIPlugin.getPlugin().getPreferenceStore();
    }

    private int getMaxJobs() {
        return this.getPreferenceStore().getInt("pref_retrieve_num_jobs");
    }

    private String encodeLines(String[] lines) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < lines.length) {
            buffer.append(lines[i]);
            buffer.append('\n');
            ++i;
        }
        return buffer.toString();
    }

    private String[] decodeLines(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, "\n");
        ArrayList<String> lines = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            lines.add(tokenizer.nextToken());
        }
        return lines.toArray(new String[lines.size()]);
    }

    public void saveDisplayColumns(String[] columns) {
        String port = this.connection.getParameters().getPortNoNull();
        this.getPreferenceStore().putValue(COLUMNS_PREFIX + port, this.encodeLines(columns));
    }

    public void refreshDetailsPanel(IP4Job job) {
        if (job == this.selectedJob) {
            this.updateDetailsPanel(job);
        }
    }

    private void updateDetailsPanel(IP4Job job) {
        int i = 0;
        while (i < this.detailFields.length) {
            Object data = this.detailFields[i].getData();
            if (data != null) {
                Object value = job.getField(data.toString());
                if (value != null) {
                    this.detailFields[i].setText(value.toString());
                } else {
                    this.detailFields[i].setText("");
                }
            } else {
                this.detailFields[i].setText("");
            }
            ++i;
        }
        this.updateScrollPanel();
    }

    private void clearDetailsPanel() {
        int i = 0;
        while (i < this.detailFields.length) {
            this.detailFields[i].setText("");
            ++i;
        }
        this.updateScrollPanel();
    }

    private void updateScrollPanel() {
        if (this.detailFields.length > 0) {
            Composite composite = this.detailFields[0].getParent();
            this.detailPanel.setMinSize(composite.computeSize(-1, -1, true));
        }
    }

    public void setDoubleListener(IJobDoubleClickListener listener) {
        this.doubleListener = listener;
    }

    private Composite createDetails(ScrolledComposite parent, Color background) {
        Composite composite = new Composite((Composite)parent, 0);
        parent.setContent((Control)composite);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        composite.setLayout((Layout)gl);
        if (this.connection != null) {
            String name = null;
            String status = null;
            String desc = null;
            String date = null;
            String user = null;
            ArrayList<String> fields = new ArrayList<String>();
            String[] flds = this.connection.getJobFields();
            fields.addAll(Arrays.asList(flds));
            IJobSpec spec = this.connection.getJobSpec();
            if (spec != null) {
                for (IJobSpec.IJobSpecField field : spec.getFields()) {
                    switch (field.getCode()) {
                        case 101: {
                            name = field.getName();
                            fields.remove(name);
                            break;
                        }
                        case 102: {
                            status = field.getName();
                            fields.remove(status);
                            break;
                        }
                        case 103: {
                            user = field.getName();
                            fields.remove(user);
                            break;
                        }
                        case 104: {
                            date = field.getName();
                            fields.remove(date);
                            break;
                        }
                        case 105: {
                            desc = field.getName();
                            fields.remove(desc);
                            break;
                        }
                    }
                    if (name != null && status != null && desc != null && date != null && user != null) break;
                }
            }
            this.detailFields = new Text[flds.length];
            int index = 0;
            if (name != null) {
                this.detailFields[index] = this.createDetailField(composite, name, false, false, background, false);
                ++index;
            }
            if (status != null) {
                this.detailFields[index] = this.createDetailField(composite, status, false, false, background, false);
                ++index;
            }
            if (user != null) {
                this.detailFields[index] = this.createDetailField(composite, user, false, false, background, false);
                ++index;
            }
            if (desc != null) {
                this.detailFields[index] = this.createDetailField(composite, desc, true, true, background, true);
                ++index;
            }
            if (date != null) {
                this.detailFields[index] = this.createDetailField(composite, date, false, false, background, false);
                ++index;
            }
            for (String field : fields) {
                this.detailFields[index] = this.createDetailField(composite, field, true, true, background, false);
                ++index;
            }
        } else {
            this.detailFields = new Text[0];
        }
        parent.setMinSize(composite.computeSize(-1, -1));
        return composite;
    }

    private ScrolledComposite createDetailPanel(Composite parent, Color background) {
        FixedWidthScrolledComposite panel = new FixedWidthScrolledComposite(parent, 2560);
        panel.setLayout((Layout)new FillLayout());
        this.createDetails(panel, background);
        panel.setExpandHorizontal(true);
        panel.setExpandVertical(true);
        return panel;
    }

    private Text createDetailField(Composite parent, String name, boolean multi, boolean wrap, Color background, boolean grabVertical) {
        Label label = new Label(parent, 0);
        label.setText(String.valueOf(name) + ":");
        GridData lData = new GridData();
        lData.verticalAlignment = 1;
        label.setLayoutData((Object)lData);
        if (this.longestLabel == null || this.longestLabel.isDisposed() || this.longestLabel.getText().length() < name.length()) {
            this.longestLabel = label;
        }
        int flags = 8;
        if (multi) {
            flags |= 2;
            if (wrap) {
                flags |= 0x40;
            }
        } else {
            flags |= 4;
        }
        Text text = new Text(parent, flags);
        text.setData((Object)name);
        text.setBackground(background);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        if (grabVertical) {
            gd.verticalAlignment = 4;
            gd.grabExcessVerticalSpace = grabVertical;
        }
        text.setLayoutData((Object)gd);
        return text;
    }

    public void updateSash(boolean displayDetails) {
        if (displayDetails) {
            this.sash.setMaximizedControl(null);
            IP4Job job = this.getSelectedJob(this.jobsList.getSelection());
            if (job == null) {
                this.clearDetailsPanel();
            } else {
                this.updateDetailsPanel(job);
            }
        } else {
            this.sash.setMaximizedControl((Control)this.viewComposite);
        }
    }

    private void enableFilters(boolean enabled) {
        this.folderFileCombo.setEnabled(enabled);
        this.keywordCombo.setEnabled(enabled);
        if (enabled && this.forceKeywordFocus) {
            this.forceKeywordFocus = false;
            this.keywordCombo.setFocus();
        }
    }

    public void clearFilters() {
        this.folderFileCombo.setText("");
        this.keywordCombo.setText("");
    }

    private boolean checkFilter(String[] paths, String keyword) {
        if (keyword == null) {
            keyword = "";
        }
        if (paths == null) {
            paths = new String[]{""};
        }
        if (paths.length == 1 && paths[0] != null) {
            return paths[0].equals(this.folderFileCombo.getText().trim()) && keyword.equals(this.keywordCombo.getText().trim());
        }
        return false;
    }

    private void updateHistory(String path, String keyword) {
        String item;
        String[] stringArray;
        if (path != null && path.length() > 0) {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(path);
            stringArray = this.folderFileCombo.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                item = stringArray[n2];
                if (!paths.contains(item)) {
                    paths.add(item);
                }
                if (paths.size() == 10) break;
                ++n2;
            }
            this.folderFileCombo.removeAll();
            StringBuffer folders = new StringBuffer();
            for (String item2 : paths) {
                this.folderFileCombo.add(item2, this.folderFileCombo.getItemCount());
                folders.append(item2).append("###");
            }
            this.folderFileCombo.select(0);
            PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(FILE_FOLDER_HISTORY, folders.toString());
        }
        if (keyword != null && keyword.length() > 0) {
            ArrayList<String> keywords = new ArrayList<String>();
            keywords.add(keyword);
            stringArray = this.keywordCombo.getItems();
            int n = stringArray.length;
            int item2 = 0;
            while (item2 < n) {
                item = stringArray[item2];
                if (!keywords.contains(item)) {
                    keywords.add(item);
                }
                if (keywords.size() == 10) break;
                ++item2;
            }
            this.keywordCombo.removeAll();
            StringBuffer usersBuffer = new StringBuffer();
            for (String item3 : keywords) {
                this.keywordCombo.add(item3, this.keywordCombo.getItemCount());
                usersBuffer.append(item3).append("###");
            }
            PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(KEYWORD_HISTORY, usersBuffer.toString());
            this.keywordCombo.select(0);
        }
    }

    public boolean okToUse() {
        return this.jobsList != null && this.jobsList.getTable() != null && !this.jobsList.getTable().isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJobs() {
        final IP4Connection currConnection = this.connection;
        this.isLoading = true;
        if (this.viewComposite == null || this.viewComposite.isDisposed()) {
            return;
        }
        final Object newLoading = new Object();
        JobsDialog jobsDialog = this;
        synchronized (jobsDialog) {
            this.loading = newLoading;
            this.jobsList.setInput(this.loading);
        }
        String[] paths = null;
        String path = this.folderFileCombo.getText().trim();
        paths = path.length() == 0 ? null : new String[]{path};
        String keyword = this.keywordCombo.getText().trim();
        if (keyword.length() == 0) {
            keyword = null;
        }
        final String[] finalPaths = paths;
        final String finalKeyword = keyword;
        this.enableFilters(false);
        this.updateHistory(path, keyword);
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return Messages.JobsDialog_LoadingJobs;
            }

            public void run(IProgressMonitor monitor) {
                IP4Connection jobConnection = JobsDialog.this.connection;
                if (jobConnection == null || jobConnection != currConnection) {
                    JobsDialog.this.isLoading = false;
                    return;
                }
                final IP4Job[] newJobs = jobConnection.getJobs(finalPaths, JobsDialog.this.retrieveCount, finalKeyword);
                if (newLoading == JobsDialog.this.loading) {
                    UIJob job = new UIJob(Messages.JobsDialog_UpdatingJobsView){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (currConnection != JobsDialog.this.connection) {
                                return Status.CANCEL_STATUS;
                            }
                            if (JobsDialog.this.okToUse() && newLoading == JobsDialog.this.loading && JobsDialog.this.checkFilter(finalPaths, finalKeyword)) {
                                JobsDialog.this.jobs = newJobs;
                                JobsDialog.this.jobsList.setInput((Object)JobsDialog.this.jobs);
                                if (JobsDialog.this.autoSelectFirstEntry && newJobs.length > 0) {
                                    JobsDialog.this.jobsList.setSelection((ISelection)new StructuredSelection((Object)newJobs[0]));
                                }
                                JobsDialog.this.enableFilters(true);
                                JobsDialog.this.isLoading = false;
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            }
        });
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.jobsList == null || this.jobsList.getTable().isDisposed()) {
            return;
        }
        this.selectedJob = this.getSelectedJob(event.getSelection());
        if (this.selectedJob != null) {
            this.updateDetailsPanel(this.selectedJob);
        }
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public void refreshRetrieveCount() {
        this.retrieveCount = this.getMaxJobs();
    }

    public void setAutoSelectFirstEntry(boolean autoSelectFirstEntry) {
        this.autoSelectFirstEntry = autoSelectFirstEntry;
    }

    private class JobLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Image jobImage = null;

        private JobLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element == JobsDialog.this.loading) {
                    if (JobsDialog.this.loadingImage == null) {
                        JobsDialog.this.loadingImage = this.getLoadingImage();
                    }
                    return JobsDialog.this.loadingImage;
                }
                if (this.jobImage == null) {
                    this.jobImage = this.getJobImage();
                }
                return this.jobImage;
            }
            return null;
        }

        public void dispose() {
            if (this.jobImage != null && !this.jobImage.isDisposed()) {
                this.jobImage.dispose();
                this.jobImage = null;
            }
            if (JobsDialog.this.loadingImage != null && !JobsDialog.this.loadingImage.isDisposed()) {
                JobsDialog.this.loadingImage.dispose();
                JobsDialog.this.loadingImage = null;
            }
            if (JobsDialog.this.clearImage != null && !JobsDialog.this.clearImage.isDisposed()) {
                JobsDialog.this.clearImage.dispose();
                JobsDialog.this.clearImage = null;
            }
        }

        private Image getLoadingImage() {
            PerforceUIPlugin plugin = PerforceUIPlugin.getPlugin();
            return plugin.getImageDescriptor("perforce/hourglass.png").createImage();
        }

        private Image getJobImage() {
            PerforceUIPlugin plugin = PerforceUIPlugin.getPlugin();
            return plugin.getImageDescriptor("perforce/job.png").createImage();
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element == JobsDialog.this.loading && columnIndex == 0) {
                return Messages.JobsDialog_Loading;
            }
            if (element instanceof IP4Job) {
                String name;
                Object value;
                IP4Job job = (IP4Job)element;
                String[] columns = JobsDialog.this.displayColumns;
                if (columnIndex < columns.length && (value = job.getField(name = columns[columnIndex])) != null) {
                    return P4CoreUtils.removeWhitespace((String)value.toString());
                }
            }
            return "";
        }
    }
}

