/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.decorator;

import java.util.Arrays;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayIcon
extends CompositeImageDescriptor {
    private Image base;
    private ImageDescriptor[] overlays;
    private Point size;
    private int[] locations;
    private int baseX = 0;
    private int baseY = 0;

    public OverlayIcon(Image base, ImageDescriptor[] overlays, int[] locations) {
        this(base, overlays, locations, base.getBounds().width, base.getBounds().height);
    }

    public OverlayIcon(Image base, ImageDescriptor[] overlays, int[] locations, int width, int height) {
        this.base = base;
        this.overlays = overlays;
        this.locations = locations;
        this.size = new Point(width, height);
    }

    public OverlayIcon(Image base, ImageDescriptor[] overlays, int[] locations, int width, int height, int baseX, int baseY) {
        this(base, overlays, locations, width, height);
        this.baseX = baseX;
        this.baseY = baseY;
    }

    protected void drawOverlays(ImageDescriptor[] overlays, int[] locations) {
        Point size = this.getSize();
        int i = 0;
        while (i < overlays.length) {
            ImageDescriptor overlay = overlays[i];
            ImageData overlayData = overlay.getImageData();
            switch (locations[i]) {
                case 1: {
                    this.drawImage(overlayData, 0, 0);
                    break;
                }
                case 2: {
                    this.drawImage(overlayData, size.x - overlayData.width, 0);
                    break;
                }
                case 4: {
                    this.drawImage(overlayData, 0, size.y - overlayData.height);
                    break;
                }
                case 8: {
                    this.drawImage(overlayData, size.x - overlayData.width, size.y - overlayData.height);
                    break;
                }
            }
            ++i;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof OverlayIcon)) {
            return false;
        }
        OverlayIcon other = (OverlayIcon)((Object)o);
        return this.base.equals((Object)other.base) && Arrays.equals(this.overlays, other.overlays);
    }

    public int hashCode() {
        int code = this.base.hashCode();
        int i = 0;
        while (i < this.overlays.length) {
            code ^= this.overlays[i].hashCode();
            ++i;
        }
        return code;
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.base.getImageData(), this.baseX, this.baseY);
        this.drawOverlays(this.overlays, this.locations);
    }

    protected Point getSize() {
        return this.size;
    }
}

