/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.connection;

import com.perforce.p4java.exception.P4JavaException;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.ErrorHandler;
import com.perforce.team.core.p4java.IErrorHandler;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Folder;
import com.perforce.team.core.p4java.P4Connection;
import com.perforce.team.core.p4java.builder.ClientBuilder;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.connection.ClientWizardPage;
import com.perforce.team.ui.connection.IConnectionWizard;
import com.perforce.team.ui.connection.Messages;
import com.perforce.team.ui.connection.ServerWizardPage;
import com.perforce.team.ui.p4java.actions.ImportProjectAction;
import com.perforce.team.ui.project.ImportProjectsWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public abstract class AbstractConnectionWizard
extends Wizard
implements IConnectionWizard,
INewWizard {
    protected ServerWizardPage serverPage;
    protected ClientWizardPage clientPage;
    protected ImportProjectsWizardPage importPage;
    protected String initialPort;
    protected String initialUser;
    protected String initialClient;
    protected String initialCharset;
    protected String authTicket;
    private IP4Connection connection;
    private WizardDialog parentDialog;

    public AbstractConnectionWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public AbstractConnectionWizard(IP4Connection initial) {
        this();
        if (initial != null) {
            this.initialPort = initial.getParameters().getPort();
            this.initialUser = initial.getParameters().getUser();
            this.initialCharset = initial.getParameters().getCharset();
        }
    }

    public AbstractConnectionWizard(String initialPort, String initialUser, String initialClient, String initialCharset) {
        this();
        this.initialPort = initialPort;
        this.initialUser = initialUser;
        this.initialClient = initialClient;
        this.initialCharset = initialCharset;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.setWindowTitle(Messages.ConnectionWizard_PerforceConnectionWizard);
        if (this.initialPort != null && !this.initialPort.isEmpty()) {
            this.serverPage.setPort(this.initialPort);
        }
        if (this.initialUser != null && !this.initialUser.isEmpty()) {
            this.serverPage.setUser(this.initialUser);
        }
        if (this.initialClient != null && !this.initialClient.isEmpty()) {
            this.clientPage.setClient(this.initialClient);
        }
        if (this.initialCharset != null && !this.initialCharset.isEmpty()) {
            this.serverPage.setCharset(this.initialCharset);
        }
    }

    @Override
    public String getPort() {
        return this.serverPage.getPort();
    }

    @Override
    public String getUser() {
        return this.serverPage.getUser();
    }

    @Override
    public String getClient() {
        return this.clientPage.getClient();
    }

    public IP4Folder[] getImportedFolders() {
        if (this.importPage != null) {
            return this.importPage.getImportedFolders();
        }
        return new IP4Folder[0];
    }

    protected void importProjects(IP4Connection connection, final IProgressMonitor monitor) {
        IP4Folder[] imports = this.getImportedFolders();
        monitor.beginTask(Messages.AbstractConnectionWizard_ImportingProjects, imports.length + 1);
        final ArrayList<IP4Folder> retrievedFolders = new ArrayList<IP4Folder>();
        IP4Folder[] iP4FolderArray = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Folder folder = iP4FolderArray[n2];
            monitor.subTask(MessageFormat.format(Messages.AbstractConnectionWizard_CheckoutFolder, folder.getRemotePath()));
            IP4Folder updated = connection.getFolder(folder.getRemotePath());
            if (updated != null) {
                retrievedFolders.add(updated);
            }
            monitor.worked(1);
            ++n2;
        }
        if (retrievedFolders.size() > 0) {
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    ImportProjectAction checkout = new ImportProjectAction();
                    checkout.selectionChanged(null, (ISelection)new StructuredSelection(retrievedFolders));
                    checkout.runAction(monitor);
                }
            });
        }
        monitor.done();
    }

    private ConnectionParameters createParameters() {
        ConnectionParameters params = new ConnectionParameters();
        params.setPort(this.getPort());
        params.setClient(this.getClient());
        params.setUser(this.getUser());
        params.setCharset(this.getCharset());
        params.setPassword(this.getPassword());
        params.setSavePassword(this.serverPage.savePassword());
        params.setAuthTicket(this.getAuthTicket());
        return params;
    }

    public boolean performFinish() {
        final ConnectionParameters params = this.createParameters();
        PerforceUIPlugin.storePasswordInUI(params);
        final boolean newClient = this.isNewClient();
        final boolean[] finished = new boolean[]{true};
        final String stream = this.clientPage.getStream();
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask(MessageFormat.format(Messages.ConnectionWizard_AddingConnection, params.getPort()), 40);
                    if (newClient) {
                        finished[0] = AbstractConnectionWizard.this.createClient(params, stream, monitor);
                        if (!finished[0]) {
                            monitor.done();
                            return;
                        }
                    } else {
                        monitor.worked(10);
                    }
                    AbstractConnectionWizard.this.saveConnection(params, monitor);
                    AbstractConnectionWizard.this.importProjects(params, monitor);
                    AbstractConnectionWizard.this.saveServerHistory(monitor);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
        catch (InterruptedException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
        return finished[0];
    }

    private boolean createClient(ConnectionParameters params, String stream, IProgressMonitor monitor) {
        monitor.subTask(NLS.bind((String)Messages.ConnectionWizard_CreatingClient, (Object)params.getClient()));
        ClientBuilder builder = new ClientBuilder(params, this.clientPage.getLocation(), stream);
        ErrorHandler handler = new ErrorHandler(){

            public boolean shouldRetry(IP4Connection connection, P4JavaException exception) {
                boolean retry = false;
                if (P4ConnectionManager.isLoginError(exception.getMessage())) {
                    retry = P4ConnectionManager.getManager().displayException(connection, exception, true, false);
                } else {
                    P4ConnectionManager.getManager().displayException(connection, exception, false, false);
                }
                return retry;
            }
        };
        if (!builder.build((IErrorHandler)handler)) {
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractConnectionWizard.this.getContainer().showPage((IWizardPage)AbstractConnectionWizard.this.clientPage);
                    P4ConnectionManager.getManager().openError(AbstractConnectionWizard.this.getShell(), Messages.ConnectionWizard_ClientExistsTitle, NLS.bind((String)Messages.ConnectionWizard_ClientExistsMessage, (Object)AbstractConnectionWizard.this.getClient()));
                }
            });
            return false;
        }
        monitor.worked(1);
        return true;
    }

    private void saveConnection(ConnectionParameters params, IProgressMonitor monitor) {
        monitor.subTask(Messages.ConnectionWizard_SavingConnection);
        P4ConnectionManager.getManager().add(params);
        monitor.worked(10);
    }

    private void importProjects(ConnectionParameters params, IProgressMonitor monitor) {
        if (this.importPage != null && this.importPage.isImportSelected() && P4ConnectionManager.getManager().containsConnection(params)) {
            monitor.subTask(Messages.ConnectionWizard_SettingUpProjectImport);
            IP4Connection connection = P4ConnectionManager.getManager().getConnection(params);
            this.importProjects(connection, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        } else {
            monitor.worked(10);
        }
    }

    private void saveServerHistory(IProgressMonitor monitor) {
        monitor.subTask(Messages.ConnectionWizard_SavingServerHistory);
        PerforceUIPlugin.syncExec(new Runnable(){

            @Override
            public void run() {
                AbstractConnectionWizard.this.serverPage.saveServerHistory();
            }
        });
        monitor.worked(10);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    @Override
    public String getCharset() {
        return this.serverPage.getCharset();
    }

    @Override
    public String getPassword() {
        return this.serverPage.getPassword();
    }

    @Override
    public String getAuthTicket() {
        return this.authTicket;
    }

    @Override
    public void setAuthTicket(String authTicket) {
        this.authTicket = authTicket;
    }

    @Override
    public String getStream() {
        if (this.isNewClient()) {
            return this.clientPage.getStream();
        }
        P4Connection conn = new P4Connection(this.createParameters());
        return conn.getClient().getStream();
    }

    public boolean isNewClient() {
        boolean newClient = this.clientPage.isNewClientSelected();
        return newClient;
    }

    public IP4Connection getConnection() {
        return this.connection;
    }

    public void setConnection(IP4Connection conn) {
        this.connection = conn;
    }

    public void setParentDialog(WizardDialog dialog) {
        this.parentDialog = dialog;
    }

    public void close() {
        if (this.parentDialog != null) {
            this.parentDialog.close();
        }
    }
}

