/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.changelists;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.changelists.DescriptionTemplate;
import com.perforce.team.ui.changelists.Messages;
import com.perforce.team.ui.editor.ContentAssistRegistry;
import com.perforce.team.ui.editor.IContentAssistProvider;
import com.perforce.team.ui.p4java.dialogs.ChangelistDescriptionAssistant;
import com.perforce.team.ui.p4java.dialogs.WrappingPainter;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.UIJob;

public class DescriptionViewer {
    private IP4Resource resource;
    private IP4File[] files = new IP4File[0];
    private IP4Job[] jobs = new IP4Job[0];
    private String context = null;
    private TextViewer viewer;
    private StyledText textWidget = null;
    private ChangelistDescriptionAssistant assistant;

    public static void updateFont(StyledText text) {
        if (P4UIUtils.okToUse((Widget)text)) {
            if (PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("com.perforce.team.ui.preferences.DESCRIPTION_EDITOR_FONT")) {
                text.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
            } else {
                text.setFont(JFaceResources.getFont((String)"org.eclipse.jface.dialogfont"));
            }
        }
    }

    public DescriptionViewer() {
        this(null);
    }

    public DescriptionViewer(IP4Resource resource) {
        this("pending.edit", resource, null, null);
    }

    public DescriptionViewer(String context, IP4Resource resource, IP4File[] files, IP4Job[] jobs) {
        this.context = context;
        this.resource = resource;
        if (jobs != null) {
            this.jobs = jobs;
        }
        if (files != null) {
            this.files = files;
        }
    }

    private void configureFont(final StyledText text) {
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        DescriptionViewer.updateFont(text);
        final IPropertyChangeListener listener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("com.perforce.team.ui.preferences.DESCRIPTION_EDITOR_FONT".equals(event.getProperty())) {
                    UIJob updateFont = new UIJob(Messages.DescriptionViewer_UpdateEditorFont){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            DescriptionViewer.updateFont(text);
                            return Status.OK_STATUS;
                        }
                    };
                    updateFont.schedule();
                }
            }
        };
        store.addPropertyChangeListener(listener);
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PerforceUIPlugin.getPlugin().getPreferenceStore().removePropertyChangeListener(listener);
            }
        });
    }

    private void installContentAssist(final TextViewer viewer, final IP4File[] files, final IP4Job[] jobs) {
        this.assistant = new ChangelistDescriptionAssistant();
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return Messages.DescriptionViewer_GeneratingContentAssist;
            }

            public void run(IProgressMonitor monitor) {
                IContentAssistProvider[] providers;
                IContentAssistProvider[] iContentAssistProviderArray = providers = ContentAssistRegistry.getRegistry().getProviders(DescriptionViewer.this.context);
                int n = providers.length;
                int n2 = 0;
                while (n2 < n) {
                    IContentAssistProvider provider = iContentAssistProviderArray[n2];
                    DescriptionViewer.this.assistant.addProposals(provider.getProposals(DescriptionViewer.this.resource, DescriptionViewer.this));
                    ++n2;
                }
                List<DescriptionTemplate> descriptions = DescriptionTemplate.getHistory();
                for (DescriptionTemplate tpl : DescriptionTemplate.getTemplates()) {
                    descriptions.add(tpl);
                }
                DescriptionViewer.this.assistant.init(files, jobs, descriptions.toArray(new DescriptionTemplate[descriptions.size()]));
                PerforceUIPlugin.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (P4UIUtils.okToUse((Widget)viewer.getTextWidget())) {
                            DescriptionViewer.this.assistant.install((ITextViewer)viewer);
                        }
                    }
                });
            }
        });
    }

    public void createControl(Composite parent, String text) {
        this.viewer = new TextViewer(parent, 2626);
        this.textWidget = this.viewer.getTextWidget();
        this.configureFont(this.textWidget);
        this.viewer.setDocument((IDocument)new Document());
        GridData deData = new GridData(4, 4, true, false);
        deData.heightHint = Math.max(80, P4UIUtils.computePixelHeight(this.textWidget.getFont(), 8));
        this.textWidget.setLayoutData((Object)deData);
        new WrappingPainter(this.viewer);
        if (text == null) {
            text = "";
        }
        this.viewer.getDocument().set(text);
        this.textWidget.selectAll();
        this.installContentAssist(this.viewer, this.files, this.jobs);
    }

    public TextViewer getViewer() {
        return this.viewer;
    }

    public void setText(String text) {
        if (text != null && P4UIUtils.okToUse((Widget)this.textWidget)) {
            this.textWidget.setText(text);
        }
    }

    public void setFocus() {
        if (P4UIUtils.okToUse((Widget)this.textWidget)) {
            this.textWidget.setFocus();
        }
    }

    public String getDescription() {
        if (this.viewer != null) {
            return this.viewer.getDocument().get();
        }
        return "";
    }

    public IDocument getDocument() {
        return this.viewer.getDocument();
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public ChangelistDescriptionAssistant getAssistant() {
        return this.assistant;
    }

    public void updateTemplates(Collection<DescriptionTemplate> templates) {
        if (templates != null) {
            this.updateTemplates(templates.toArray(new DescriptionTemplate[templates.size()]));
        }
    }

    public void updateTemplates(DescriptionTemplate[] templates) {
        if (this.assistant != null && templates != null) {
            this.assistant.updateTemplates(templates);
        }
    }

    public void updateJobs(Collection<IP4Job> jobs) {
        if (jobs != null) {
            this.updateJobs(jobs.toArray(new IP4Job[jobs.size()]));
        }
    }

    public void updateJobs(IP4Job[] jobs) {
        if (this.assistant != null && jobs != null) {
            this.assistant.updateJobs(jobs);
        }
    }
}

