/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.changelists;

import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.P4FormUIUtils;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.changelists.ChangelistFileWidget;
import com.perforce.team.ui.changelists.ChangelistJobsWidget;
import com.perforce.team.ui.changelists.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.progress.UIJob;

public abstract class ChangelistFormPage
extends FormPage
implements IP4Listener {
    public static final String DETAILS_AREA_COLLAPSED = " com.perforce.team.ui.changelists.DETAILS_AREA_COLLAPSED";
    public static final String FILES_AREA_COLLAPSED = " com.perforce.team.ui.changelists.FILES_AREA_COLLAPSED";
    public static final String JOBS_AREA_COLLAPSED = " com.perforce.team.ui.changelists.JOBS_AREA_COLLAPSED";
    public static final String PAGE_ID = "changelistPage";
    protected IP4Changelist changelist;
    private Composite body = null;
    private Section details;
    private Section files;
    private Section jobs;
    private Set<IP4Job> shownJobs = new HashSet<IP4Job>();
    private ChangelistFileWidget fileWidget;
    private ChangelistJobsWidget jobsWidget;
    private FormText changelistText;
    private FormText workspaceText;
    private FormText dateText;
    private FormText userText;
    private SourceViewer descriptionViewer;

    public ChangelistFormPage(FormEditor editor, IP4Changelist changelist) {
        super(editor, PAGE_ID, Messages.ChangelistFormPage_Overview);
        this.changelist = changelist;
        P4Workspace.getWorkspace().addListener((IP4Listener)this);
    }

    private void registerExpansionSpaceGrabber(Section section) {
        P4FormUIUtils.registerExpansionSpaceGrabber(section, this.body);
    }

    private void createFilesSection(Composite parent, FormToolkit toolkit) {
        this.files = toolkit.createSection(parent, 258);
        this.files.setText(Messages.ChangelistFormPage_Files);
        this.files.setExpanded(!PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean(FILES_AREA_COLLAPSED));
        this.files.setLayoutData((Object)new GridData(4, 4, true, this.files.isExpanded()));
        this.registerExpansionSpaceGrabber(this.files);
        Composite filesArea = toolkit.createComposite((Composite)this.files);
        filesArea.setLayout((Layout)new GridLayout(2, false));
        filesArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.files.setClient((Control)filesArea);
        this.fileWidget = this.createFileViewer(toolkit, this.files, filesArea);
        MenuManager manager = new MenuManager();
        Tree tree = this.fileWidget.getViewer().getTree();
        Menu menu = manager.createContextMenu((Control)tree);
        tree.setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.fileWidget.getViewer());
    }

    protected ToolBar createSectionToolbar(FormToolkit toolkit, Section section) {
        return P4FormUIUtils.createSectionToolbar(toolkit, section);
    }

    protected abstract ChangelistFileWidget createFileViewer(FormToolkit var1, Section var2, Composite var3);

    protected void createJobsSection(Composite parent, final FormToolkit toolkit) {
        this.jobs = toolkit.createSection(parent, 258);
        this.jobs.setText(Messages.ChangelistFormPage_Jobs);
        this.jobs.setLayoutData((Object)new GridData(4, 4, true, false));
        this.jobs.setExpanded(!PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean(JOBS_AREA_COLLAPSED));
        Composite jobsArea = toolkit.createComposite((Composite)this.jobs);
        jobsArea.setLayout((Layout)new GridLayout(2, false));
        GridData jaData = new GridData(4, 4, true, false);
        jobsArea.setLayoutData((Object)jaData);
        this.jobs.setClient((Control)jobsArea);
        this.jobsWidget = new ChangelistJobsWidget(this.changelist, true){

            @Override
            protected void createToolbar(Composite parent) {
                ToolBar toolbar = ChangelistFormPage.this.createSectionToolbar(toolkit, ChangelistFormPage.this.jobs);
                this.fillToolbar(toolbar);
            }
        };
        this.jobsWidget.createControl(jobsArea);
        MenuManager manager = new MenuManager();
        Tree tree = this.jobsWidget.getViewer().getTree();
        Menu menu = manager.createContextMenu((Control)tree);
        tree.setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.jobsWidget.getViewer());
    }

    protected String getDateLabelText() {
        return Messages.ChangelistFormPage_Date;
    }

    protected String getUserLabelText() {
        return Messages.ChangelistFormPage_User;
    }

    private void createDetailsSection(Composite parent, FormToolkit toolkit) {
        this.details = toolkit.createSection(parent, 258);
        this.details.setText(Messages.ChangelistFormPage_Details);
        this.details.setExpanded(!PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean(DETAILS_AREA_COLLAPSED));
        this.details.setLayoutData((Object)new GridData(4, 4, true, this.details.isExpanded()));
        this.registerExpansionSpaceGrabber(this.details);
        Composite detailsArea = toolkit.createComposite((Composite)this.details);
        detailsArea.setLayout((Layout)new GridLayout(4, false));
        detailsArea.setLayoutData((Object)new GridData(4, 4, true, false));
        this.details.setClient((Control)detailsArea);
        toolkit.createLabel(detailsArea, Messages.ChangelistFormPage_Changelist, 131072);
        this.changelistText = new FormText(detailsArea, 524288);
        this.changelistText.setLayoutData((Object)new GridData(4, 4, true, false));
        toolkit.createLabel(detailsArea, Messages.ChangelistFormPage_Workspace);
        this.workspaceText = new FormText(detailsArea, 524288);
        this.workspaceText.setLayoutData((Object)new GridData(4, 4, true, false));
        toolkit.createLabel(detailsArea, this.getDateLabelText());
        this.dateText = new FormText(detailsArea, 524288);
        this.dateText.setLayoutData((Object)new GridData(4, 4, true, false));
        toolkit.createLabel(detailsArea, this.getUserLabelText());
        this.userText = new FormText(detailsArea, 524288);
        this.userText.setLayoutData((Object)new GridData(4, 4, true, false));
        toolkit.createLabel(detailsArea, Messages.ChangelistFormPage_Description);
        this.descriptionViewer = new SourceViewer(detailsArea, null, 2890);
        this.descriptionViewer.setDocument((IDocument)new Document());
        IAdaptable adaptable = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                IP4Changelist adaptableList = ChangelistFormPage.this.changelist;
                return adaptableList != null ? Platform.getAdapterManager().getAdapter((Object)adaptableList, adapter) : null;
            }
        };
        this.descriptionViewer.configure((SourceViewerConfiguration)P4UIUtils.createSourceViewerConfiguration(adaptable));
        GridData dData = new GridData(4, 4, true, true);
        dData.heightHint = 80;
        dData.horizontalSpan = 3;
        this.descriptionViewer.getTextWidget().setLayoutData((Object)dData);
        this.resetDetailViewer();
    }

    private void loadContents() {
        UIJob loadJob = new UIJob(String.valueOf(Messages.ChangelistFormPage_RefreshingChangelist) + this.changelist.getId()){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (ChangelistFormPage.this.fileWidget != null) {
                    ChangelistFormPage.this.fileWidget.showLoading();
                }
                if (ChangelistFormPage.this.jobsWidget != null) {
                    ChangelistFormPage.this.jobsWidget.showLoading();
                }
                P4Runner.schedule((IP4Runnable)new P4Runnable(){

                    public String getTitle() {
                        return MessageFormat.format(Messages.ChangelistFormPage_LoadingChangelist, (this).ChangelistFormPage.this.changelist.getId());
                    }

                    public void run(IProgressMonitor monitor) {
                        if ((this).ChangelistFormPage.this.changelist.needsRefresh()) {
                            (this).ChangelistFormPage.this.changelist.refresh();
                        }
                        ChangelistFormPage.this.fileWidget.setFiles((this).ChangelistFormPage.this.changelist.getFiles());
                        ChangelistFormPage.this.fileWidget.generateFileTree();
                        ChangelistFormPage.this.fileWidget.generateCompressedFileTree();
                        PerforceUIPlugin.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ChangelistFormPage.this.fillViewers();
                            }
                        });
                    }
                });
                return Status.OK_STATUS;
            }
        };
        loadJob.schedule();
    }

    private void fillViewers() {
        if (P4UIUtils.okToUse((Viewer)this.fileWidget.getViewer())) {
            IP4Resource[] clFiles = this.changelist.getFiles();
            this.fileWidget.refreshInput();
            this.files.setText(MessageFormat.format(Messages.ChangelistFormPage_FilesNumber, clFiles.length));
            this.files.layout(true);
        }
        this.shownJobs.clear();
        this.shownJobs.addAll(Arrays.asList(this.changelist.getJobs()));
        this.resetJobViewer();
        this.resetDetailViewer();
    }

    private void resetDetailViewer() {
        String description;
        String client;
        if (!P4UIUtils.okToUse((Widget)this.details)) {
            return;
        }
        String user = this.changelist.getUserName();
        if (user == null) {
            user = "";
        }
        if ((client = this.changelist.getClientName()) == null) {
            client = "";
        }
        if ((description = this.changelist.getDescription()) == null) {
            description = "";
        }
        Date submittedDate = this.changelist.getDate();
        String submitted = null;
        if (submittedDate != null) {
            submitted = P4UIUtils.formatLabelDate(submittedDate);
        }
        if (submitted == null) {
            submitted = "";
        }
        String id = Integer.toString(this.changelist.getId());
        this.userText.setText(user, false, false);
        this.workspaceText.setText(client, false, false);
        this.dateText.setText(submitted, false, false);
        this.changelistText.setText(id, false, false);
        this.descriptionViewer.getDocument().set(description);
    }

    private void resetJobViewer() {
        if (this.jobsWidget != null && this.jobsWidget.okToUse()) {
            this.jobsWidget.setInput((IP4Resource[])this.shownJobs.toArray(new IP4Job[this.shownJobs.size()]));
            this.jobs.setText(MessageFormat.format(Messages.ChangelistFormPage_JobsNumber, this.shownJobs.size()));
            this.jobs.layout(true, true);
        }
    }

    public void dispose() {
        P4Workspace.getWorkspace().removeListener((IP4Listener)this);
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        if (this.jobs != null) {
            store.setValue(JOBS_AREA_COLLAPSED, !this.jobs.isExpanded());
        }
        if (this.details != null) {
            store.setValue(DETAILS_AREA_COLLAPSED, !this.details.isExpanded());
        }
        if (this.files != null) {
            store.setValue(FILES_AREA_COLLAPSED, !this.files.isExpanded());
        }
        super.dispose();
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.body = managedForm.getForm().getBody();
        this.body.setLayout((Layout)new GridLayout(1, true));
        FormToolkit toolkit = managedForm.getToolkit();
        this.createDetailsSection(this.body, toolkit);
        this.createFilesSection(this.body, toolkit);
        this.createJobsSection(this.body, toolkit);
        this.loadContents();
    }

    public void resoureChanged(P4Event event) {
        if (event.getType() == P4Event.EventType.FIXED || event.getType() == P4Event.EventType.UNFIXED) {
            ArrayList<IP4Job> modifiedJobs = new ArrayList<IP4Job>();
            IP4Job[] iP4JobArray = event.getJobs();
            int n = iP4JobArray.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Job job = iP4JobArray[n2];
                if (this.changelist.equals(job.getParent())) {
                    modifiedJobs.add(job);
                }
                ++n2;
            }
            if (modifiedJobs.size() > 0) {
                if (event.getType() == P4Event.EventType.FIXED) {
                    this.shownJobs.addAll(modifiedJobs);
                } else if (event.getType() == P4Event.EventType.UNFIXED) {
                    this.shownJobs.removeAll(modifiedJobs);
                }
                PerforceUIPlugin.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ChangelistFormPage.this.jobsWidget != null && ChangelistFormPage.this.jobsWidget.okToUse()) {
                            ChangelistFormPage.this.resetJobViewer();
                        }
                    }
                });
            }
        }
    }

    public void refresh() {
        this.changelist.markForRefresh();
        this.loadContents();
    }

    public String getName() {
        return ChangelistFormPage.class.getSimpleName();
    }
}

