/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.changelists;

import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.changelists.Messages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ChangelistDetailsWidget {
    private IP4Changelist list;
    private ScrolledComposite outer;
    private Composite displayArea;
    private Text changelistText;
    private Text workspaceText;
    private Text dateText;
    private Text userText;
    private SourceViewer descriptionViewer;

    public void setChangelist(IP4Changelist list) {
        this.list = list;
        this.refresh();
    }

    public void refresh() {
        if (this.list != null) {
            this.changelistText.setText(Integer.toString(this.list.getId()));
            String client = this.list.getClientName();
            if (client == null) {
                client = "";
            }
            this.workspaceText.setText(client);
            String user = this.list.getUserName();
            if (user == null) {
                user = "";
            }
            this.userText.setText(user);
            this.dateText.setText(P4UIUtils.formatLabelDate(this.list.getDate()));
            String description = this.list.getDescription();
            if (description == null) {
                description = "";
            }
            this.descriptionViewer.getTextWidget().setText(description);
            this.displayArea.layout(true, true);
            this.outer.setMinSize(this.displayArea.computeSize(-1, -1));
        } else {
            this.clear();
        }
    }

    public void clear() {
        this.changelistText.setText("");
        this.descriptionViewer.getTextWidget().setText("");
        this.userText.setText("");
        this.dateText.setText("");
        this.workspaceText.setText("");
    }

    protected String getDateLabelText() {
        return Messages.ChangelistDetailsWidget_Date;
    }

    protected String getUserLabelText() {
        return Messages.ChangelistDetailsWidget_User;
    }

    public void createControl(Composite parent) {
        this.outer = new ScrolledComposite(parent, 2816);
        this.outer.setExpandVertical(true);
        this.outer.setExpandHorizontal(true);
        this.displayArea = new Composite((Composite)this.outer, 0);
        this.outer.setContent((Control)this.displayArea);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout daLayout = new GridLayout(4, false);
        this.displayArea.setLayout((Layout)daLayout);
        GridData textData = new GridData(4, 4, true, false);
        Label changelistLabel = new Label(this.displayArea, 0);
        changelistLabel.setText(Messages.ChangelistDetailsWidget_Changelist);
        this.changelistText = new Text(this.displayArea, 12);
        this.changelistText.setLayoutData((Object)textData);
        this.changelistText.setFont(changelistLabel.getFont());
        Label workspaceLabel = new Label(this.displayArea, 0);
        workspaceLabel.setText(Messages.ChangelistDetailsWidget_Workspace);
        this.workspaceText = new Text(this.displayArea, 12);
        this.workspaceText.setLayoutData((Object)textData);
        this.workspaceText.setFont(workspaceLabel.getFont());
        Label dateLabel = new Label(this.displayArea, 0);
        dateLabel.setText(this.getDateLabelText());
        this.dateText = new Text(this.displayArea, 12);
        this.dateText.setLayoutData((Object)textData);
        this.dateText.setFont(dateLabel.getFont());
        Label userLabel = new Label(this.displayArea, 0);
        userLabel.setText(this.getUserLabelText());
        this.userText = new Text(this.displayArea, 12);
        this.userText.setLayoutData((Object)textData);
        this.userText.setFont(userLabel.getFont());
        Label descriptionLabel = new Label(this.displayArea, 0);
        descriptionLabel.setText(Messages.ChangelistDetailsWidget_Description);
        this.descriptionViewer = new SourceViewer(this.displayArea, null, 2378);
        this.descriptionViewer.setDocument((IDocument)new Document());
        IAdaptable adaptable = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                IP4Changelist adaptableList = ChangelistDetailsWidget.this.list;
                return adaptableList != null ? Platform.getAdapterManager().getAdapter((Object)adaptableList, adapter) : null;
            }
        };
        this.descriptionViewer.configure((SourceViewerConfiguration)P4UIUtils.createSourceViewerConfiguration(adaptable));
        GridData dtData = new GridData(4, 4, true, true);
        dtData.horizontalSpan = 3;
        this.descriptionViewer.getTextWidget().setLayoutData((Object)dtData);
        this.outer.setMinSize(this.displayArea.computeSize(-1, -1));
    }

    public String getChangelistText() {
        return this.changelistText.getText();
    }

    public String getDateText() {
        return this.dateText.getText();
    }

    public String getUserText() {
        return this.userText.getText();
    }

    public String getWorkspaceText() {
        return this.workspaceText.getText();
    }

    public String getDescriptionText() {
        return this.descriptionViewer.getTextWidget().getText();
    }

    public Composite getControl() {
        return this.outer;
    }
}

