/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.branches;

import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.branches.BranchWidget;
import com.perforce.team.ui.branches.BranchesViewer;
import com.perforce.team.ui.branches.EditBranchAction;
import com.perforce.team.ui.branches.Messages;
import com.perforce.team.ui.branches.NewBranchAction;
import com.perforce.team.ui.views.IPerforceView;
import com.perforce.team.ui.views.PerforceFilterViewControl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.progress.UIJob;

public class BranchesViewControl
extends PerforceFilterViewControl {
    public static final String DISPLAY_DETAILS = "com.perforce.team.ui.branches.display_details";
    public static final String HIDE_FILTERS = "com.perforce.team.ui.branches.HIDE_FILTERS";
    private Action refreshAction;
    private Action showDetailsAction;
    private Action openPrefs;
    private boolean displayDetails;
    private BranchesViewer branchesViewer = null;
    private IP4Listener workspaceListener = new IP4Listener(){

        public void resoureChanged(final P4Event event) {
            IP4Branch[] branches;
            if ((P4Event.EventType.REFRESHED == event.getType() || P4Event.EventType.CREATE_BRANCH == event.getType()) && (branches = event.getBranches()).length > 0) {
                UIJob refreshJob = new UIJob(Messages.BranchesView_RefreshingBranches){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        TableViewer viewer = BranchesViewControl.this.getTableViewer();
                        if (BranchesViewControl.this.p4Connection != null && viewer != null && !viewer.getTable().isDisposed()) {
                            switch (event.getType()) {
                                case REFRESHED: {
                                    BranchesViewControl.this.handleRefresh(branches);
                                    break;
                                }
                                case CREATE_BRANCH: {
                                    BranchesViewControl.this.handleCreate(branches);
                                    break;
                                }
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                refreshJob.schedule();
            }
        }

        public String getName() {
            return BranchesViewControl.this.getClass().getSimpleName();
        }
    };

    public BranchesViewControl(IPerforceView view) {
        super(view);
        this.branchesViewer = new BranchesViewer();
        this.setFilterViewer(this.branchesViewer);
    }

    private void handleRefresh(IP4Branch[] branches) {
        IP4Branch[] iP4BranchArray = branches;
        int n = branches.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Branch branch = iP4BranchArray[n2];
            if (this.p4Connection.equals(branch.getConnection())) {
                TableViewer tblViewer = this.getTableViewer();
                if (tblViewer != null) {
                    tblViewer.update((Object)branch, null);
                }
                this.branchesViewer.refreshDetails(branch);
            }
            ++n2;
        }
    }

    private void handleCreate(IP4Branch[] branches) {
        if (this.branchesViewer != null) {
            IP4Branch[] iP4BranchArray = branches;
            int n = branches.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Branch branch = iP4BranchArray[n2];
                if (this.p4Connection.equals(branch.getConnection())) {
                    this.branchesViewer.addBranch(branch);
                }
                ++n2;
            }
        }
    }

    @Override
    public void setFocus() {
        Table control;
        if (this.branchesViewer != null && (control = this.branchesViewer.getTableControl()) != null && !control.isDisposed()) {
            control.setFocus();
        }
    }

    @Override
    public void dispose() {
        this.removeProjectListeners();
        P4ConnectionManager.getManager().removeListener(this.workspaceListener);
    }

    @Override
    public void refresh() {
        if (this.branchesViewer != null) {
            this.branchesViewer.refresh();
        }
    }

    @Override
    protected String getFilterPreference() {
        return HIDE_FILTERS;
    }

    @Override
    protected String getSelectedName() {
        return Messages.BranchesView_Branches;
    }

    @Override
    protected void createControl(Composite parent) {
        this.createMenus();
        this.showNoConnection();
        this.addProjectListeners();
        P4ConnectionManager.getManager().addListener(this.workspaceListener);
    }

    public Table getTableControl() {
        return this.branchesViewer != null ? this.branchesViewer.getTableControl() : null;
    }

    public TableViewer getTableViewer() {
        return this.branchesViewer != null ? this.branchesViewer.getViewer() : null;
    }

    private void hookContextMenu() {
        MenuManager manager = new MenuManager();
        Menu menu = manager.createContextMenu((Control)this.branchesViewer.getTableControl());
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        manager.setRemoveAllWhenShown(true);
        if (this.branchesViewer.getTableControl() != null) {
            this.branchesViewer.getTableControl().setMenu(menu);
        }
        this.registerContextMenu(manager, (ISelectionProvider)this.branchesViewer.getViewer());
    }

    @Override
    protected void setViewerInput(IP4Connection con) {
        if (this.connectionOK(con)) {
            this.refreshAction.setEnabled(true);
            this.branchesViewer.createControl(this.displayArea, con, false, this.displayDetails);
            this.showDisplayArea();
            this.hookContextMenu();
            this.branchesViewer.getViewer().addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    IP4Branch branch = BranchesViewControl.this.getBranchSelection();
                    if (branch != null) {
                        BranchesViewControl.this.edit(branch);
                    }
                }
            });
        } else {
            this.showNoConnection();
        }
    }

    @Override
    protected void showNoConnection() {
        super.showNoConnection();
        this.refreshAction.setEnabled(false);
    }

    private void edit(IP4Branch branch) {
        EditBranchAction edit = new EditBranchAction();
        edit.selectionChanged(null, (ISelection)new StructuredSelection((Object)branch));
        edit.run(null);
    }

    private void createMenus() {
        PerforceUIPlugin plugin = PerforceUIPlugin.getPlugin();
        this.refreshAction = new Action(Messages.BranchesView_Refresh, plugin.getImageDescriptor("enabled/refresh.png")){

            public void run() {
                BranchesViewControl.this.branchesViewer.refresh();
            }
        };
        this.refreshAction.setToolTipText(Messages.BranchesView_RefreshBranches);
        this.refreshAction.setDisabledImageDescriptor(plugin.getImageDescriptor("disabled/refresh.png"));
        this.refreshAction.setHoverImageDescriptor(plugin.getImageDescriptor("normal/refresh.png"));
        this.openPrefs = new Action(Messages.BranchesView_OpenBranchesPreferences, plugin.getImageDescriptor("views/preferences.png")){

            public void run() {
                P4UIUtils.openPreferencePage("com.perforce.team.ui.branches.BranchesPreferencePage");
            }
        };
        this.showDetailsAction = new Action(Messages.BranchesView_ShowBranchDetails){

            public int getStyle() {
                return 2;
            }
        };
        this.displayDetails = plugin.getPreferenceStore().getBoolean(DISPLAY_DETAILS);
        this.showDetailsAction.setChecked(this.displayDetails);
        this.showDetailsAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                BranchesViewControl.this.displayDetails = BranchesViewControl.this.showDetailsAction.isChecked();
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(BranchesViewControl.DISPLAY_DETAILS, BranchesViewControl.this.displayDetails);
                if (BranchesViewControl.this.showingConnection()) {
                    BranchesViewControl.this.showDetails(BranchesViewControl.this.displayDetails);
                }
            }
        });
        Action newBranchAction = new Action(Messages.BranchesView_NewBranch, plugin.getImageDescriptor("normal/add.png")){

            public void run() {
                IP4Connection connection = BranchesViewControl.this.p4Connection;
                if (connection != null) {
                    NewBranchAction newBranch = new NewBranchAction();
                    newBranch.selectionChanged(null, (ISelection)new StructuredSelection((Object)connection));
                    newBranch.run(null);
                }
            }
        };
        IActionBars bars = this.getActionBars();
        if (bars != null) {
            IToolBarManager tbm = bars.getToolBarManager();
            tbm.add((IAction)newBranchAction);
            tbm.add((IAction)this.refreshAction);
            tbm.add((IAction)this.openPrefs);
            tbm.update(false);
            IMenuManager pulldown = bars.getMenuManager();
            pulldown.add((IAction)this.showDetailsAction);
            this.createFilterAction((IContributionManager)pulldown);
            pulldown.update(false);
        }
    }

    private IP4Branch getBranchSelection() {
        IP4Branch selected = null;
        IStructuredSelection selection = (IStructuredSelection)this.branchesViewer.getViewer().getSelection();
        if (selection.size() == 1) {
            selected = (IP4Branch)selection.getFirstElement();
        }
        return selected;
    }

    public BranchesViewer getBranchesViewer() {
        return this.branchesViewer;
    }

    public boolean isLoading() {
        return this.branchesViewer != null && this.branchesViewer.isLoading();
    }

    @Override
    public void refreshRetrieveCount() {
        if (this.branchesViewer != null) {
            this.branchesViewer.refreshRetrieveCount();
        }
    }

    @Override
    public void showMore() {
        if (this.branchesViewer != null) {
            this.branchesViewer.showMore();
        }
    }

    public void showDetails(boolean show) {
        if (this.branchesViewer != null && this.showingConnection()) {
            this.branchesViewer.updateSash(show);
        }
    }

    public BranchWidget getBranchDetails() {
        if (this.branchesViewer != null) {
            return this.branchesViewer.getDetails();
        }
        return null;
    }
}

