/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.actions;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.actions.Messages;
import com.perforce.team.ui.editor.ClientFileEditorInput;
import com.perforce.team.ui.editor.DepotFileEditorInput;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class OpenAction {
    public static void openFiles(IP4File[] files) {
        int i = 0;
        while (i < files.length) {
            IFile workspaceFile = PerforceProviderPlugin.getWorkspaceFile((String)files[i].getLocalPath());
            if (workspaceFile != null) {
                OpenAction.openFile(workspaceFile);
            } else {
                OpenAction.openFile(files[i]);
            }
            ++i;
        }
    }

    public static void openDepotFile(IP4File file) {
        if (file != null && file.getHeadRevision() > 0 && !file.isHeadActionDelete()) {
            DepotFileEditorInput input = new DepotFileEditorInput(file);
            P4UIUtils.openEditor(input);
        }
    }

    public static void openFile(IP4File file) {
        if (file != null) {
            IFile local = file.getLocalFileForLocation();
            if (local != null) {
                OpenAction.openFile(local);
            } else {
                String localPath = file.getLocalPath();
                if (localPath != null) {
                    File localFile = new File(localPath);
                    if (localFile.exists()) {
                        ClientFileEditorInput input = new ClientFileEditorInput(localFile);
                        P4UIUtils.openEditor(input);
                    } else {
                        OpenAction.openDepotFile(file);
                    }
                } else {
                    OpenAction.openDepotFile(file);
                }
            }
        }
    }

    public static void openFile(String filePath) {
        IFile workspaceFile = PerforceProviderPlugin.getWorkspaceFile((String)filePath);
        if (workspaceFile != null) {
            OpenAction.openFile(workspaceFile);
        }
    }

    public static void openFile(IFile file) {
        final boolean[] openFile = new boolean[1];
        final IProject project = file.getProject();
        Shell shell = P4UIUtils.getShell();
        if (!project.isOpen()) {
            if (MessageDialog.openQuestion((Shell)shell, (String)Messages.OpenAction_P4Eclipse, (String)Messages.OpenAction_AskOpenProjectMessage)) {
                try {
                    IRunnableWithProgress op = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            try {
                                project.open(monitor);
                                openFile[0] = true;
                            }
                            catch (CoreException e) {
                                PerforceProviderPlugin.logError((Throwable)e);
                            }
                        }
                    };
                    new ProgressMonitorDialog(shell).run(true, true, op);
                }
                catch (InvocationTargetException e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            openFile[0] = true;
        }
        if (openFile[0]) {
            try {
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
    }

    public static void openFiles(String[] files) {
        int i = 0;
        while (i < files.length) {
            OpenAction.openFile(files[i]);
            ++i;
        }
    }
}

