/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui;

import com.perforce.p4java.server.CmdSpec;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4Folder;
import com.perforce.team.core.p4java.IP4ProgressListener;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.ui.Messages;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIProgressListener;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.project.ProjectNameDialog;
import com.perforce.team.ui.project.ReuseConnectionDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.progress.UIJob;

public class PerforceProjectSetSerializer
extends ProjectSetCapability {
    private static final String SERVER_PORT = "PORT";
    private static final String PROJECT_NAME = "NAME";
    private static final String DEPOT_PATH = "PATH";

    public String[] asReference(IProject[] providerProjects, ProjectSetSerializationContext context, IProgressMonitor monitor) throws TeamException {
        String[] refs = new String[providerProjects.length];
        int i = 0;
        while (i < refs.length) {
            refs[i] = this.toProjectString(providerProjects[i]);
            ++i;
        }
        return refs;
    }

    public IProject[] addToWorkspace(String[] referenceStrings, ProjectSetSerializationContext context, IProgressMonitor monitor, ConnectionParameters parameters) throws TeamException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IProject[] projects = new IProject[referenceStrings.length];
        monitor.beginTask("", referenceStrings.length);
        final HashMap reused = new HashMap();
        int i = 0;
        while (i < projects.length) {
            ConnectionParameters initialParams = parameters;
            Map<String, String> properties = this.parseProjectString(referenceStrings[i]);
            String projectName = properties.get(PROJECT_NAME);
            String depotPath = properties.get(DEPOT_PATH);
            final String serverPort = properties.get(SERVER_PORT);
            if (depotPath != null && serverPort != null) {
                monitor.setTaskName(MessageFormat.format(Messages.PerforceProjectSetSerializer_ImportingFrom, depotPath, serverPort));
            }
            final ConnectionParameters[] params = new ConnectionParameters[1];
            if (serverPort != null && initialParams == null) {
                initialParams = (ConnectionParameters)reused.get(serverPort);
            }
            if (initialParams == null) {
                PerforceUIPlugin.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ReuseConnectionDialog dialog = new ReuseConnectionDialog(PerforceUIPlugin.getDisplay().getActiveShell());
                        ConnectionParameters dialogParams = new ConnectionParameters();
                        dialogParams.setPort(serverPort);
                        dialog.setConnectionParams(dialogParams);
                        if (dialog.open() == 0) {
                            params[0] = dialog.getConnectionParams();
                            if (serverPort != null && dialog.reuse()) {
                                reused.put(serverPort, params[0]);
                                String enteredPort = params[0].getPort();
                                if (enteredPort != null) {
                                    reused.put(enteredPort, params[0]);
                                }
                            }
                        }
                    }
                });
            } else {
                params[0] = initialParams;
            }
            if (params[0] != null) {
                IP4Folder folder;
                IP4Connection connection = P4ConnectionManager.getManager().getConnection(params[0]);
                if (!connection.isConnected()) {
                    connection.connect();
                }
                if ((folder = connection.getFolder(depotPath)) != null) {
                    folder.updateLocation();
                    projects[i] = PerforceProjectSetSerializer.createProject((IP4Container)folder, null, monitor, projectName);
                }
            }
            monitor.worked(1);
            ++i;
        }
        monitor.done();
        return projects;
    }

    public IProject[] addToWorkspace(String[] referenceStrings, ProjectSetSerializationContext context, IProgressMonitor monitor) throws TeamException {
        return this.addToWorkspace(referenceStrings, context, monitor, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String findProjectName(IP4Folder parent) {
        String name = null;
        String localPath = String.valueOf(parent.getLocalPath()) + "/.project";
        FileInputStream stream = null;
        try {
            try {
                stream = new FileInputStream(localPath);
                IProjectDescription desc = ResourcesPlugin.getWorkspace().loadProjectDescription((InputStream)stream);
                if (desc == null) return name;
                name = desc.getName();
                return name;
            }
            catch (CoreException e) {
                name = null;
                if (stream == null) return name;
                try {
                    ((InputStream)stream).close();
                    return name;
                }
                catch (IOException iOException) {}
                return name;
            }
            catch (FileNotFoundException e) {
                name = null;
                if (stream == null) return name;
                try {
                    ((InputStream)stream).close();
                    return name;
                }
                catch (IOException iOException) {}
                return name;
            }
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void loadLocalLocation(IP4Folder folder, IProgressMonitor monitor) throws OperationCanceledException {
        monitor.setTaskName(MessageFormat.format(Messages.PerforceProjectSetSerializer_FetchingLocalLocation, folder.getRemotePath()));
        folder.updateLocation();
        monitor.worked(10);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private static void syncLocation(IP4Folder folder, IProgressMonitor monitor) throws OperationCanceledException {
        monitor.setTaskName(MessageFormat.format(Messages.PerforceProjectSetSerializer_Syncing, folder.getLocalPath()));
        P4ConnectionManager.getManager().createP4Collection((IP4Resource)folder).sync((IProgressMonitor)new SubProgressMonitor(monitor, 10));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private static IProjectDescription loadDescription(IP4Folder folder, IProgressMonitor monitor, String defaultName) {
        String defaultPath;
        IProject existingProject;
        String localPath = folder.getLocalPath();
        monitor.setTaskName(MessageFormat.format(Messages.PerforceProjectSetSerializer_LoadingProjectName, localPath));
        String name = defaultName;
        if (name == null) {
            name = PerforceProjectSetSerializer.findProjectName(folder);
        }
        if (name == null) {
            name = folder.getName();
        }
        if ((existingProject = ResourcesPlugin.getWorkspace().getRoot().getProject(name)) != null && existingProject.exists()) {
            final String[] otherName = new String[]{name};
            final boolean[] cancelled = new boolean[1];
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    ProjectNameDialog dialog = new ProjectNameDialog(P4UIUtils.getShell(), otherName[0]);
                    if (dialog.open() == 0) {
                        otherName[0] = dialog.getEnteredName();
                    } else {
                        cancelled[0] = true;
                    }
                }
            });
            name = otherName[0];
            if (cancelled[0]) {
                return null;
            }
        }
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(name);
        IPath rootLoc = Platform.getLocation();
        if (localPath != null && rootLoc != null && !localPath.equalsIgnoreCase(defaultPath = rootLoc.append(name).toOSString())) {
            description.setLocation((IPath)new Path(localPath));
        }
        monitor.worked(10);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return description;
    }

    private static IProject createProject(final IProjectDescription description, IProgressMonitor monitor) throws CoreException {
        final String name = description.getName();
        monitor.setTaskName(MessageFormat.format(Messages.PerforceProjectSetSerializer_CreatingProject, name));
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject newProjectHandle = workspace.getRoot().getProject(name);
        try {
            File path;
            URI uri = description.getLocationURI();
            if (uri != null && !(path = new File(uri)).exists() && !path.mkdirs()) {
                String msg = MessageFormat.format(Messages.PerforceProjectSetSerializer_CreateFolderError, path.getAbsolutePath());
                PerforceProviderPlugin.logError((String)msg);
            }
            newProjectHandle.create(description, null);
            newProjectHandle.open(null);
        }
        catch (CoreException e) {
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    P4ConnectionManager.getManager().openError(P4UIUtils.getShell(), Messages.PerforceProjectSetSerializer_ErrorCreatingProjectTitle, MessageFormat.format(Messages.PerforceProjectSetSerializer_ErrorCreatingProjectMessage, name, description.getLocationURI()));
                }
            });
            throw e;
        }
        monitor.worked(10);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return newProjectHandle;
    }

    private static void manageProject(IP4Folder folder, IProject project, IProgressMonitor monitor) {
        String name = project.getName();
        monitor.setTaskName(MessageFormat.format(Messages.PerforceProjectSetSerializer_ManagingProject, name));
        PerforceProviderPlugin.manageProject((IProject)project, (ConnectionParameters)folder.getConnection().getParameters());
        monitor.worked(10);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static Job createProjects(P4Collection collection, Shell shell, boolean showErrors) {
        return PerforceProjectSetSerializer.createProjects(collection, shell, showErrors, true);
    }

    private static void createProject(IProgressMonitor monitor, String defaultName, IP4Folder container, boolean showErrors, StringBuilder errors) throws CoreException {
        SubProgressMonitor projectMonitor = new SubProgressMonitor(monitor, 10);
        projectMonitor.beginTask("", 50);
        try {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            PerforceProjectSetSerializer.loadLocalLocation(container, (IProgressMonitor)projectMonitor);
            String localPath = container.getLocalPath();
            if (localPath != null) {
                if (!PerforceProjectSetSerializer.isFilenameValid(localPath)) {
                    errors.append(container.getRemotePath()).append("\n");
                } else {
                    PerforceProjectSetSerializer.syncLocation(container, (IProgressMonitor)projectMonitor);
                    IProjectDescription description = PerforceProjectSetSerializer.loadDescription(container, (IProgressMonitor)projectMonitor, defaultName);
                    if (description != null) {
                        IProject project = PerforceProjectSetSerializer.createProject(description, (IProgressMonitor)projectMonitor);
                        PerforceProjectSetSerializer.manageProject(container, project, (IProgressMonitor)projectMonitor);
                    } else {
                        projectMonitor.worked(20);
                    }
                }
                P4Collection collection = new P4Collection();
                collection.add((IP4Resource)container);
                collection.refresh();
            } else if (showErrors) {
                errors.append(container.getRemotePath()).append("\n");
            }
        }
        finally {
            projectMonitor.done();
            P4ConnectionManager.getManager().notifyListeners(new P4Event(P4Event.EventType.REFRESHED, (IP4Resource)container));
        }
    }

    public static boolean isFilenameValid(String file) {
        String path;
        block6: {
            if (file == null) {
                return false;
            }
            path = new File(file).getCanonicalPath();
            if (path != null) break block6;
            return false;
        }
        try {
            if (path != null) {
                String f = file.replace("/", "").replace("\\", "");
                String p = path.replace("/", "").replace("\\", "");
                if (p.equalsIgnoreCase(f)) {
                    return true;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static Job createProject(final IP4Folder container, final String defaultName, final Shell shell, final boolean showErrors, boolean async) {
        final StringBuilder errors = new StringBuilder();
        final String taskName = Messages.PerforceProjectSetSerializer_ImportingOneProject;
        final WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(taskName, 10);
                try {
                    try {
                        PerforceProjectSetSerializer.createProject(monitor, defaultName, container, showErrors, errors);
                    }
                    catch (CoreException e) {
                        PerforceProviderPlugin.logError((Throwable)e);
                        throw e;
                    }
                }
                finally {
                    monitor.done();
                }
                if (showErrors && errors.length() > 0) {
                    UIJob errorJob = new UIJob(Messages.PerforceProjectSetSerializer_DisplayingPerforceErrors){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            P4ConnectionManager.getManager().openError(shell, Messages.PerforceProjectSetSerializer_ImportFailedTitle, String.valueOf(Messages.PerforceProjectSetSerializer_ImportFailedMessage) + errors.toString());
                            return Status.OK_STATUS;
                        }
                    };
                    errorJob.schedule();
                }
            }
        };
        Job importJob = null;
        if (async) {
            importJob = new Job(taskName){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        op.run(monitor);
                    }
                    catch (InvocationTargetException e) {
                        return Status.CANCEL_STATUS;
                    }
                    catch (InterruptedException e) {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            PlatformUI.getWorkbench().getProgressService().showInDialog(shell, importJob);
            importJob.schedule();
        } else {
            try {
                op.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return importJob;
    }

    public static Job createProjects(P4Collection collection, final Shell shell, final boolean showErrors, boolean async) {
        final ArrayList<IP4Folder> containers = new ArrayList<IP4Folder>();
        IP4Resource[] iP4ResourceArray = collection.members();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4Folder) {
                containers.add((IP4Folder)resource);
            }
            ++n2;
        }
        final StringBuilder errors = new StringBuilder();
        final String taskName = MessageFormat.format(Messages.PerforceProjectSetSerializer_ImportingProjects, containers.size());
        final WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(taskName, containers.size());
                try {
                    for (IP4Folder container : containers) {
                        try {
                            PerforceProjectSetSerializer.createProject(monitor, null, container, showErrors, errors);
                        }
                        catch (CoreException e) {
                            PerforceProviderPlugin.logError((Throwable)e);
                            throw e;
                        }
                    }
                }
                finally {
                    monitor.done();
                }
                if (showErrors && errors.length() > 0) {
                    UIJob errorJob = new UIJob(Messages.PerforceProjectSetSerializer_DisplayingPerforceErrors){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            P4ConnectionManager.getManager().openError(shell, Messages.PerforceProjectSetSerializer_ImportFailedTitle, String.valueOf(Messages.PerforceProjectSetSerializer_ImportFailedMessage) + errors.toString());
                            return Status.OK_STATUS;
                        }
                    };
                    errorJob.schedule();
                }
            }
        };
        Job importJob = null;
        if (async) {
            importJob = new Job(taskName){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        op.run(monitor);
                    }
                    catch (InvocationTargetException e) {
                        return Status.CANCEL_STATUS;
                    }
                    catch (InterruptedException e) {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            PlatformUI.getWorkbench().getProgressService().showInDialog(shell, importJob);
            importJob.schedule();
        } else {
            try {
                op.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return importJob;
    }

    public static IProject createProject(final IP4Container container, Shell shell, IProgressMonitor monitor, String name) {
        String defaultPath;
        IPath eclipseLoc;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String location = container.getLocalPath();
        if (name == null) {
            name = container.getName();
        }
        final IProjectDescription description = workspace.newProjectDescription(name);
        if (location != null && (eclipseLoc = Platform.getLocation()) != null && location.compareToIgnoreCase(defaultPath = eclipseLoc.append(name).toOSString()) != 0) {
            description.setLocation((IPath)new Path(location));
        }
        final IProject newProjectHandle = workspace.getRoot().getProject(name);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask("", 3000);
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 500);
                    P4UIProgressListener callback = new P4UIProgressListener(CmdSpec.SYNC, container.getConnection(), (IProgressMonitor)subMonitor);
                    P4ConnectionManager.getManager().createP4Collection(new IP4Resource[]{container}).sync((IProgressMonitor)subMonitor, (IP4ProgressListener)callback);
                    newProjectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    newProjectHandle.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                    PerforceProviderPlugin.manageProject((IProject)newProjectHandle, (ConnectionParameters)container.getConnection().getParameters());
                    P4ConnectionManager.getManager().notifyListeners(new P4Event(P4Event.EventType.REFRESHED, (IP4Resource)container));
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            if (monitor != null) {
                op.run(monitor);
            } else {
                new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)op);
            }
        }
        catch (InvocationTargetException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return newProjectHandle;
    }

    private String toProjectString(IProject project) throws TeamException {
        IP4Resource resource;
        String depotPath = null;
        IP4Connection connection = P4ConnectionManager.getManager().getConnection(project);
        if (connection != null && (resource = P4ConnectionManager.getManager().getResource((IResource)project)) instanceof IP4Folder) {
            IP4Folder projectFolder = (IP4Folder)resource;
            depotPath = projectFolder.getFirstWhereRemotePath();
        }
        if (depotPath == null) {
            throw new TeamException(Messages.PerforceProjectSetSerializer_UnableToConnect);
        }
        return "PORT=" + connection.getParameters().getPort() + ";" + PROJECT_NAME + "=" + project.getName() + ";" + DEPOT_PATH + "=" + depotPath;
    }

    private Map<String, String> parseProjectString(String s) {
        HashMap<String, String> properties = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(s, ";");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int idx = token.indexOf(61);
            properties.put(token.substring(0, idx), token.substring(idx + 1));
        }
        return properties;
    }
}

