/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui;

import com.perforce.p4java.server.PerforceCharsets;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.Messages;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.PerforceUIPlugin;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.UIJob;

public final class P4UIUtils {
    public static final String DEFAULT_TEXT_EDITOR = "org.eclipse.ui.DefaultTextEditor";
    public static final String EMPTY = "";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yy hh:mm aaa");
    public static final int VIEWER_HEIGHT_HINT = 80;

    private P4UIUtils() {
    }

    public static void addStandardPerforceMenus(IMenuManager manager) {
        if (manager != null) {
            manager.add((IContributionItem)new Separator("perforce.group1"));
            manager.add((IContributionItem)new Separator("perforce.group2"));
            manager.add((IContributionItem)new Separator("perforce.group3"));
            manager.add((IContributionItem)new Separator("perforce.group4"));
            manager.add((IContributionItem)new Separator("perforce.group5"));
            manager.add((IContributionItem)new Separator("additions"));
        }
    }

    public static SelectionListener createComboSelectionListener(final Runnable runnable) {
        SelectionAdapter listener = null;
        if (runnable != null) {
            listener = !P4CoreUtils.isCocoa() ? new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    runnable.run();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            } : new SelectionAdapter(){
                private boolean ignore = false;
                private boolean enter = false;
                private String lastText = "";

                private void runRunnable() {
                    try {
                        this.ignore = true;
                        runnable.run();
                    }
                    finally {
                        this.ignore = false;
                    }
                }

                public void widgetSelected(SelectionEvent e) {
                    if (e != null) {
                        Combo c;
                        if (!this.ignore && e.widget instanceof Combo && (c = (Combo)e.widget).isEnabled()) {
                            if (this.enter) {
                                this.runRunnable();
                            } else {
                                String text = c.getText();
                                if (!this.lastText.equals(text)) {
                                    this.runRunnable();
                                    this.lastText = text;
                                }
                            }
                        }
                    } else {
                        runnable.run();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    try {
                        this.enter = true;
                        this.widgetSelected(e);
                    }
                    finally {
                        this.enter = false;
                    }
                }
            };
        }
        return listener;
    }

    public static TextSourceViewerConfiguration createSourceViewerConfiguration(final Object target) {
        IAdaptable adaptable = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                return Platform.getAdapterManager().getAdapter(target, adapter);
            }
        };
        return P4UIUtils.createSourceViewerConfiguration(adaptable);
    }

    public static TextSourceViewerConfiguration createSourceViewerConfiguration(final IAdaptable adaptable) {
        return new TextSourceViewerConfiguration(EditorsUI.getPreferenceStore()){

            protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
                Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
                if (targets != null) {
                    targets.put(P4UIUtils.DEFAULT_TEXT_EDITOR, adaptable);
                }
                return targets;
            }
        };
    }

    public static void syncMovedFile(ICheckable viewer, Object element, boolean checked) {
        IP4File pair;
        String moved;
        IP4File file;
        if (viewer != null && element != null && (file = (IP4File)P4CoreUtils.convert((Object)element, IP4File.class)) != null && (moved = file.getMovedFile()) != null && (pair = file.getConnection().getFile(moved)) != null) {
            viewer.setChecked((Object)pair, checked);
        }
    }

    public static void trackMovedFiles(final ICheckable viewer) {
        if (viewer != null) {
            Object[] checkedElements = null;
            if (viewer instanceof CheckboxTreeViewer) {
                checkedElements = ((CheckboxTreeViewer)viewer).getCheckedElements();
            } else if (viewer instanceof CheckboxTableViewer) {
                checkedElements = ((CheckboxTableViewer)viewer).getCheckedElements();
            }
            if (checkedElements != null) {
                Object[] objectArray = checkedElements;
                int n = checkedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    P4UIUtils.syncMovedFile(viewer, element, true);
                    ++n2;
                }
            }
            viewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    P4UIUtils.syncMovedFile(viewer, event.getElement(), event.getChecked());
                }
            });
        }
    }

    public static int computePixelHeight(Font font, int numRows) {
        int height = -1;
        GC gc = new GC((Drawable)P4UIUtils.getDisplay());
        if (font != null) {
            gc.setFont(font);
        }
        try {
            FontMetrics metrics = gc.getFontMetrics();
            height = metrics.getHeight() * numRows;
        }
        finally {
            gc.dispose();
        }
        return height;
    }

    public static int computePixelWidth(Font font, int numColumns) {
        int height = -1;
        GC gc = new GC((Drawable)P4UIUtils.getDisplay());
        if (font != null) {
            gc.setFont(font);
        }
        try {
            FontMetrics metrics = gc.getFontMetrics();
            height = metrics.getAverageCharWidth() * numColumns;
        }
        finally {
            gc.dispose();
        }
        return height;
    }

    public static ImageDescriptor getImageDescriptor(String filename) {
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(filename);
    }

    public static String getDateText(long timestamp) {
        return DateFormat.getDateTimeInstance().format(new Date(timestamp));
    }

    public static Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public static Shell getShell() {
        return P4UIUtils.getDisplay().getActiveShell();
    }

    public static Shell getDialogShell() {
        IWorkbenchWindow win = PerforceUIPlugin.getActiveWorkbenchWindow();
        if (win != null) {
            return win.getShell();
        }
        return null;
    }

    public static String[] getDisplayCharsets() {
        ArrayList<String> charsets = new ArrayList<String>();
        String[] stringArray = PerforceCharsets.getKnownCharsets();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String p4Charset = stringArray[n2];
            String display = P4UIUtils.getDisplayCharset(p4Charset);
            if (display != null) {
                charsets.add(display);
            }
            ++n2;
        }
        return charsets.toArray(new String[0]);
    }

    public static String getP4Charset(String displayCharset) {
        String p4Charset = null;
        if (displayCharset != null) {
            int index = displayCharset.indexOf(" (");
            p4Charset = index != -1 ? displayCharset.substring(0, index) : displayCharset;
        }
        return p4Charset;
    }

    public static String getDisplayCharset(String p4Charset) {
        String javaCharset;
        String displayCharset = null;
        if (p4Charset != null && (javaCharset = PerforceCharsets.getJavaCharsetName((String)p4Charset)) != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(p4Charset);
            if (!p4Charset.equals(javaCharset)) {
                builder.append(" (");
                builder.append(javaCharset);
                builder.append(')');
            }
            displayCharset = builder.toString();
        }
        return displayCharset;
    }

    public static PreferenceDialog openPreferencePage(String pageId, boolean block) {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)P4UIUtils.getShell(), (String)pageId, (String[])new String[]{pageId}, null);
        if (dialog != null) {
            dialog.setBlockOnOpen(block);
            dialog.open();
        }
        return dialog;
    }

    public static void openPreferencePage(String pageId) {
        P4UIUtils.openPreferencePage(pageId, true);
    }

    public static PreferenceDialog openPropertyPage(String pageId, IAdaptable element, boolean block) {
        return P4UIUtils.openPropertyPage(pageId, element, block, true);
    }

    public static PreferenceDialog openPropertyPage(String pageId, IAdaptable element, boolean block, boolean filter) {
        PreferenceDialog dialog;
        String[] filterIds = null;
        if (filter) {
            filterIds = new String[]{pageId};
        }
        if ((dialog = PreferencesUtil.createPropertyDialogOn((Shell)P4UIUtils.getShell(), (IAdaptable)element, (String)pageId, filterIds, null)) != null) {
            dialog.setBlockOnOpen(block);
            dialog.open();
        }
        return dialog;
    }

    public static void openPropertyPage(String pageId, IAdaptable element) {
        P4UIUtils.openPropertyPage(pageId, element, true);
    }

    public static IEditorDescriptor getDescriptor(String name, IContentType type) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(name, type);
        if (descriptor == null && registry.isSystemInPlaceEditorAvailable(name)) {
            descriptor = registry.findEditor("org.eclipse.ui.systemInPlaceEditor");
        }
        if (descriptor == null && registry.isSystemExternalEditorAvailable(name)) {
            descriptor = registry.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if (descriptor == null) {
            descriptor = P4UIUtils.getDefaultTextDescriptor();
        }
        return descriptor;
    }

    public static IEditorDescriptor getDefaultTextDescriptor() {
        return PlatformUI.getWorkbench().getEditorRegistry().findEditor(DEFAULT_TEXT_EDITOR);
    }

    public static IContentType getContentType(IStorage storage) {
        IContentType type = null;
        if (storage != null) {
            try {
                type = P4UIUtils.getStorageType(storage);
            }
            catch (IOException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            catch (CoreException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        return type;
    }

    private static void showOpenError(Exception exception) {
        P4ConnectionManager.getManager().openError(P4UIUtils.getShell(), Messages.P4UIUtils_ErrorOpeningEditor, exception.getMessage());
    }

    private static void scheduleShowOpenError(final Exception exception) {
        UIJob errorJob = new UIJob(Messages.P4UIUtils_DisplayingPerforceError){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                P4UIUtils.showOpenError(exception);
                return Status.OK_STATUS;
            }
        };
        errorJob.schedule();
    }

    private static IEditorPart openEditor(IEditorInput input, IEditorDescriptor descriptor) throws PartInitException {
        IWorkbenchPage page = PerforceUIPlugin.getActivePage();
        return IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)descriptor.getId());
    }

    private static IContentType getStorageType(IStorage storage) throws IOException, CoreException {
        return Platform.getContentTypeManager().findContentTypeFor(storage.getContents(), storage.getName());
    }

    private static void forceOpenEditor(IEditorInput input, IEditorDescriptor descriptor, IPartListener callback) {
        block8: {
            if (descriptor != null) {
                try {
                    IEditorPart part = P4UIUtils.openEditor(input, descriptor);
                    if (part != null && callback != null) {
                        callback.partActivated((IWorkbenchPart)part);
                    }
                }
                catch (PartInitException e) {
                    boolean show = true;
                    if (!DEFAULT_TEXT_EDITOR.equals(descriptor.getId()) && (descriptor = P4UIUtils.getDefaultTextDescriptor()) != null) {
                        try {
                            IEditorPart part = P4UIUtils.openEditor(input, descriptor);
                            if (part != null && callback != null) {
                                callback.partActivated((IWorkbenchPart)part);
                            }
                            show = false;
                        }
                        catch (PartInitException e1) {
                            show = true;
                        }
                    }
                    if (!show) break block8;
                    P4UIUtils.showOpenError((Exception)((Object)e));
                }
            }
        }
    }

    private static boolean openExisting(final IStorageEditorInput input, final IPartListener listener) {
        final boolean[] opened = new boolean[1];
        PerforceUIPlugin.syncExec(new Runnable(){

            @Override
            public void run() {
                IEditorPart existing;
                IWorkbenchPage page = PerforceUIPlugin.getActivePage();
                if (page != null && (existing = page.findEditor((IEditorInput)input)) != null) {
                    opened[0] = true;
                    page.bringToTop((IWorkbenchPart)existing);
                    if (listener != null) {
                        listener.partActivated((IWorkbenchPart)existing);
                    }
                }
            }
        });
        return opened[0];
    }

    public static void openEditor(final IStorageEditorInput input, final IPartListener listener) {
        if (input != null) {
            if (P4UIUtils.openExisting(input, listener)) {
                return;
            }
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    Throwable exception = null;
                    try {
                        final IStorage storage = input.getStorage();
                        if (storage != null) {
                            final IContentType type = P4UIUtils.getStorageType(storage);
                            UIJob openJob = new UIJob(Messages.P4UIUtils_OpeningEditor){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    IEditorDescriptor descriptor = P4UIUtils.getDescriptor(storage.getName(), type);
                                    P4UIUtils.forceOpenEditor((IEditorInput)input, descriptor, listener);
                                    return Status.OK_STATUS;
                                }
                            };
                            openJob.schedule();
                        }
                    }
                    catch (CoreException e) {
                        exception = e;
                    }
                    catch (IOException e) {
                        exception = e;
                    }
                    if (exception != null) {
                        P4UIUtils.scheduleShowOpenError((Exception)exception);
                    }
                }

                public String getTitle() {
                    return MessageFormat.format(Messages.P4UIUtils_FindingContentType, input.getName());
                }
            };
            P4Runner.schedule((IP4Runnable)runnable);
        }
    }

    public static void openEditor(IStorageEditorInput input) {
        P4UIUtils.openEditor(input, null);
    }

    public static String formatDate(long time) {
        Date date = new Date(time);
        return DateFormat.getDateTimeInstance(0, 2).format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatLabelDate(Date date) {
        if (date != null) {
            SimpleDateFormat simpleDateFormat = DATE_FORMAT;
            synchronized (simpleDateFormat) {
                return DATE_FORMAT.format(date);
            }
        }
        return EMPTY;
    }

    public static String formatLabelDate(long date) {
        return P4UIUtils.formatLabelDate(new Date(date));
    }

    public static void registerDisposal(Widget disposer, final Resource disposee) {
        if (disposee != null && disposer != null) {
            disposer.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (!disposee.isDisposed()) {
                        disposee.dispose();
                    }
                }
            });
        }
    }

    public static void copyToClipboard(String contents) {
        if (contents != null && contents.length() > 0) {
            Clipboard clipboard = new Clipboard(P4UIUtils.getDisplay());
            try {
                clipboard.setContents(new Object[]{contents}, new Transfer[]{TextTransfer.getInstance()});
            }
            finally {
                clipboard.dispose();
            }
        }
    }

    public static String pasteFromClipboard() {
        String contents = null;
        Clipboard clipboard = new Clipboard(P4UIUtils.getDisplay());
        try {
            contents = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
        }
        finally {
            clipboard.dispose();
        }
        if (contents == null) {
            contents = EMPTY;
        }
        return contents;
    }

    public static Font generateBoldFont(Device display, Font base) {
        Font bold = null;
        if (display != null && base != null) {
            FontData[] data = base.getFontData();
            FontData[] boldData = new FontData[data.length];
            int i = 0;
            while (i < data.length) {
                boldData[i] = new FontData(data[i].getName(), data[i].getHeight(), 1 | data[i].getStyle());
                ++i;
            }
            bold = new Font(display, boldData);
        }
        return bold;
    }

    public static boolean okToUse(Viewer viewer) {
        return viewer != null && P4UIUtils.okToUse((Widget)viewer.getControl());
    }

    public static boolean okToUse(Widget control) {
        return control != null && !control.isDisposed();
    }

    public static ImageDescriptor getImageDescriptor(Object element) {
        IWorkbenchAdapter workbenchAdapter;
        ImageDescriptor descriptor = null;
        if (element != null && (workbenchAdapter = (IWorkbenchAdapter)P4CoreUtils.convert((Object)element, IWorkbenchAdapter.class)) != null) {
            descriptor = workbenchAdapter.getImageDescriptor(element);
        }
        return descriptor;
    }

    public static void addIndentToAltRoots(String[] altRoots) {
        String WHITESPACE = " ";
        int i = 0;
        while (i < altRoots.length) {
            if (!altRoots[i].startsWith(" ")) {
                altRoots[i] = " " + altRoots[i];
            }
            ++i;
        }
    }

    public static String validateName(String name, String object) {
        String error = null;
        if (name.isEmpty()) {
            error = MessageFormat.format(Messages.P4UIUtils_NameMustNotEmpty, object);
        } else if (name.contains("@") || name.contains("#")) {
            error = MessageFormat.format(Messages.P4UIUtils_RevisionCharacterNotAllowedInName, object.toLowerCase());
        } else if (name.contains("\"")) {
            error = MessageFormat.format(Messages.P4UIUtils_QuoteCharNotAllowedInName, object.toLowerCase());
        } else if (name.contains(" ")) {
            error = MessageFormat.format(Messages.P4UIUtils_SpaceNotAllowedInName, object.toLowerCase());
        }
        return error;
    }
}

