/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui;

import com.perforce.p4java.exception.TrustException;
import com.perforce.team.ui.Messages;
import com.perforce.team.ui.dialogs.DialogUtils;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class P4TrustDialog
extends MessageDialog {
    static final int CANCEL = 0;
    static final int CONNECT = 1;
    String msgRed = null;
    String msgBold = null;
    String trustLabel = null;

    P4TrustDialog(Shell shell, String serverHostPort, String serverIpPort, String fingerprint, TrustException.Type type) {
        super(shell, Messages.P4TrustDialog_TrustError, null, "", 4, P4TrustDialog.options(), 1);
        if (type == TrustException.Type.NEW_CONNECTION) {
            this.msgBold = MessageFormat.format(Messages.P4TrustDialog_NewConnectionMessage, serverHostPort, serverIpPort);
            this.trustLabel = Messages.P4TrustDialog_TrustNewFingerprint;
        } else if (type == TrustException.Type.NEW_KEY) {
            this.msgRed = Messages.P4TrustDialog_InterceptWarning;
            this.msgBold = MessageFormat.format(Messages.P4TrustDialog_NewKeyMessage, serverHostPort, serverIpPort);
            this.trustLabel = Messages.P4TrustDialog_TrustChangedFingerprint;
        }
        this.message = MessageFormat.format(Messages.P4TrustDialog_FingerprintMessage, fingerprint);
    }

    static String[] options() {
        return new String[]{IDialogConstants.CANCEL_LABEL, Messages.P4TrustDialog_Connect};
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            this.imageLabel.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent event) {
                    event.result = JFaceResources.getString((String)"warning");
                }
            });
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        }
        Composite rightArea = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        rightArea.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)rightArea);
        if (this.msgRed != null) {
            Label redMessageLabel = new Label(rightArea, this.getMessageLabelStyle());
            redMessageLabel.setText(this.msgRed);
            redMessageLabel.setForeground(new Color((Device)this.getShell().getDisplay(), 255, 0, 0));
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)redMessageLabel);
        }
        Label boldMessageLabel = new Label(rightArea, this.getMessageLabelStyle());
        boldMessageLabel.setText(this.msgBold);
        FontData[] fd = boldMessageLabel.getFont().getFontData();
        fd[0].setStyle(1);
        boldMessageLabel.setFont(new Font((Device)this.getShell().getDisplay(), fd[0]));
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)boldMessageLabel);
        if (this.message != null) {
            this.messageLabel = new Label(rightArea, this.getMessageLabelStyle());
            this.messageLabel.setText(this.message);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.messageLabel);
        }
        final Button trustButton = DialogUtils.createCheck(rightArea, this.trustLabel);
        trustButton.setSelection(false);
        trustButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                P4TrustDialog.this.getButton(1).setEnabled(trustButton.getSelection());
            }
        });
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)trustButton);
        return composite;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        this.getShell().setDefaultButton(this.getButton(0));
        this.getButton(1).setEnabled(false);
    }
}

