/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui;

import com.perforce.p4java.core.file.FileAction;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.ui.Messages;
import com.perforce.team.ui.P4UIUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class P4FilePropertySource
implements IPropertySource {
    private static final List<IPropertyDescriptor> CORE_DESCRIPTORS = new ArrayList<IPropertyDescriptor>();
    private static final String DEPOT_PATH = "DEPOT_PATH";
    private static final String HAVE_REV = "HAVE_REV";
    private static final String HEAD_REV = "HEAD_REV";
    private static final String FILE_TYPE = "FILE_TYPE";
    private static final String HEAD_ACTION = "HEAD_ACTION";
    private static final String CLIENT_PATH = "CLIENT_PATH";
    private static final String MOD_TIME = "MOD_TIME";
    private static final String OTHER_USER = "OTHER_USER";
    private static final String OTHER_CHANGELIST = "OTHER_CHANGELIST";
    private static final String OTHER_CLIENT = "OTHER_CLIENT";
    private static final String OTHER_ACTION = "OTHER_ACTION";
    private static final String SERVER = "SERVER";
    private IP4File file;
    private IP4File[] openedFiles = null;

    static {
        CORE_DESCRIPTORS.add((IPropertyDescriptor)new PropertyDescriptor((Object)CLIENT_PATH, Messages.P4FilePropertySource_WorkspaceLocation));
        CORE_DESCRIPTORS.add((IPropertyDescriptor)new PropertyDescriptor((Object)DEPOT_PATH, Messages.P4FilePropertySource_DepotLocation));
        CORE_DESCRIPTORS.add((IPropertyDescriptor)new PropertyDescriptor((Object)HAVE_REV, Messages.P4FilePropertySource_HaveRevision));
        CORE_DESCRIPTORS.add((IPropertyDescriptor)new PropertyDescriptor((Object)HEAD_REV, Messages.P4FilePropertySource_HeadRevision));
        CORE_DESCRIPTORS.add((IPropertyDescriptor)new PropertyDescriptor((Object)MOD_TIME, Messages.P4FilePropertySource_LastChanged));
        CORE_DESCRIPTORS.add((IPropertyDescriptor)new PropertyDescriptor((Object)FILE_TYPE, Messages.P4FilePropertySource_FileType));
        CORE_DESCRIPTORS.add((IPropertyDescriptor)new PropertyDescriptor((Object)HEAD_ACTION, Messages.P4FilePropertySource_HeadAction));
        CORE_DESCRIPTORS.add((IPropertyDescriptor)new PropertyDescriptor((Object)SERVER, Messages.P4FilePropertySource_ServerAddress));
    }

    public P4FilePropertySource(IP4File file) {
        this.file = file;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        String path;
        IP4Connection connection;
        ArrayList<IPropertyDescriptor> fileDescriptors = new ArrayList<IPropertyDescriptor>(CORE_DESCRIPTORS);
        if (this.file.openedElsewhere() && (connection = this.file.getConnection()) != null && (path = this.file.getActionPath()) != null) {
            this.openedFiles = connection.getOpenedBy(path);
            int totalOpened = this.openedFiles == null ? 0 : this.openedFiles.length;
            int i = 0;
            while (i < totalOpened) {
                int marker = i + 1;
                String category = String.valueOf(Messages.P4FilePropertySource_CheckedOutByUser) + marker;
                PropertyDescriptor clientDescriptor = new PropertyDescriptor((Object)(OTHER_CLIENT + i), String.valueOf(Messages.P4FilePropertySource_Client) + marker);
                clientDescriptor.setCategory(category);
                fileDescriptors.add((IPropertyDescriptor)clientDescriptor);
                PropertyDescriptor userDescriptor = new PropertyDescriptor((Object)(OTHER_USER + i), String.valueOf(Messages.P4FilePropertySource_User) + marker);
                userDescriptor.setCategory(category);
                fileDescriptors.add((IPropertyDescriptor)userDescriptor);
                PropertyDescriptor clDescriptor = new PropertyDescriptor((Object)(OTHER_CHANGELIST + i), String.valueOf(Messages.P4FilePropertySource_PendingChangelist) + marker);
                clDescriptor.setCategory(category);
                fileDescriptors.add((IPropertyDescriptor)clDescriptor);
                FileAction fileAction = this.openedFiles[i].getAction();
                if (fileAction != null) {
                    PropertyDescriptor actionDescriptor = new PropertyDescriptor((Object)(OTHER_ACTION + i), String.valueOf(Messages.P4FilePropertySource_Action) + marker);
                    actionDescriptor.setCategory(category);
                    fileDescriptors.add((IPropertyDescriptor)actionDescriptor);
                }
                ++i;
            }
        }
        return fileDescriptors.toArray(new IPropertyDescriptor[0]);
    }

    public Object getPropertyValue(Object id) {
        String value = null;
        if (this.file != null) {
            if (HAVE_REV.equals(id)) {
                value = Integer.toString(this.file.getHaveRevision());
            } else if (HEAD_REV.equals(id)) {
                value = Integer.toString(this.file.getHeadRevision());
            } else if (FILE_TYPE.equals(id)) {
                value = this.file.getHeadType();
            } else if (DEPOT_PATH.equals(id)) {
                value = this.file.getRemotePath();
            } else if (HEAD_ACTION.equals(id)) {
                value = this.file.getHeadAction();
            } else if (MOD_TIME.equals(id)) {
                value = P4UIUtils.formatDate(this.file.getHeadTime());
            } else if (CLIENT_PATH.equals(id)) {
                value = this.file.getLocalPath();
            } else if (SERVER.equals(id)) {
                IP4Connection connection = this.file.getConnection();
                if (connection != null) {
                    value = connection.getAddress();
                }
            } else {
                String otherId = id.toString();
                if (otherId.startsWith(OTHER_USER)) {
                    int index = Integer.parseInt(otherId.substring(OTHER_USER.length()));
                    value = this.openedFiles[index].getUserName();
                } else if (otherId.startsWith(OTHER_CHANGELIST)) {
                    int index = Integer.parseInt(otherId.substring(OTHER_CHANGELIST.length()));
                    int changelist = this.openedFiles[index].getChangelistId();
                    value = changelist == 0 ? Messages.P4FilePropertySource_DefaultChangelistId : Integer.toString(changelist);
                } else if (otherId.startsWith(OTHER_CLIENT)) {
                    int index = Integer.parseInt(otherId.substring(OTHER_CLIENT.length()));
                    value = this.openedFiles[index].getClientName();
                } else if (otherId.startsWith(OTHER_ACTION)) {
                    int index = Integer.parseInt(otherId.substring(OTHER_ACTION.length()));
                    value = this.openedFiles[index].getAction().toString().toLowerCase();
                }
            }
        }
        return value;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

