/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui;

import com.perforce.team.ui.Messages;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class DatePicker {
    private ToolBar toolbar;
    private ToolItem item;
    private Combo combo;
    private Text text;

    public void setCombo(Combo combo) {
        this.combo = combo;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public void setVisible(boolean visible) {
        this.toolbar.setVisible(visible);
    }

    public void createControl(Composite parent) {
        this.toolbar = new ToolBar(parent, 0x800000);
        this.item = new ToolItem(this.toolbar, 8);
        Image showImage = PerforceUIPlugin.getDescriptor("normal/calendar.png").createImage();
        P4UIUtils.registerDisposal((Widget)this.item, (Resource)showImage);
        this.item.setImage(showImage);
        this.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle bounds = DatePicker.this.item.getBounds();
                Point location = DatePicker.this.toolbar.toDisplay(bounds.x, bounds.y + bounds.height);
                DateDialog dialog = new DateDialog(DatePicker.this.toolbar.getShell(), location);
                dialog.open();
            }
        });
    }

    class DateDialog
    extends PopupDialog {
        private Point location;
        private int year;
        private int month;
        private int day;
        private DateTime dateTime;

        public DateDialog(Shell parent, Point location) {
            super(parent, 0, true, false, false, false, false, "", "");
            this.location = location;
        }

        protected void adjustBounds() {
            this.getShell().setLocation(this.location);
        }

        public boolean close() {
            if (this.getReturnCode() == 0 && this.day > 0 && this.month > 0 && this.year > 0) {
                StringBuilder date = new StringBuilder();
                date.append(this.year);
                date.append('/');
                date.append(this.month);
                date.append('/');
                date.append(this.day);
                if (DatePicker.this.combo != null) {
                    DatePicker.this.combo.setText(date.toString());
                } else if (DatePicker.this.text != null) {
                    DatePicker.this.text.setText(date.toString());
                }
            }
            return super.close();
        }

        protected void updateValues() {
            this.year = this.dateTime.getYear();
            this.month = this.dateTime.getMonth() + 1;
            this.day = this.dateTime.getDay();
        }

        protected void setInitialValue() {
            String[] segments;
            String value = "";
            if (DatePicker.this.combo != null) {
                value = DatePicker.this.combo.getText().trim();
            } else if (DatePicker.this.text != null) {
                value = DatePicker.this.text.getText().trim();
            }
            if (value.length() > 0 && (segments = value.split("/")).length == 3) {
                try {
                    int parsedYear = Integer.parseInt(segments[0]);
                    int parsedMonth = Integer.parseInt(segments[1]);
                    int parsedDay = Integer.parseInt(segments[2]);
                    if (parsedYear > 0 && parsedMonth > 0 && parsedDay > 0) {
                        this.dateTime.setYear(parsedYear);
                        this.dateTime.setMonth(parsedMonth - 1);
                        this.dateTime.setDay(parsedDay);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.dateTime = new DateTime(composite, 1024);
            this.setInitialValue();
            this.dateTime.setLayoutData((Object)new GridData(4, 4, true, true));
            this.dateTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DateDialog.this.updateValues();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    DateDialog.this.updateValues();
                    DateDialog.this.close();
                }
            });
            Link link = new Link(composite, 0);
            link.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
            link.setText(Messages.DatePicker_CloseLink);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DateDialog.this.updateValues();
                    DateDialog.this.close();
                }
            });
            return composite;
        }
    }
}

