/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui;

import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class BaseTableSorter
extends ViewerSorter {
    public static final int ASCENDING = 1;
    public static final int DESCENDING = -1;
    protected String sortCol;
    protected int direction;
    private StructuredViewer viewer = null;
    private Table table = null;
    private Tree tree = null;

    public BaseTableSorter(Table table, String sortCol) {
        this.sortCol = sortCol;
        this.direction = -1;
        this.table = table;
    }

    public BaseTableSorter(Tree tree, String sortCol) {
        this.sortCol = sortCol;
        this.direction = -1;
        this.tree = tree;
    }

    public BaseTableSorter(TableViewer table, String sortCol) {
        this.sortCol = sortCol;
        this.direction = -1;
        this.viewer = table;
        this.table = table.getTable();
    }

    public BaseTableSorter(TreeViewer tree, String sortCol) {
        this.sortCol = sortCol;
        this.direction = -1;
        this.viewer = tree;
        this.tree = tree.getTree();
    }

    public void addColumnListeners() {
        block3: {
            block2: {
                if (this.tree == null) break block2;
                SelectionAdapter headerListener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TreeColumn column = (TreeColumn)e.widget;
                        BaseTableSorter.this.setSortColumn(column.getText());
                        if (BaseTableSorter.this.viewer != null) {
                            BaseTableSorter.this.viewer.refresh();
                        }
                    }
                };
                TreeColumn[] treeColumnArray = this.tree.getColumns();
                int n = treeColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeColumn column = treeColumnArray[n2];
                    column.addSelectionListener((SelectionListener)headerListener);
                    ++n2;
                }
                break block3;
            }
            if (this.table == null) break block3;
            SelectionAdapter headerListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableColumn column = (TableColumn)e.widget;
                    BaseTableSorter.this.setSortColumn(column.getText());
                    if (BaseTableSorter.this.viewer != null) {
                        BaseTableSorter.this.viewer.refresh();
                    }
                }
            };
            TableColumn[] tableColumnArray = this.table.getColumns();
            int n = tableColumnArray.length;
            int n3 = 0;
            while (n3 < n) {
                TableColumn column = tableColumnArray[n3];
                column.addSelectionListener((SelectionListener)headerListener);
                ++n3;
            }
        }
    }

    public void setSortColumn(TableColumn column, int direction) {
        if (this.table != null) {
            this.table.setSortColumn(column);
            this.table.setSortDirection(direction);
        }
    }

    public void setSortColumn(TreeColumn column, int direction) {
        if (this.tree != null) {
            this.tree.setSortColumn(column);
            this.tree.setSortDirection(direction);
        }
    }

    protected Object getField(Object field, String column) {
        return field.toString();
    }

    public void init(TableColumn sortColumn, SelectionListener listener, int direction) {
        if (listener != null) {
            TableColumn[] tableColumnArray = this.table.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                column.addSelectionListener(listener);
                ++n2;
            }
        }
        this.table.setSortColumn(sortColumn);
        this.table.setSortDirection(direction);
    }

    public void init(final TableViewer viewer, TableColumn sortColumn, int direction) {
        SelectionAdapter headerListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableColumn column = (TableColumn)e.widget;
                BaseTableSorter.this.setSortColumn(column.getText());
                viewer.refresh();
            }
        };
        this.init(sortColumn, (SelectionListener)headerListener, direction);
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        Object field1 = this.getField(e1, this.sortCol);
        Object field2 = this.getField(e2, this.sortCol);
        int result = 0;
        if (field1 instanceof Comparable && field2 instanceof Comparable) {
            result = ((Comparable)field1).compareTo(field2);
        } else {
            field1 = field1 != null ? field1.toString() : "";
            field2 = field2 != null ? field2.toString() : "";
            result = super.compare(viewer, field1, field2);
        }
        return result * this.direction;
    }

    public void setAscending() {
        this.direction = 1;
    }

    public void setDescending() {
        this.direction = -1;
    }

    public void setSortColumn(String col) {
        if (this.sortCol.equals(col)) {
            this.direction = this.direction == -1 ? 1 : -1;
        } else {
            this.sortCol = col;
            this.direction = -1;
        }
        if (col != null) {
            int sortDirection;
            int n = sortDirection = this.direction == 1 ? 128 : 1024;
            if (this.table != null) {
                TableColumn[] tableColumnArray = this.table.getColumns();
                int n2 = tableColumnArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    TableColumn column = tableColumnArray[n3];
                    if (col.equals(column.getText())) {
                        this.table.setSortColumn(column);
                        break;
                    }
                    ++n3;
                }
                this.table.setSortDirection(sortDirection);
            } else if (this.tree != null) {
                TreeColumn[] treeColumnArray = this.tree.getColumns();
                int n4 = treeColumnArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    TreeColumn column = treeColumnArray[n5];
                    if (col.equals(column.getText())) {
                        this.tree.setSortColumn(column);
                        break;
                    }
                    ++n5;
                }
                this.tree.setSortDirection(sortDirection);
            }
        }
    }
}

