/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.PerforceUIPlugin;
import java.util.Collection;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public abstract class BaseHyperlinkDetector
extends AbstractHyperlinkDetector {
    protected abstract Collection<IHyperlink> generateHyperlinks(String var1, int var2, int var3);

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (textViewer == null || region == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        if (document == null || document.getLength() == 0 || region.getOffset() >= document.getLength()) {
            return null;
        }
        try {
            int regionOffset;
            String value;
            Collection<IHyperlink> links;
            IRegion lineRegion;
            int positionOffset = -1;
            if (region.getLength() == 0 && (lineRegion = document.getLineInformationOfOffset(region.getOffset())) != null) {
                positionOffset = region.getOffset() - lineRegion.getOffset();
                region = lineRegion;
            }
            if ((links = this.generateHyperlinks(value = document.get(regionOffset = region.getOffset(), region.getLength()), regionOffset, positionOffset)) != null && !links.isEmpty()) {
                return links.toArray(new IHyperlink[links.size()]);
            }
        }
        catch (BadLocationException e) {
            return null;
        }
        return null;
    }

    protected boolean accept(int offset, int start, int length) {
        return offset < 0 || offset >= start && offset <= start + length;
    }

    protected IP4Connection getResourceConnection(Object object) {
        IResource resource = (IResource)P4CoreUtils.convert((Object)object, IResource.class);
        if (resource != null) {
            return P4ConnectionManager.getManager().getConnection(resource.getProject(), false);
        }
        return null;
    }

    protected IEditorInput getActiveEditorInput() {
        IWorkbenchPart part;
        IWorkbenchPage page = PerforceUIPlugin.getActivePage();
        if (page != null && (part = page.getActivePart()) instanceof IEditorPart) {
            return ((IEditorPart)part).getEditorInput();
        }
        return null;
    }

    protected IP4Connection getConnection() {
        Object adapted;
        IEditorInput input;
        IP4Connection[] connections = P4ConnectionManager.getManager().getConnections();
        if (connections.length == 1) {
            return connections[0];
        }
        IP4Connection connection = null;
        Object resource = this.getAdapter(IResource.class);
        connection = this.getResourceConnection(resource);
        if (connection == null && (resource = this.getAdapter(IP4Resource.class)) instanceof IP4Resource) {
            connection = ((IP4Resource)resource).getConnection();
        }
        if (connection == null && (input = this.getActiveEditorInput()) != null && (connection = this.getResourceConnection(resource = input.getAdapter(IResource.class))) == null && (adapted = Platform.getAdapterManager().getAdapter((Object)input, IP4Connection.class)) instanceof IP4Connection) {
            connection = (IP4Connection)adapted;
        }
        return connection;
    }
}

