/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java.synchronize;

import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.core.p4java.synchronize.IP4ChangeSet;
import com.perforce.team.core.p4java.synchronize.Messages;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.osgi.service.prefs.Preferences;

public class P4PendingChangeSet
extends ActiveChangeSet
implements IP4ChangeSet {
    public static final int PENDING_PRIORITY = 2;
    public static final String CTX_LOCAL_NAME = "localName";
    public static final String CTX_CONNECTION = "connection";
    public static final String CTX_CHANGELIST = "changelist";
    public static final String CTX_SAVED_COMMENT = "savedComment";
    protected IP4PendingChangelist list;
    protected int id = -1;
    protected boolean valid = true;

    public P4PendingChangeSet(ActiveChangeSetManager manager, String name) {
        super(manager, name);
    }

    public P4PendingChangeSet(ActiveChangeSetManager manager, IP4PendingChangelist list) {
        this(manager, (String)null);
        this.list = list;
        if (this.list != null) {
            this.id = this.list.getId();
        }
        this.updateTitle();
    }

    public boolean isUserCreated() {
        return true;
    }

    @Override
    public IP4Connection getConnection() {
        return this.list != null ? this.list.getConnection() : null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof P4PendingChangeSet) {
            return this.list != null && this.list.equals(((P4PendingChangeSet)obj).list);
        }
        return false;
    }

    public int hashCode() {
        IP4Connection connection = this.getConnection();
        if (connection != null && this.id != -1) {
            return (String.valueOf(connection.getParameters().toString()) + this.id).hashCode();
        }
        return super.hashCode();
    }

    private IResource getResource(IDiff diff) {
        IPath path;
        IFile resource = null;
        if (diff != null && (path = diff.getPath()) != null) {
            resource = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        }
        return resource;
    }

    protected boolean isValidChange(IDiff diff) {
        boolean valid = super.isValidChange(diff);
        if (valid) {
            IP4File p4File;
            IP4Resource p4Resource;
            IP4Connection connection;
            valid = false;
            IResource resource = this.getResource(diff);
            if (resource instanceof IFile && (connection = P4Workspace.getWorkspace().getConnection(resource.getProject())) != null && (p4Resource = connection.getResource(resource)) instanceof IP4File && (p4File = (IP4File)p4Resource).isOpened() && p4File.openedByOwner()) {
                if (this.list == null) {
                    this.list = p4File.getChangelist(true, true);
                    if (this.list != null) {
                        valid = true;
                        this.id = this.list.getId();
                    }
                } else {
                    valid = this.list.equals(p4File.getChangelist(true, true));
                }
            }
        }
        return valid;
    }

    public void refresh() {
        this.updateTitle();
    }

    @Override
    public IP4PendingChangelist getChangelist() {
        return this.list;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void save(Preferences prefs) {
        if (prefs != null) {
            super.save(prefs);
            if (this.list != null) {
                String params = this.list.getConnection().getParameters().toString();
                prefs.put(CTX_CONNECTION, params);
                prefs.putInt(CTX_CHANGELIST, this.id);
            }
        }
    }

    @Override
    public String getComment() {
        if (this.list != null) {
            return this.list.getDescription();
        }
        return super.getComment();
    }

    protected void updateTitle() {
        if (this.list != null) {
            if (this.list.isDefault()) {
                this.setTitle(Messages.DefaultChange);
            } else {
                this.setTitle(MessageFormat.format(Messages.PendingChange, this.getId()));
            }
        }
    }

    public void init(Preferences prefs) {
        if (prefs != null) {
            String comment;
            super.init(prefs);
            String connectionPref = prefs.get(CTX_CONNECTION, null);
            int id = prefs.getInt(CTX_CHANGELIST, -1);
            if (connectionPref != null && id > 0) {
                ConnectionParameters params = new ConnectionParameters(connectionPref);
                if (P4Workspace.getWorkspace().containsConnection(params)) {
                    IP4Connection iP4Connection = P4Workspace.getWorkspace().getConnection(params);
                }
            }
            if ((comment = prefs.get(CTX_SAVED_COMMENT, null)) != null) {
                this.setComment(comment);
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public int getPriority() {
        return 2;
    }

    public boolean useCommentOnSubmit() {
        return false;
    }
}

