/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4Resource;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PendingResourceManager {
    private Map<Integer, Set<IP4Resource>> openedResources = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFile(int id, IP4File file) {
        boolean added = false;
        if (file != null && id >= 0 && file.isOpened()) {
            Map<Integer, Set<IP4Resource>> map = this.openedResources;
            synchronized (map) {
                Set<IP4Resource> files = this.openedResources.get(id);
                if (files == null) {
                    files = new HashSet<IP4Resource>();
                    this.openedResources.put(id, files);
                }
                files.remove(file);
                added = files.add(file);
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceResources(int id, Collection<IP4Resource> resources) {
        boolean added = false;
        if (resources != null && id >= 0) {
            Map<Integer, Set<IP4Resource>> map = this.openedResources;
            synchronized (map) {
                HashSet<IP4Resource> resourceSet = new HashSet<IP4Resource>();
                added = resourceSet.addAll(resources);
                this.openedResources.put(id, resourceSet);
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addJob(int id, IP4Job job) {
        boolean added = false;
        if (job != null && id >= 0) {
            Map<Integer, Set<IP4Resource>> map = this.openedResources;
            synchronized (map) {
                Set<IP4Resource> files = this.openedResources.get(id);
                if (files == null) {
                    files = new HashSet<IP4Resource>();
                    this.openedResources.put(id, files);
                }
                files.remove(job);
                added = files.add(job);
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(int id, IP4Resource resource) {
        boolean removed = false;
        if (resource != null && id >= 0) {
            Map<Integer, Set<IP4Resource>> map = this.openedResources;
            synchronized (map) {
                Set<IP4Resource> resources = this.openedResources.get(id);
                if (resources != null) {
                    removed = resources.remove(resource);
                }
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IP4Resource[] getResources(int id) {
        IP4Resource[] resources = IP4Resource.EMPTY;
        Map<Integer, Set<IP4Resource>> map = this.openedResources;
        synchronized (map) {
            Set<IP4Resource> files = this.openedResources.get(id);
            if (files != null) {
                resources = files.toArray(new IP4Resource[files.size()]);
            }
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize(int id) {
        int size = 0;
        Map<Integer, Set<IP4Resource>> map = this.openedResources;
        synchronized (map) {
            Set<IP4Resource> files = this.openedResources.get(id);
            if (files != null) {
                size = files.size();
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<Integer, Set<IP4Resource>> map = this.openedResources;
        synchronized (map) {
            this.openedResources.clear();
        }
    }
}

