/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.file.FilePath;
import com.perforce.p4java.server.IServer;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IErrorHandler;
import com.perforce.team.core.p4java.IEventObject;
import com.perforce.team.core.p4java.IP4ClientOperation;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.IP4ProgressListener;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4ServerOperation;
import com.perforce.team.core.p4java.P4Event;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.PlatformObject;

public abstract class P4Resource
extends PlatformObject
implements IP4Resource,
IEventObject {
    protected boolean readOnly = false;
    protected boolean needsRefresh = true;
    protected ListenerList listeners = new ListenerList();
    protected IErrorHandler errorHandler = null;

    public static String normalizeLocalPath(String localPath) {
        String normalized = null;
        if (localPath != null) {
            normalized = localPath.replace('/', File.separatorChar);
        }
        return normalized;
    }

    protected void runOperation(IP4ClientOperation operation) {
        if (operation != null) {
            boolean retry = true;
            IClient client = this.getClient();
            while (retry && client != null) {
                retry = false;
                try {
                    operation.run(client);
                }
                catch (P4JavaException exception) {
                    PerforceProviderPlugin.logError(exception);
                    operation.exception(exception);
                    retry = this.handleError(exception);
                    if (!retry) continue;
                    client = this.getClient();
                }
                catch (P4JavaError error) {
                    PerforceProviderPlugin.logError(error);
                }
            }
        }
    }

    protected void runOperation(IP4ServerOperation operation) {
        if (operation != null) {
            boolean retry = true;
            IServer server = this.getServer();
            while (retry && server != null) {
                retry = false;
                try {
                    operation.run(server);
                }
                catch (P4JavaException exception) {
                    PerforceProviderPlugin.logError(exception);
                    operation.exception(exception);
                    retry = this.handleError(exception);
                    if (!retry) continue;
                    server = this.getServer();
                }
                catch (P4JavaError error) {
                    PerforceProviderPlugin.logError(error);
                }
            }
        }
    }

    @Override
    public void markForRefresh() {
        this.needsRefresh = true;
    }

    @Override
    public boolean needsRefresh() {
        return this.needsRefresh;
    }

    @Override
    public IServer getServer() {
        IP4Connection connection = this.getConnection();
        if (connection != null) {
            return connection.getServer();
        }
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public static String normalizeLocalPath(IFileSpec spec) {
        String localPath = null;
        if (spec != null) {
            String clientOrLocalPath;
            FilePath filePath = spec.getLocalPath();
            String string = clientOrLocalPath = filePath != null ? filePath.getPathString() : null;
            if (clientOrLocalPath == null) {
                filePath = spec.getClientPath();
                String string2 = clientOrLocalPath = filePath != null ? filePath.getPathString() : null;
            }
            if (clientOrLocalPath != null) {
                if (clientOrLocalPath.startsWith("//")) {
                    String root = spec.getClientName();
                    if (root != null) {
                        localPath = P4Resource.getPathHostSyntax(root, clientOrLocalPath);
                    } else {
                        localPath = P4Resource.normalizeLocalPath(clientOrLocalPath);
                        localPath = P4Resource.unformatFilename(localPath);
                    }
                } else {
                    localPath = P4Resource.normalizeLocalPath(clientOrLocalPath);
                }
            }
        }
        return localPath;
    }

    public static String unformatFilename(String filename) {
        if (filename != null && filename.indexOf(37) > -1) {
            StringBuilder buff = new StringBuilder(filename.length());
            int start = 0;
            while (true) {
                int end;
                if ((end = filename.indexOf(37, start)) == -1) break;
                buff.append(filename.substring(start, end));
                String fch = filename.substring(end, end + 3);
                if (fch.equals("%40")) {
                    buff.append('@');
                } else if (fch.equals("%23")) {
                    buff.append('#');
                } else if (fch.equals("%25")) {
                    buff.append('%');
                } else if (fch.equals("%2A")) {
                    buff.append('*');
                }
                start = end + 3;
            }
            buff.append(filename.substring(start));
            filename = buff.toString();
        }
        return filename;
    }

    public static String getPathHostSyntax(String root, String path) {
        if (path != null && root != null) {
            int idx = path.indexOf(47, 2);
            if (root.toLowerCase().equals("null")) {
                path = path.substring(idx + 1);
            } else if (root.endsWith("\\") || root.endsWith("/")) {
                path = String.valueOf(root) + path.substring(idx + 1);
            } else if (idx > 0) {
                path = String.valueOf(root) + path.substring(idx);
            }
            path = path.replace('/', File.separatorChar);
            path = P4Resource.unformatFilename(path);
        }
        return path;
    }

    @Override
    public IErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    protected String getLocalResourcePath(String clientOrLocalPath) {
        String localPath = null;
        if (clientOrLocalPath != null) {
            localPath = clientOrLocalPath.startsWith("//") ? this.getPathHostSyntax(clientOrLocalPath) : P4Resource.normalizeLocalPath(clientOrLocalPath);
        }
        return localPath;
    }

    protected String getPathHostSyntax(String path) {
        IClient client = this.getClient();
        if (client != null) {
            String root = client.getRoot();
            path = P4Resource.getPathHostSyntax(root, path);
        }
        return path;
    }

    @Override
    public void setErrorHandler(IErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public void addListener(IP4Listener listener) {
        if (listener != null) {
            this.listeners.add((Object)listener);
        }
    }

    @Override
    public void addListeners(IP4Listener[] listeners) {
        if (listeners != null) {
            IP4Listener[] iP4ListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Listener listener = iP4ListenerArray[n2];
                this.addListener(listener);
                ++n2;
            }
        }
    }

    @Override
    public void clearListeners() {
        this.listeners.clear();
    }

    @Override
    public void notifyListeners(P4Event event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((IP4Listener)listener).resoureChanged(event);
            }
            catch (Exception e) {
                PerforceProviderPlugin.logError(e);
            }
            catch (Error e) {
                PerforceProviderPlugin.logError(e);
            }
            ++n2;
        }
    }

    @Override
    public void removeListener(IP4Listener listener) {
        if (listener != null) {
            this.listeners.remove((Object)listener);
        }
    }

    protected boolean connectionEquals(IP4Resource other) {
        IP4Connection connection = this.getConnection();
        IP4Connection otherConnection = null;
        if (other != null) {
            otherConnection = other.getConnection();
        }
        return connection != null && connection.equals(otherConnection);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IP4Resource) {
            IP4Resource resource = (IP4Resource)obj;
            if (!this.connectionEquals(resource)) {
                return false;
            }
            if (this.getRemotePath() != null && resource.getRemotePath() != null) {
                return this.getRemotePath().equals(resource.getRemotePath());
            }
            if (this.getClientPath() != null && resource.getClientPath() != null) {
                return this.getClientPath().equals(resource.getClientPath());
            }
            if (this.getLocalPath() != null && resource.getLocalPath() != null) {
                return this.getLocalPath().equals(resource.getLocalPath());
            }
        }
        return false;
    }

    public int hashCode() {
        String path = this.getLocalPath();
        if (path == null) {
            path = this.getRemotePath();
        }
        if (path == null) {
            path = this.getClientPath();
        }
        int hash = path != null ? path.hashCode() : super.hashCode();
        return hash;
    }

    @Override
    public void add() {
        this.add(0);
    }

    @Override
    public void add(int changelist) {
    }

    @Override
    public void delete() {
        this.delete(0);
    }

    @Override
    public void delete(int changelist) {
    }

    @Override
    public void edit() {
        this.edit(0);
    }

    @Override
    public void edit(int changelist) {
    }

    @Override
    public void ignore() {
    }

    @Override
    public void revert(boolean wipeAddFiles) {
    }

    @Override
    public void revert() {
    }

    @Override
    public void sync(IProgressMonitor monitor, IP4ProgressListener callback) {
    }

    @Override
    public void sync(IProgressMonitor monitor) {
        this.sync(monitor, null);
    }

    @Override
    public boolean handleError(P4JavaException exception) {
        boolean retry = false;
        IP4Connection connection = this.getConnection();
        if (this.errorHandler != null) {
            retry = this.errorHandler.shouldRetry(connection, exception);
        } else if (connection != null) {
            retry = connection.handleError(exception);
        }
        return retry;
    }

    protected boolean isErrorSpec(IFileSpec spec) {
        return spec != null && FileSpecOpStatus.ERROR == spec.getOpStatus() && spec.getStatusMessage() != null && spec.getSeverityCode() > 2 && !spec.getStatusMessage().endsWith("- no such file(s).") && !spec.getStatusMessage().endsWith("file(s) up-to-date.") && !spec.getStatusMessage().endsWith("file(s) not opened on this client.") && !spec.getStatusMessage().endsWith("file(s) not opened for edit.") && !spec.getStatusMessage().endsWith("file(s) not on client.");
    }

    @Override
    public void handleErrors(IFileSpec[] specs) {
        IErrorHandler handler = this.errorHandler;
        IP4Connection connection = this.getConnection();
        if (handler != null) {
            IFileSpec[] iFileSpecArray = specs;
            int n = specs.length;
            int n2 = 0;
            while (n2 < n) {
                IFileSpec spec = iFileSpecArray[n2];
                if (this.isErrorSpec(spec)) {
                    handler.handleErrorSpecs(specs);
                    break;
                }
                ++n2;
            }
        } else if (connection != null) {
            connection.handleErrors(specs);
        }
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public boolean isCaseSensitive() {
        IP4Connection connection = this.getConnection();
        return connection != null ? connection.isCaseSensitive() : true;
    }
}

