/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4ProgressListener;
import com.perforce.team.core.p4java.IP4ProgressPresenter;
import com.perforce.team.core.p4java.TextProgressPresenter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class P4ProgressListener
implements IP4ProgressListener {
    private List<IFileSpec> fileSpecs = new ArrayList<IFileSpec>();
    protected String command;
    protected int totalFileCount;
    protected int currentCount;
    private IP4ProgressPresenter presenter = new TextProgressPresenter();
    private IP4Connection connection;
    private boolean cancelled = false;

    public P4ProgressListener(String command, IP4Connection connection) {
        this.command = command;
        this.connection = connection;
    }

    public IP4ProgressPresenter getPresenter() {
        return this.presenter;
    }

    public void setPresenter(IP4ProgressPresenter presenter) {
        this.presenter = presenter;
    }

    public boolean startResults(int key) throws P4JavaException {
        this.currentCount = 0;
        return true;
    }

    public boolean handleResult(Map<String, Object> resultMap, int key) throws P4JavaException {
        if (this.presenter.isCancelled()) {
            this.presenter.end();
            this.cancelled = true;
            return false;
        }
        if (this.command.startsWith("sync")) {
            this.handleSync(resultMap, key);
        } else if (this.command.startsWith("submit")) {
            this.handleSubmit(resultMap, key);
        } else {
            this.fileSpecs.add(P4CoreUtils.extractFileSpec(resultMap, this.connection));
        }
        return true;
    }

    private void handleSubmit(Map<String, Object> resultMap, int key) throws P4JavaException {
        if (resultMap.containsKey("locked")) {
            String total = (String)resultMap.get("locked");
            this.totalFileCount = Integer.parseInt(total);
            this.currentCount = 0;
            this.presenter.begin(this.command, this.totalFileCount);
        }
        this.processUpdate(resultMap, key);
    }

    private void handleSync(Map<String, Object> resultMap, int key) throws P4JavaException {
        if (resultMap.containsKey("totalFileCount")) {
            String total = (String)resultMap.get("totalFileCount");
            this.totalFileCount = Integer.parseInt(total);
            this.currentCount = 0;
            this.presenter.begin(this.command, this.totalFileCount);
        }
        this.processUpdate(resultMap, key);
    }

    private void processUpdate(Map<String, Object> resultMap, int key) throws P4JavaException {
        String depotFile = (String)resultMap.get("depotFile");
        String localFile = (String)resultMap.get("path");
        if (depotFile != null) {
            this.presenter.update(this.totalFileCount, this.currentCount, 1, depotFile);
            ++this.currentCount;
            this.fileSpecs.add(P4CoreUtils.extractFileSpec(resultMap, this.connection));
        } else if (localFile != null) {
            Object curSize = resultMap.get("currentSize");
            Object fileSize = resultMap.get("fileSize");
            long total = this.parseSize(fileSize);
            long cur = this.parseSize(curSize);
            if (total > 0L && cur > 0L) {
                double rate = (double)cur / (double)total;
                int percent = (int)(rate * 100.0);
                this.presenter.update(this.totalFileCount, this.currentCount, localFile, percent, total);
            }
        } else {
            IFileSpec spec = P4CoreUtils.extractFileSpec(resultMap, this.connection);
            if (spec != null) {
                this.fileSpecs.add(spec);
            }
        }
    }

    private long parseSize(Object size) {
        long result = -1L;
        if (size instanceof Integer) {
            result = ((Integer)size).intValue();
        } else if (size instanceof Long) {
            result = (Long)size;
        } else if (size instanceof Short) {
            result = ((Short)size).shortValue();
        } else if (size instanceof Byte) {
            result = ((Byte)size).byteValue();
        } else if (size instanceof BigInteger) {
            result = ((BigInteger)size).longValue();
        }
        return result;
    }

    public boolean endResults(int key) throws P4JavaException {
        this.presenter.end();
        return true;
    }

    @Override
    public List<IFileSpec> getFileSpecs() {
        return this.fileSpecs;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setConnection(IP4Connection conn) {
        this.connection = conn;
    }
}

