/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.IJob;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.server.IServer;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Resource;
import com.perforce.team.core.p4java.P4ServerOperation;
import java.util.Map;

public class P4Job
extends P4Resource
implements IP4Job {
    private IP4Connection connection = null;
    private IJob p4jJob = null;
    private IP4Changelist changelist;
    private String id;

    public P4Job(IJob job, IP4Connection connection, IP4Changelist changelist) {
        this.p4jJob = job;
        this.connection = connection;
        this.changelist = changelist;
        this.formatId();
    }

    private void formatId() {
        if (this.p4jJob != null) {
            int length;
            String rawId = this.p4jJob.getId();
            if (rawId != null && (length = rawId.length()) > 2 && rawId.charAt(0) == '\"' && rawId.charAt(length - 1) == '\"') {
                rawId = rawId.substring(1, length - 1).replace(' ', '_');
            }
            this.id = rawId;
        } else {
            this.id = null;
        }
    }

    public P4Job(IJob job, IP4Connection connection) {
        this(job, connection, null);
    }

    @Override
    public String getDescription() {
        String description = null;
        if (this.p4jJob != null) {
            description = this.p4jJob.getDescription();
        }
        return description;
    }

    @Override
    public Object getField(String name) {
        Map fields;
        Object fieldValue = null;
        if (name != null && this.p4jJob != null && (fields = this.p4jJob.getRawFields()) != null) {
            fieldValue = fields.get(name);
        }
        return fieldValue;
    }

    @Override
    public String[] getFieldNames() {
        Map rawFields;
        String[] fields = new String[]{};
        if (this.p4jJob != null && (rawFields = this.p4jJob.getRawFields()) != null) {
            fields = rawFields.keySet().toArray(new String[0]);
        }
        return fields;
    }

    @Override
    public Object[] getFieldValues() {
        Map rawFields;
        Object[] values = new Object[]{};
        if (this.p4jJob != null && (rawFields = this.p4jJob.getRawFields()) != null) {
            values = rawFields.values().toArray(new String[0]);
        }
        return values;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getActionPath() {
        return null;
    }

    @Override
    public String getActionPath(IP4Resource.Type type) {
        return null;
    }

    @Override
    public IClient getClient() {
        IClient client = null;
        if (this.connection != null) {
            client = this.connection.getClient();
        }
        return client;
    }

    @Override
    public String getClientPath() {
        return null;
    }

    @Override
    public IP4Connection getConnection() {
        return this.connection;
    }

    @Override
    public String getLocalPath() {
        return null;
    }

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public IP4Container getParent() {
        return this.changelist != null ? this.changelist : this.connection;
    }

    @Override
    public String getRemotePath() {
        return null;
    }

    @Override
    public boolean isContainer() {
        return false;
    }

    @Override
    public void refresh(int depth) {
        this.refresh();
    }

    @Override
    public void refresh() {
        P4ServerOperation op = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                IJob latestJob = server.getJob(P4Job.this.getId());
                P4Job.this.p4jJob = latestJob;
                P4Job.this.formatId();
            }
        };
        this.runOperation(op);
    }

    @Override
    public String getShortDescription() {
        String full = this.getDescription();
        if (full != null) {
            StringBuilder buffer = new StringBuilder(full);
            int i = 0;
            while (i < buffer.length()) {
                if (buffer.charAt(i) == '\n') {
                    buffer.setCharAt(i, ' ');
                }
                ++i;
            }
            if (buffer.length() > 256) {
                buffer.setLength(256);
            }
            return buffer.toString();
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IP4Job) {
            IP4Job other = (IP4Job)obj;
            if (!this.connectionEquals(other)) {
                return false;
            }
            String id = this.getId();
            String oId = other.getId();
            if (id != null && id.equals(oId)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        String id = this.getId();
        if (id != null) {
            return id.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public IJob getJob() {
        return this.p4jJob;
    }

    @Override
    public void update(IJob job) throws P4JavaException {
        IServer server;
        IP4Connection connection;
        if (job != null && (connection = this.getConnection()) != null && (server = connection.getServer()) != null) {
            try {
                server.updateJob(job);
            }
            catch (P4JavaError error) {
                PerforceProviderPlugin.logError(error);
            }
        }
    }
}

